/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client;

import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.banners.BannerGeneration;
import com.xcompwiz.mystcraft.client.BlockColorMyst;
import com.xcompwiz.mystcraft.client.entityfx.ParticleProviderLink;
import com.xcompwiz.mystcraft.client.entityfx.ParticleUtils;
import com.xcompwiz.mystcraft.client.gui.overlay.GuiNotification;
import com.xcompwiz.mystcraft.client.linkeffects.LinkRendererDisarm;
import com.xcompwiz.mystcraft.client.model.ModelInkMixer;
import com.xcompwiz.mystcraft.client.render.PageBuilder;
import com.xcompwiz.mystcraft.client.render.RenderBookReceptacle;
import com.xcompwiz.mystcraft.client.render.RenderBookstand;
import com.xcompwiz.mystcraft.client.render.RenderFallingBlock;
import com.xcompwiz.mystcraft.client.render.RenderLectern;
import com.xcompwiz.mystcraft.client.render.RenderLightningBoltAdv;
import com.xcompwiz.mystcraft.client.render.RenderLinkbook;
import com.xcompwiz.mystcraft.client.render.RenderMeteor;
import com.xcompwiz.mystcraft.client.render.RenderModel;
import com.xcompwiz.mystcraft.client.render.RenderStarFissure;
import com.xcompwiz.mystcraft.client.render.RenderWritingDesk;
import com.xcompwiz.mystcraft.client.shaders.ShaderUtils;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.data.ModFluids;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.entity.EntityFallingBlock;
import com.xcompwiz.mystcraft.entity.EntityLightningBoltAdv;
import com.xcompwiz.mystcraft.entity.EntityLinkbook;
import com.xcompwiz.mystcraft.entity.EntityMeteor;
import com.xcompwiz.mystcraft.error.MystcraftStartupChecker;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookReceptacle;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookstand;
import com.xcompwiz.mystcraft.tileentity.TileEntityDesk;
import com.xcompwiz.mystcraft.tileentity.TileEntityInkMixer;
import com.xcompwiz.mystcraft.tileentity.TileEntityLectern;
import com.xcompwiz.mystcraft.tileentity.TileEntityStarFissure;
import com.xcompwiz.mystcraft.world.profiling.InstabilityDataCalculator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MystcraftClientProxy
extends MystcraftCommonProxy {
    private MystcraftStartupChecker startupchecker;

    @Override
    public boolean isClientSideAvailable() {
        return true;
    }

    @Override
    public Entity getEntityByID(World worldObj, int id) {
        if (worldObj instanceof WorldClient) {
            return worldObj.func_73045_a(id);
        }
        return super.getEntityByID(worldObj, id);
    }

    public GuiNotification getNotificationGui() {
        return this.startupchecker.getNotificationGui();
    }

    @Override
    public void preinit() {
        OBJLoader.INSTANCE.addDomain("mystcraft");
        this.startupchecker = new MystcraftStartupChecker();
        MinecraftForge.EVENT_BUS.register((Object)this.startupchecker);
        MinecraftForge.EVENT_BUS.register((Object)new PageBuilder());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModFluids.registerModels();
        this.registerEntityRenderers();
    }

    @Override
    public void init() {
        ModBlocks.registerModelColors();
        ModItems.registerModelColors();
        this.registerTileEntityRenderers();
        InternalAPI.render.registerRenderEffect(new LinkRendererDisarm());
        ParticleUtils.registerParticle("link", new ParticleProviderLink());
        this.initBlockColorizations();
    }

    private void initBlockColorizations() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        Map blockColorMap = (Map)ObfuscationReflectionHelper.getPrivateValue(BlockColors.class, (Object)blockColors, (int)0);
        blockColors.func_186722_a((IBlockColor)new BlockColorMyst((IBlockColor)blockColorMap.get(Blocks.field_150349_c.delegate), "grass"), new Block[]{Blocks.field_150349_c});
        blockColors.func_186722_a((IBlockColor)new BlockColorMyst((IBlockColor)blockColorMap.get(Blocks.field_150329_H.delegate), "grass"), new Block[]{Blocks.field_150329_H});
        blockColors.func_186722_a((IBlockColor)new BlockColorMyst((IBlockColor)blockColorMap.get(Blocks.field_150362_t.delegate), "foliage"), new Block[]{Blocks.field_150362_t});
        blockColors.func_186722_a((IBlockColor)new BlockColorMyst((IBlockColor)blockColorMap.get(Blocks.field_150361_u.delegate), "foliage"), new Block[]{Blocks.field_150361_u});
        blockColors.func_186722_a((IBlockColor)new BlockColorMyst((IBlockColor)blockColorMap.get(Blocks.field_150395_bd.delegate), "foliage"), new Block[]{Blocks.field_150395_bd});
        blockColors.func_186722_a((IBlockColor)new BlockColorMyst((IBlockColor)blockColorMap.get(Blocks.field_150392_bi.delegate), "foliage"), new Block[]{Blocks.field_150392_bi});
        blockColors.func_186722_a((IBlockColor)new BlockColorMyst((IBlockColor)blockColorMap.get(Blocks.field_150394_bc.delegate), "foliage"), new Block[]{Blocks.field_150394_bc});
        blockColors.func_186722_a((IBlockColor)new BlockColorMyst((IBlockColor)blockColorMap.get(Blocks.field_150355_j.delegate), "water"), new Block[]{Blocks.field_150355_j});
        blockColors.func_186722_a((IBlockColor)new BlockColorMyst((IBlockColor)blockColorMap.get(Blocks.field_150358_i.delegate), "water"), new Block[]{Blocks.field_150358_i});
    }

    @SubscribeEvent
    public void initModels(ModelRegistryEvent event) {
        ModBlocks.registerModels();
        ModItems.registerModels();
    }

    private void registerEntityRenderers() {
        LoggerUtils.info("Adding Entity Renderers", new Object[0]);
        RenderingRegistry.registerEntityRenderingHandler(EntityFallingBlock.class, (IRenderFactory)new RenderFallingBlock.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningBoltAdv.class, (IRenderFactory)new RenderLightningBoltAdv.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityLinkbook.class, (IRenderFactory)new RenderLinkbook.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityMeteor.class, (IRenderFactory)new RenderMeteor.Factory());
    }

    private void registerTileEntityRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDesk.class, (TileEntitySpecialRenderer)new RenderWritingDesk());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStarFissure.class, (TileEntitySpecialRenderer)new RenderStarFissure());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBookReceptacle.class, (TileEntitySpecialRenderer)new RenderBookReceptacle());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityInkMixer.class, new RenderModel(new ModelInkMixer(), Assets.Entities.inkmixer));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBookstand.class, (TileEntitySpecialRenderer)new RenderBookstand());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLectern.class, (TileEntitySpecialRenderer)new RenderLectern());
    }

    @Override
    public void initShaders() {
        ShaderUtils.registerShaders();
    }

    @Override
    public void spawnParticle(String particle, double x, double y, double z, double motionX, double motionY, double motionZ) {
        ParticleUtils.spawnParticle(particle, x, y, z, motionX, motionY, motionZ);
    }

    @Override
    public void startBaselineProfiling(MinecraftServer mcserver) {
        if (InstabilityDataCalculator.isPerSave()) {
            super.startBaselineProfiling(mcserver);
        }
    }

    @Override
    public void stopBaselineProfiling() {
        if (InstabilityDataCalculator.isPerSave()) {
            super.stopBaselineProfiling();
        }
    }

    @Override
    public void addScheduledTask(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    @Override
    public void registerBannerPattern(String word, BannerPattern pattern) {
        super.registerBannerPattern(word, pattern);
        ResourceLocation location = new ResourceLocation("textures/entity/banner/" + pattern.func_190997_a() + ".png");
        MinecraftForgeClient.registerImageLayerSupplier((ResourceLocation)location, () -> BannerGeneration.createBufferedImage(word));
        location = new ResourceLocation("textures/entity/shield/" + pattern.func_190997_a() + ".png");
        MinecraftForgeClient.registerImageLayerSupplier((ResourceLocation)location, () -> BannerGeneration.createBufferedImage(word));
    }
}

