/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui;

import com.xcompwiz.mystcraft.api.item.IItemPageCollection;
import com.xcompwiz.mystcraft.api.item.IItemPageProvider;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementButton;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementButtonToggle;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementPageSurface;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementTextField;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.page.SortingUtils;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public abstract class GuiElementSurfaceControlsBase
implements GuiElementPageSurface.IGuiPositionedPagesProvider,
GuiElementButton.IGuiOnClickHandler,
GuiElementButtonToggle.IGuiStateProvider,
GuiElementTextField.IGuiTextProvider,
GuiElementTextField.IGuiOnTextChange {
    private Minecraft mc;
    private float xSize;
    @Nonnull
    private ItemStack cached_tabitem = ItemStack.field_190927_a;
    private List<GuiElementPageSurface.PositionableItem> arranged_pages;
    private Comparator<ItemStack> sorttype = SortingUtils.ComparatorItemSymbolAlphabetical.instance;
    private boolean showall = false;
    private Collection<GuiElement> surfaceelements = new HashSet<GuiElement>();
    private List<GuiElementTextField.IGuiOnTextChange> listeners = new ArrayList<GuiElementTextField.IGuiOnTextChange>();
    private String searchtext = null;

    public GuiElementSurfaceControlsBase(Minecraft mc, int guiLeft, int guiTop, int width, int height) {
        this.mc = mc;
        this.xSize = width;
    }

    @Override
    @Nonnull
    public abstract ItemStack getItemStack();

    @Override
    public List<GuiElementPageSurface.PositionableItem> getPositionedPages() {
        ItemStack itemstack = this.getItemStack();
        if (!ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.cached_tabitem)) {
            if (itemstack.func_190926_b()) {
                this.cached_tabitem = ItemStack.field_190927_a;
                this.arranged_pages = null;
                return null;
            }
            this.cached_tabitem = itemstack.func_77946_l();
            this.updateCollection();
        }
        return this.arranged_pages;
    }

    public void addSurfaceElement(GuiElement elem) {
        this.surfaceelements.add(elem);
    }

    private void updateCollection() {
        this.arranged_pages = null;
        if (this.cached_tabitem.func_190926_b()) {
            return;
        }
        boolean iscollection = this.cached_tabitem.func_77973_b() instanceof IItemPageCollection;
        for (GuiElement element : this.surfaceelements) {
            element.setEnabled(iscollection);
        }
        if (iscollection) {
            IItemPageCollection item = (IItemPageCollection)this.cached_tabitem.func_77973_b();
            HashMap<NBTTagCompound, GuiElementPageSurface.PositionableItem> collection = new HashMap<NBTTagCompound, GuiElementPageSurface.PositionableItem>();
            List<ItemStack> pages = item.getItems((EntityPlayer)this.mc.field_71439_g, this.cached_tabitem);
            if (pages != null) {
                for (ItemStack page : pages) {
                    if (page.func_77978_p() != null) {
                        String displayname = null;
                        if (Page.getSymbol(page) != null) {
                            ResourceLocation id;
                            IAgeSymbol symbol2 = SymbolManager.getAgeSymbol(Page.getSymbol(page));
                            if (symbol2 != null) {
                                displayname = symbol2.getLocalizedName();
                            }
                            if (displayname == null && (id = Page.getSymbol(page)) != null) {
                                displayname = id.func_110623_a();
                            }
                        }
                        if (this.searchtext != null && this.searchtext.length() > 0 && (displayname == null || !displayname.toLowerCase().contains(this.searchtext.toLowerCase()))) continue;
                    }
                    ItemStack copy = page.func_77946_l();
                    copy.func_190920_e(1);
                    NBTTagCompound key = new NBTTagCompound();
                    copy.func_77955_b(key);
                    GuiElementPageSurface.PositionableItem newpos = (GuiElementPageSurface.PositionableItem)collection.get(key);
                    if (newpos == null) {
                        newpos = new GuiElementPageSurface.PositionableItem();
                        newpos.itemstack = page;
                        newpos.count = page.func_190916_E();
                        collection.put(key, newpos);
                        continue;
                    }
                    newpos.count += page.func_190916_E();
                }
            }
            if (this.showall) {
                ArrayList<IAgeSymbol> symbols = SymbolManager.getAgeSymbols();
                for (IAgeSymbol symbol3 : symbols) {
                    ResourceLocation symbolname = symbol3.getRegistryName();
                    String displayname = symbol3.getLocalizedName();
                    if (this.searchtext != null && this.searchtext.length() > 0 && (displayname == null || !displayname.toLowerCase().contains(this.searchtext.toLowerCase()))) continue;
                    ItemStack page = Page.createSymbolPage(symbolname);
                    NBTTagCompound key = new NBTTagCompound();
                    page.func_77955_b(key);
                    GuiElementPageSurface.PositionableItem newpos = (GuiElementPageSurface.PositionableItem)collection.get(key);
                    if (newpos != null) continue;
                    newpos = new GuiElementPageSurface.PositionableItem();
                    newpos.itemstack = page;
                    newpos.count = 0;
                    collection.put(key, newpos);
                }
            }
            this.arranged_pages = new LinkedList<GuiElementPageSurface.PositionableItem>();
            this.arranged_pages.addAll(collection.values());
            this.sort(this.sorttype);
        } else if (this.cached_tabitem.func_77973_b() instanceof IItemPageProvider) {
            int i = 0;
            IItemPageProvider item = (IItemPageProvider)this.cached_tabitem.func_77973_b();
            List<ItemStack> pages = item.getPageList((EntityPlayer)this.mc.field_71439_g, this.cached_tabitem);
            this.arranged_pages = new LinkedList<GuiElementPageSurface.PositionableItem>();
            for (ItemStack page : pages) {
                GuiElementPageSurface.PositionableItem newpos = new GuiElementPageSurface.PositionableItem();
                newpos.itemstack = page;
                newpos.slotId = i++;
                newpos.count = 1;
                this.arranged_pages.add(newpos);
            }
        }
        if (this.arranged_pages != null) {
            this.arrange();
        }
    }

    public void arrange() {
        float xStep = 31.0f;
        float yStep = 41.0f;
        float x = 0.0f;
        float y = 0.0f;
        for (GuiElementPageSurface.PositionableItem page : this.arranged_pages) {
            page.x = x;
            page.y = y;
            if (!((x += xStep) + xStep > this.xSize)) continue;
            x = 0.0f;
            y += yStep;
        }
    }

    public void sort(Comparator<ItemStack> comparator) {
        this.arranged_pages.sort((arg0, arg1) -> comparator.compare(arg0.itemstack, arg1.itemstack));
    }

    @Override
    public void onClick(GuiElementButton caller) {
        if (caller.getId().equals("AZ")) {
            this.sorttype = SortingUtils.ComparatorItemSymbolAlphabetical.instance;
            this.updateCollection();
        } else if (caller.getId().equals("ALL")) {
            this.showall = !this.showall;
            this.updateCollection();
        }
    }

    @Override
    public boolean getState(String id) {
        if (id.equals("AZ")) {
            return this.sorttype == SortingUtils.ComparatorItemSymbolAlphabetical.instance;
        }
        if (id.equals("ALL")) {
            return this.showall;
        }
        return false;
    }

    @Override
    public String getText(GuiElementTextField caller) {
        return this.searchtext;
    }

    @Override
    public void onTextChange(GuiElementTextField caller, String newtext) {
        this.searchtext = newtext;
        if (!this.cached_tabitem.func_190926_b() && this.cached_tabitem.func_77973_b() instanceof IItemPageCollection) {
            this.updateCollection();
        }
        for (GuiElementTextField.IGuiOnTextChange listener : this.listeners) {
            listener.onTextChange(caller, this.searchtext);
        }
    }

    public void addListener(GuiElementTextField.IGuiOnTextChange listener) {
        this.listeners.add(listener);
    }
}

