/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.inventory.ContainerBase;
import com.xcompwiz.mystcraft.inventory.SlotCollection;
import com.xcompwiz.mystcraft.inventory.SlotCraftCustom;
import com.xcompwiz.mystcraft.inventory.SlotFiltered;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketGuiMessage;
import com.xcompwiz.mystcraft.tileentity.TileEntityInkMixer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ContainerInkMixer
extends ContainerBase
implements IGuiMessageHandler {
    private static int shift = 0;
    private InvWrapper craftResult = new InvWrapper((IInventory)new InventoryCraftResult());
    private TileEntityInkMixer tileentity;
    private boolean cached_hasink = false;
    private long cached_seed = 0L;
    private HashMap<String, Float> properties = new HashMap();
    private ColorGradient propertyGradient = null;

    public ContainerInkMixer(InventoryPlayer inventoryplayer, TileEntityInkMixer tileentity) {
        this.tileentity = tileentity;
        this.func_75146_a((Slot)new SlotFiltered((IItemHandlerModifiable)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), tileentity, 0, 8 + shift, 27));
        this.func_75146_a((Slot)new SlotFiltered((IItemHandlerModifiable)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), tileentity, 1, 8 + shift, 48));
        this.func_75146_a((Slot)new SlotFiltered((IItemHandlerModifiable)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), tileentity, 2, 152 + shift, 27));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18 + shift, 99 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, j, 8 + j * 18 + shift, 157));
        }
        this.func_75146_a((Slot)new SlotCraftCustom(inventoryplayer.field_70458_d, tileentity, (IItemHandlerModifiable)this.craftResult, 0, 152 + shift, 48));
        SlotCollection internal = null;
        SlotCollection maininv = null;
        SlotCollection hotbar = null;
        internal = new SlotCollection(this, 0, 3);
        maininv = new SlotCollection(this, 3, 30);
        hotbar = new SlotCollection(this, 30, 39);
        internal.pushTargetFront(maininv);
        internal.pushTargetFront(hotbar);
        maininv.pushTargetFront(hotbar);
        maininv.pushTargetFront(internal);
        hotbar.pushTargetFront(maininv);
        hotbar.pushTargetFront(internal);
        this.collections.add(internal);
        this.collections.add(maininv);
        this.collections.add(hotbar);
    }

    public void func_75130_a(IInventory par1IInventory) {
        super.func_75130_a(par1IInventory);
    }

    public void func_75142_b() {
        NBTTagCompound nbttagcompound;
        super.func_75142_b();
        ArrayList<MPacketGuiMessage> packets = new ArrayList<MPacketGuiMessage>();
        if (this.cached_hasink != this.tileentity.getHasInk()) {
            this.cached_hasink = this.tileentity.getHasInk();
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74757_a("SetInk", this.cached_hasink);
            packets.add(new MPacketGuiMessage(this.field_75152_c, nbttagcompound));
        }
        if (this.cached_seed != this.tileentity.getNextSeed()) {
            this.cached_seed = this.tileentity.getNextSeed();
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74772_a("SetSeed", this.cached_seed);
            packets.add(new MPacketGuiMessage(this.field_75152_c, nbttagcompound));
        }
        Map<String, Float> ink_probs = this.tileentity.getInkProperties();
        boolean changed = false;
        if (ink_probs.size() != this.properties.size()) {
            changed = true;
        } else {
            for (Map.Entry<String, Float> entry : ink_probs.entrySet()) {
                Float cached = this.properties.get(entry.getKey());
                if (cached != null && cached.equals(entry.getValue())) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            NBTTagCompound probabilities = new NBTTagCompound();
            this.properties.clear();
            for (Map.Entry<String, Float> entry : ink_probs.entrySet()) {
                this.properties.put(entry.getKey(), entry.getValue());
                probabilities.func_74776_a(entry.getKey(), entry.getValue().floatValue());
            }
            nbttagcompound2.func_74782_a("SetProperties", (NBTBase)probabilities);
            packets.add(new MPacketGuiMessage(this.field_75152_c, nbttagcompound2));
        }
        if (packets.size() > 0) {
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                for (IMessage iMessage : packets) {
                    MystcraftPacketHandler.CHANNEL.sendTo(iMessage, (EntityPlayerMP)listener);
                }
            }
        }
        this.updateCraftResult();
    }

    public void updateCraftResult() {
        this.craftResult.setStackInSlot(0, this.tileentity.getCraftedItem());
    }

    public void func_75137_b(int i, int j) {
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public void processMessage(@Nonnull EntityPlayer player, @Nonnull NBTTagCompound data) {
        if (data.func_74764_b("SetInk")) {
            this.cached_hasink = data.func_74767_n("SetInk");
            this.tileentity.setHasInk(this.cached_hasink);
        }
        if (data.func_74764_b("SetSeed")) {
            this.cached_seed = data.func_74763_f("SetSeed");
            this.tileentity.setNextSeed(this.cached_seed);
        }
        if (data.func_74764_b("SetProperties")) {
            this.properties.clear();
            NBTTagCompound probabilities = data.func_74775_l("SetProperties");
            for (String tagname : probabilities.func_150296_c()) {
                this.properties.put(tagname, Float.valueOf(probabilities.func_74760_g(tagname)));
            }
            this.rebuildGradient();
        }
        if (data.func_74764_b("Consume")) {
            if (player.field_71071_by.func_70445_o().func_190926_b()) {
                return;
            }
            if (!this.tileentity.getHasInk()) {
                return;
            }
            ItemStack itemstack = player.field_71071_by.func_70445_o();
            int amount = itemstack.func_190916_E();
            if (data.func_74767_n("Single")) {
                amount = 1;
            }
            player.field_71071_by.func_70437_b(this.tileentity.addItems(itemstack, amount));
        }
    }

    private void rebuildGradient() {
        this.propertyGradient = InternalAPI.linkProperties.getPropertiesGradient(this.properties);
    }

    public boolean func_94530_a(@Nonnull ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.craftResult && super.func_94530_a(stack, slot);
    }

    public boolean hasInk() {
        return this.cached_hasink;
    }

    public ColorGradient getPropertyGradient() {
        return this.propertyGradient;
    }

    public static class Messages {
        public static final String SetSeed = "SetSeed";
        public static final String SetInk = "SetInk";
        public static final String SetProperties = "SetProperties";
        public static final String Consume = "Consume";
    }
}

