/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.inventory.ContainerBase;
import com.xcompwiz.mystcraft.inventory.InventoryVillager;
import com.xcompwiz.mystcraft.inventory.SlotCollection;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketGuiMessage;
import com.xcompwiz.mystcraft.villager.VillagerTradeSystem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerVillagerShop
extends ContainerBase
implements IGuiMessageHandler {
    private IItemHandlerModifiable handlerPlayer;
    private InventoryPlayer inventoryPlayer;
    private EntityVillager villager;
    private InventoryVillager villagerinv;
    private long villagerinv_timestamp;
    private Integer playerEmeralds;
    private long lastEmeraldsUpdate;

    public ContainerVillagerShop(EntityPlayer player, EntityVillager villager) {
        this.handlerPlayer = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        this.inventoryPlayer = player.field_71071_by;
        this.villager = villager;
        this.villagerinv = VillagerTradeSystem.getVillagerInventory(villager);
        this.updateSlots();
    }

    public void updateSlots() {
        int i;
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handlerPlayer, j + i * 9 + 9, 8 + j * 18, 99 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handlerPlayer, i, 8 + i * 18, 157));
        }
        this.collections.clear();
        SlotCollection maininv = new SlotCollection(this, 0, 27);
        SlotCollection hotbar = new SlotCollection(this, 27, 36);
        maininv.pushTargetFront(hotbar);
        hotbar.pushTargetFront(maininv);
        this.collections.add(maininv);
        this.collections.add(hotbar);
    }

    public void func_75142_b() {
        ArrayList<MPacketGuiMessage> packets = new ArrayList<MPacketGuiMessage>();
        for (int slotId = 0; slotId < this.field_75151_b.size(); ++slotId) {
            ItemStack actual = ((Slot)this.field_75151_b.get(slotId)).func_75211_c();
            ItemStack stored = (ItemStack)this.field_75153_a.get(slotId);
            if (ItemStack.func_77989_b((ItemStack)stored, (ItemStack)actual)) continue;
            stored = actual.func_190926_b() ? ItemStack.field_190927_a : actual.func_77946_l();
            this.field_75153_a.set(slotId, (Object)stored);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((Container)this, slotId, stored);
            }
        }
        if (this.villagerinv_timestamp != this.villagerinv.getLastChanged()) {
            this.villagerinv_timestamp = this.villagerinv.getLastChanged();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound inventorynbt = new NBTTagCompound();
            this.villagerinv.writeToNBT(inventorynbt);
            nbttagcompound.func_74782_a("UVC", (NBTBase)inventorynbt);
            packets.add(new MPacketGuiMessage(this.field_75152_c, nbttagcompound));
        }
        if (packets.size() > 0) {
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                for (IMessage iMessage : packets) {
                    MystcraftPacketHandler.CHANNEL.sendTo(iMessage, (EntityPlayerMP)listener);
                }
            }
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        if (this.villager.field_70128_L) {
            return false;
        }
        return entityplayer.func_70092_e(this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v) <= 64.0;
    }

    @Override
    public void processMessage(@Nonnull EntityPlayer player, @Nonnull NBTTagCompound data) {
        int index;
        if (data.func_74764_b("UVC")) {
            if (this.villager.field_70170_p.field_72995_K) {
                this.villagerinv.readFromNBT(data.func_74775_l("UVC"));
            }
            return;
        }
        if (data.func_74764_b("PB")) {
            if (this.villagerinv.purchaseBooster(this.handlerPlayer, this.inventoryPlayer)) {
                this.getPlayerEmeralds(true);
            }
            return;
        }
        if (data.func_74764_b("PI") && this.villagerinv.purchaseShopItem(this.handlerPlayer, this.inventoryPlayer, index = data.func_74762_e("PI"))) {
            this.getPlayerEmeralds(true);
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        VillagerTradeSystem.release(this.villagerinv);
    }

    @Nonnull
    public ItemStack getShopItem(int index) {
        return this.villagerinv.getShopItem(index);
    }

    public int getShopItemPrice(int index) {
        return this.villagerinv.getShopItemPrice(index);
    }

    public int getBoosterCount() {
        return this.villagerinv.getBoosterCount();
    }

    public int getBoosterCost() {
        return this.villagerinv.getBoosterCost();
    }

    public int getPlayerEmeralds() {
        return this.getPlayerEmeralds(false);
    }

    private int getPlayerEmeralds(boolean forceupdate) {
        if (this.playerEmeralds == null || forceupdate || this.lastEmeraldsUpdate + 100L < this.villager.field_70170_p.func_82737_E()) {
            this.lastEmeraldsUpdate = this.villager.field_70170_p.func_82737_E();
            this.playerEmeralds = this.villagerinv.getPlayerEmeralds(this.handlerPlayer);
        }
        return this.playerEmeralds;
    }

    public static class Messages {
        public static final String UpdateVillagerCollection = "UVC";
        public static final String PurchaseBooster = "PB";
        public static final String PurchaseItem = "PI";
    }
}

