/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.event.PortalLinkEvent;
import com.xcompwiz.mystcraft.api.item.IItemPortalActivator;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.data.ModGUIs;
import com.xcompwiz.mystcraft.entity.EntityLinkbook;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.linking.LinkController;
import com.xcompwiz.mystcraft.linking.LinkListenerManager;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemLinking
extends Item
implements IItemPortalActivator {
    protected ItemLinking() {
        this.func_77625_d(1);
        this.func_77656_e(10);
        this.setNoRepair();
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack itemstack, @Nonnull ItemStack enchantbook) {
        return false;
    }

    protected abstract void initialize(@Nullable World var1, @Nonnull ItemStack var2, @Nullable Entity var3);

    public void func_77663_a(@Nonnull ItemStack itemstack, World world, Entity entity, int itemSlot, boolean flag) {
        if (world.field_72995_K) {
            return;
        }
        this.validate(world, itemstack, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemstack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String name;
        if (itemstack.func_77978_p() != null && !(name = LinkOptions.getDisplayName(itemstack.func_77978_p())).isEmpty()) {
            tooltip.add(name);
        }
    }

    public void activate(@Nonnull ItemStack itemstack, World world, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if (itemstack.func_77978_p() == null) {
            return;
        }
        ILinkInfo linkinfo = this.getLinkInfo(itemstack);
        if (linkinfo != null && LinkListenerManager.isLinkPermitted(world, entity, linkinfo)) {
            LinkOptions.setUUID(itemstack.func_77978_p(), DimensionUtils.getDimensionUUID(linkinfo.getDimensionUID()));
            this.onLink(itemstack, world, entity);
            LinkController.travelEntity(world, entity, linkinfo);
        }
    }

    protected void onLink(@Nonnull ItemStack itemstack, World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            if (entityplayer.field_71071_by.func_70448_g() != itemstack) {
                return;
            }
            if (this.dropItemOnLink(itemstack)) {
                world.func_72838_d(this.createEntity(world, (Entity)entityplayer, itemstack));
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void onPortalCollision(@Nonnull ItemStack itemstack, World worldObj, Entity entity, BlockPos pos) {
        ILinkInfo info = ((ItemLinking)itemstack.func_77973_b()).getLinkInfo(itemstack);
        info.setFlag("Maintain Momentum", true);
        info.setFlag("Generate Platform", false);
        info.setFlag("External", true);
        info.setProperty("Sound", "mystcraft:linking.link-portal");
        MinecraftForge.EVENT_BUS.post((Event)new PortalLinkEvent(worldObj, entity, info));
        LinkController.travelEntity(worldObj, entity, info);
    }

    @Override
    public int getPortalColor(@Nonnull ItemStack itemstack, World worldObj) {
        ILinkInfo info = ((ItemLinking)itemstack.func_77973_b()).getLinkInfo(itemstack);
        return DimensionUtils.getLinkColor(info);
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return LinkOptions.getFlag(stack.func_77978_p(), "Following");
    }

    public boolean hasCustomEntity(@Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public Entity createEntity(World world, Entity location, @Nonnull ItemStack itemstack) {
        return new EntityLinkbook(world, location, itemstack);
    }

    public boolean dropItemOnLink(@Nonnull ItemStack itemstack) {
        return !LinkOptions.getFlag(itemstack.func_77978_p(), "Following");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack inHand = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)inHand);
        }
        playerIn.openGui((Object)Mystcraft.instance, ModGUIs.BOOK.ordinal(), worldIn, MathHelper.func_76128_c((double)(playerIn.field_70165_t + 0.5)), MathHelper.func_76128_c((double)(playerIn.field_70163_u + 0.5)), MathHelper.func_76128_c((double)(playerIn.field_70161_v + 0.5)));
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)inHand);
    }

    public boolean isDamaged(@Nonnull ItemStack stack) {
        return ItemLinking.getHealth(stack) != ItemLinking.getMaxHealth(stack);
    }

    public int getDamage(@Nonnull ItemStack stack) {
        return (int)ItemLinking.getMaxHealth(stack) - (int)ItemLinking.getHealth(stack);
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return (int)ItemLinking.getMaxHealth(stack) - (int)ItemLinking.getHealth(stack);
    }

    public void setDamage(@Nonnull ItemStack stack, int damage) {
        ItemLinking.setHealth(stack, ItemLinking.getMaxHealth(stack) - (float)damage);
    }

    public int getMaxDamage(@Nonnull ItemStack stack) {
        return (int)ItemLinking.getMaxHealth(stack);
    }

    public static void setHealth(@Nonnull ItemStack book, float health) {
        if (book.func_190926_b()) {
            return;
        }
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        book.func_77978_p().func_74776_a("damage", ItemLinking.getMaxHealth(book) - health);
    }

    public static float getHealth(@Nonnull ItemStack book) {
        float health = ItemLinking.getMaxHealth(book);
        if (book.func_190926_b()) {
            return health;
        }
        if (book.func_77978_p() == null) {
            return health;
        }
        Float damage = Float.valueOf(book.func_77978_p().func_74760_g("damage"));
        return health -= damage.floatValue();
    }

    public static float getMaxHealth(@Nonnull ItemStack book) {
        float health = 10.0f;
        if (book.func_190926_b()) {
            return health;
        }
        if (book.func_77978_p() == null) {
            return health;
        }
        if (!book.func_77978_p().func_74764_b("MaxHealth")) {
            book.func_77978_p().func_74776_a("MaxHealth", health);
        }
        health = book.func_77978_p().func_74760_g("MaxHealth");
        return health;
    }

    public void validate(@Nullable World worldObj, @Nonnull ItemStack itemstack, @Nullable Entity entity) {
        if (itemstack.func_77978_p() == null) {
            this.initialize(worldObj, itemstack, entity);
        }
    }

    @Nonnull
    public String getTitle(@Nonnull ItemStack itemstack) {
        if (itemstack.func_77978_p() != null) {
            return LinkOptions.getDisplayName(itemstack.func_77978_p());
        }
        return "";
    }

    @Nullable
    public ILinkInfo getLinkInfo(@Nonnull ItemStack itemstack) {
        if (itemstack.func_77978_p() != null) {
            return new LinkOptions(itemstack.func_77978_p());
        }
        return null;
    }

    public Collection<String> getAuthors(@Nonnull ItemStack book) {
        return Collections.emptySet();
    }
}

