/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.linking;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.event.LinkEvent;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.linking.LinkListenerManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LinkController {
    public static boolean travelEntity(World world, Entity entity, ILinkInfo info) {
        if (world.field_72995_K) {
            return false;
        }
        if (info == null) {
            return false;
        }
        Integer dimension = (info = info.clone()).getDimensionUID();
        if (dimension == null) {
            return false;
        }
        BlockPos spawn = info.getSpawn();
        float yaw = info.getSpawnYaw();
        if (!LinkListenerManager.isLinkPermitted(world, entity, info)) {
            return false;
        }
        entity = entity.func_184208_bv();
        MinecraftServer mcServer = Mystcraft.sidedProxy.getMCServer();
        if (mcServer == null || dimension != 0 && !mcServer.func_71255_r()) {
            return false;
        }
        WorldServer newworld = mcServer.func_71218_a(dimension.intValue());
        if (newworld == null) {
            System.err.println("Cannot Link Entity to Dimension: Could not get World for Dimension " + dimension);
            return false;
        }
        if (spawn == null) {
            spawn = newworld.func_175694_M();
            info.setSpawn(spawn);
        }
        LinkEvent.LinkEventAlter event = new LinkEvent.LinkEventAlter(world, (World)newworld, entity, info.clone());
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.spawn != null) {
            spawn = event.spawn;
            info.setSpawn(spawn);
        }
        if (event.rotationYaw != null) {
            yaw = event.rotationYaw.floatValue();
            info.setSpawnYaw(yaw);
        }
        LinkController.teleportEntity((World)newworld, entity, dimension, spawn, yaw, info);
        return true;
    }

    private static Entity teleportEntity(World newworld, Entity entity, int dimension, BlockPos spawn, float yaw, ILinkInfo info) {
        List passengers = entity.func_184188_bt();
        ArrayList<Entity> successfulPassengers = new ArrayList<Entity>();
        for (Entity mounted : passengers) {
            mounted.func_184210_p();
            Entity result = LinkController.teleportEntity(newworld, mounted, dimension, spawn, yaw, info);
            if (result == null) continue;
            successfulPassengers.add(result);
        }
        World origin = entity.func_130014_f_();
        if (!LinkListenerManager.isLinkPermitted(origin, entity, info)) {
            return null;
        }
        LinkListenerManager.onLinkStart(origin, entity, info);
        if (entity.func_70093_af()) {
            entity.func_70095_a(false);
        }
        if (origin != newworld) {
            Entity result = entity.changeDimension(dimension, (ITeleporter)new LinkTeleporter(spawn, yaw, info));
            if (result == null) {
                LinkListenerManager.onLinkFailed(origin, entity, info);
                return null;
            }
            entity = result;
        } else {
            entity.func_70012_b((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5, yaw, entity.field_70125_A);
        }
        ((WorldServer)newworld).func_72863_F().func_186028_c(spawn.func_177958_n() >> 4, spawn.func_177952_p() >> 4);
        while (LinkController.getCollidingWorldGeometry(newworld, entity.func_174813_aQ(), entity).size() != 0) {
            spawn = spawn.func_177984_a();
            entity.func_70107_b((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_71135_a.func_147364_a((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
            newworld.func_72866_a(entity, false);
            if (player.field_71070_bA != null) {
                player.func_71128_l();
                player.func_71053_j();
            }
        }
        LinkListenerManager.onLinkEnd(origin, newworld, entity, info);
        for (Entity passenger : successfulPassengers) {
            if (passenger instanceof EntityPlayerMP) {
                newworld.func_72866_a(passenger, true);
            }
            passenger.func_184220_m(entity);
        }
        return entity;
    }

    private static List<AxisAlignedBB> getCollidingWorldGeometry(World world, AxisAlignedBB axisalignedbb, Entity entity) {
        ArrayList<AxisAlignedBB> collidingBoundingBoxes = new ArrayList<AxisAlignedBB>();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!world.func_175667_e(new BlockPos(k1, 64, l1))) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    BlockPos pos = new BlockPos(k1, i2, l1);
                    IBlockState state = world.func_180495_p(pos);
                    state.func_185908_a(world, pos, axisalignedbb, collidingBoundingBoxes, entity, true);
                }
            }
        }
        return collidingBoundingBoxes;
    }

    private static class LinkTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;
        private final float yaw;

        private LinkTeleporter(BlockPos spawn, float yaw, ILinkInfo info) {
            this.targetPos = spawn;
            this.yaw = yaw;
        }

        public void placeEntity(World world, Entity entity, float yaw) {
            entity.func_174828_a(this.targetPos, this.yaw, entity.field_70125_A);
        }

        public boolean isVanilla() {
            return false;
        }
    }
}

