/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.linking;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.event.LinkEvent;
import com.xcompwiz.mystcraft.command.CommandTPX;
import com.xcompwiz.mystcraft.nbt.NBTDataContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LinkListenerPermissions {
    private static final String data_file = "mystcraft-linking-permissions";
    private static HashMap<String, Set<Integer>> permitEntry = new HashMap();
    private static HashMap<String, Set<Integer>> restrictEntry = new HashMap();
    private static HashMap<String, Set<Integer>> permitDepart = new HashMap();
    private static HashMap<String, Set<Integer>> restrictDepart = new HashMap();

    @SubscribeEvent
    public void isLinkPermitted(LinkEvent.LinkEventAllow event) {
        if (CommandTPX.isOpTP(event.info)) {
            return;
        }
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            Integer dimid = event.info.getDimensionUID();
            if (dimid == null) {
                return;
            }
            if (!this.canPlayerLeaveDimension(player, event.origin.field_73011_w.getDimension()) || !this.canPlayerEnterDimension(player, dimid)) {
                event.setCanceled(true);
            }
        }
    }

    private boolean canPlayerEnterDimension(EntityPlayer player, int dim) {
        Set<Integer> restricted = LinkListenerPermissions.getRestrictedSet(player.getDisplayNameString());
        if (restricted != null && restricted.contains(dim)) {
            return false;
        }
        Set<Integer> permitted = LinkListenerPermissions.getPermittedSet(player.getDisplayNameString());
        return permitted == null || permitted.contains(dim);
    }

    private boolean canPlayerLeaveDimension(EntityPlayer player, int dim) {
        Set<Integer> restricted = restrictDepart.get(player.getDisplayNameString());
        if (restricted != null && restricted.contains(dim)) {
            return false;
        }
        Set<Integer> permitted = permitDepart.get(player.getDisplayNameString());
        return permitted == null || permitted.contains(dim);
    }

    public static void restrictPlayerEntry(String playername, Integer dim) {
        if (dim == null) {
            restrictEntry.remove(playername);
            permitEntry.put(playername, new HashSet());
        } else {
            Set<Integer> restricted;
            Set<Integer> permitted = LinkListenerPermissions.getPermittedSet(playername);
            if (permitted != null) {
                permitted.remove(dim);
            }
            if ((restricted = LinkListenerPermissions.getRestrictedSet(playername)) == null) {
                restricted = new HashSet<Integer>();
                restrictEntry.put(playername, restricted);
            }
            restricted.add(dim);
        }
        LinkListenerPermissions.saveState();
    }

    public static void permitPlayerEntry(String playername, Integer dim) {
        if (dim == null) {
            restrictEntry.remove(playername);
            permitEntry.remove(playername);
        } else {
            Set<Integer> restricted;
            Set<Integer> permitted = LinkListenerPermissions.getPermittedSet(playername);
            if (permitted != null) {
                permitted.add(dim);
            }
            if ((restricted = LinkListenerPermissions.getRestrictedSet(playername)) != null) {
                restricted.remove(dim);
            }
        }
        LinkListenerPermissions.saveState();
    }

    public static void permitPlayerDepart(String playername, Integer dim) {
        if (dim == null) {
            restrictDepart.remove(playername);
            permitDepart.remove(playername);
        } else {
            Set<Integer> restricted;
            Set<Integer> permitted = permitDepart.get(playername);
            if (permitted != null) {
                permitted.add(dim);
            }
            if ((restricted = restrictDepart.get(playername)) != null) {
                restricted.remove(dim);
            }
        }
        LinkListenerPermissions.saveState();
    }

    public static void restrictPlayerDepart(String playername, Integer dim) {
        if (dim == null) {
            restrictDepart.remove(playername);
            permitDepart.put(playername, new HashSet());
        } else {
            Set<Integer> restricted;
            Set<Integer> permitted = permitDepart.get(playername);
            if (permitted != null) {
                permitted.remove(dim);
            }
            if ((restricted = restrictDepart.get(playername)) == null) {
                restricted = new HashSet<Integer>();
                restrictDepart.put(playername, restricted);
            }
            restricted.add(dim);
        }
        LinkListenerPermissions.saveState();
    }

    public static void loadState() {
        MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcServer == null) {
            return;
        }
        NBTDataContainer data = (NBTDataContainer)Mystcraft.getStorage(true).func_75742_a(NBTDataContainer.class, data_file);
        if (data == null) {
            data = new NBTDataContainer("dummy");
        }
        permitDepart = LinkListenerPermissions.readHashMapFromNBT(data.data.func_74775_l("PermitData"));
        permitEntry = LinkListenerPermissions.readHashMapFromNBT(data.data.func_74775_l("PermitEntry"));
        restrictDepart = LinkListenerPermissions.readHashMapFromNBT(data.data.func_74775_l("RestrictDepart"));
        restrictEntry = LinkListenerPermissions.readHashMapFromNBT(data.data.func_74775_l("RestrictEntry"));
    }

    private static void saveState() {
        MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcServer == null) {
            return;
        }
        NBTDataContainer data = (NBTDataContainer)Mystcraft.getStorage(true).func_75742_a(NBTDataContainer.class, data_file);
        if (data == null) {
            data = new NBTDataContainer(data_file);
            Mystcraft.getStorage(true).func_75745_a(data_file, (WorldSavedData)data);
        }
        data.data.func_74782_a("PermitDepart", (NBTBase)LinkListenerPermissions.writeHashMapToNBT(permitDepart));
        data.data.func_74782_a("PermitEntry", (NBTBase)LinkListenerPermissions.writeHashMapToNBT(permitEntry));
        data.data.func_74782_a("RestrictDepart", (NBTBase)LinkListenerPermissions.writeHashMapToNBT(restrictDepart));
        data.data.func_74782_a("RestrictEntry", (NBTBase)LinkListenerPermissions.writeHashMapToNBT(restrictEntry));
        data.func_76185_a();
    }

    private static NBTTagCompound writeHashMapToNBT(HashMap<String, Set<Integer>> map) {
        NBTTagCompound compound = new NBTTagCompound();
        for (Map.Entry<String, Set<Integer>> entry : map.entrySet()) {
            compound.func_74782_a(entry.getKey(), (NBTBase)LinkListenerPermissions.writeSetToNBT(entry.getValue()));
        }
        return compound;
    }

    private static NBTTagList writeSetToNBT(Set<Integer> set) {
        NBTTagList list = new NBTTagList();
        for (Integer dim : set) {
            list.func_74742_a((NBTBase)new NBTTagInt(dim.intValue()));
        }
        return list;
    }

    private static HashMap<String, Set<Integer>> readHashMapFromNBT(NBTTagCompound data) {
        HashMap<String, Set<Integer>> map = new HashMap<String, Set<Integer>>();
        for (String tagname : data.func_150296_c()) {
            NBTTagList list = data.func_150295_c(tagname, 3);
            map.put(tagname, LinkListenerPermissions.readSetFromNBT(list));
        }
        return map;
    }

    private static Set<Integer> readSetFromNBT(NBTTagList data) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagInt tag = (NBTTagInt)data.func_74744_a(0);
            set.add(tag.func_150287_d());
        }
        return set;
    }

    private static Set<Integer> getRestrictedSet(String username) {
        return restrictEntry.get(username);
    }

    private static Set<Integer> getPermittedSet(String username) {
        return permitEntry.get(username);
    }
}

