/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.network.packet;

import com.xcompwiz.mystcraft.explosion.ExplosionAdvanced;
import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffect;
import com.xcompwiz.mystcraft.network.packet.PacketBase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MPacketExplosion
extends PacketBase<MPacketExplosion, MPacketExplosion> {
    private double x;
    private double y;
    private double z;
    private float size;
    private List<Byte> effectIds = new LinkedList<Byte>();
    private List<BlockPos> positions = new LinkedList<BlockPos>();

    public MPacketExplosion() {
    }

    public MPacketExplosion(ExplosionAdvanced exp) {
        this.x = exp.explosionX;
        this.y = exp.explosionY;
        this.z = exp.explosionZ;
        this.size = exp.explosionSize;
        for (ExplosionEffect eff : exp.effects) {
            this.effectIds.add(ExplosionAdvanced.getEffectId(eff));
        }
        BlockPos offset = new BlockPos(this.x, this.y, this.z);
        for (BlockPos pos : exp.blocks) {
            this.positions.add(pos.func_177973_b((Vec3i)offset));
        }
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.size = buf.readFloat();
        int s = buf.readInt();
        for (i = 0; i < s; ++i) {
            this.effectIds.add(buf.readByte());
        }
        s = buf.readInt();
        for (i = 0; i < s; ++i) {
            this.positions.add(this.readPos(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.size);
        buf.writeInt(this.effectIds.size());
        for (Byte b : this.effectIds) {
            buf.writeByte((int)b.byteValue());
        }
        BlockPos offset = new BlockPos(this.x, this.y, this.z);
        buf.writeInt(this.positions.size());
        for (BlockPos pos : this.positions) {
            this.writePos(buf, pos.func_177971_a((Vec3i)offset));
        }
    }

    public MPacketExplosion onMessage(MPacketExplosion message, MessageContext ctx) {
        this.playExplosion(message);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void playExplosion(MPacketExplosion message) {
        ArrayList<ExplosionEffect> effects = new ArrayList<ExplosionEffect>();
        for (Byte b : message.effectIds) {
            ExplosionEffect effect = ExplosionAdvanced.getEffectById(b);
            if (effect == null) continue;
            effects.add(effect);
        }
        ExplosionAdvanced adv = new ExplosionAdvanced((World)Minecraft.func_71410_x().field_71441_e, null, message.x, message.y, message.z, message.size);
        adv.blocks = message.positions;
        adv.effects = effects;
        adv.doExplosionB(true);
    }
}

