/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.page;

import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class SortingUtils {

    public static class ComparatorSymbolAlphabetical
    implements Comparator<IAgeSymbol> {
        public static ComparatorSymbolAlphabetical instance = new ComparatorSymbolAlphabetical();

        @Override
        public int compare(IAgeSymbol symbol1, IAgeSymbol symbol2) {
            ResourceLocation rKey2;
            if (symbol1 == symbol2) {
                return 0;
            }
            if (symbol1 == null) {
                return 1;
            }
            if (symbol2 == null) {
                return -1;
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return this.compareLocalized(symbol1, symbol2);
            }
            ResourceLocation rKey1 = symbol1.getRegistryName();
            if (rKey1 == (rKey2 = symbol2.getRegistryName())) {
                return 0;
            }
            if (rKey1 == null) {
                return 1;
            }
            if (rKey2 == null) {
                return -1;
            }
            return rKey1.toString().compareTo(rKey2.toString());
        }

        @SideOnly(value=Side.CLIENT)
        private int compareLocalized(IAgeSymbol symbol1, IAgeSymbol symbol2) {
            return symbol1.getLocalizedName().compareTo(symbol2.getLocalizedName());
        }
    }

    public static class ComparatorItemSymbolAlphabetical
    implements Comparator<ItemStack> {
        public static ComparatorItemSymbolAlphabetical instance = new ComparatorItemSymbolAlphabetical();

        @Override
        public int compare(@Nonnull ItemStack itemstack1, @Nonnull ItemStack itemstack2) {
            ResourceLocation id2;
            ResourceLocation id1 = InternalAPI.page.getPageSymbol(itemstack1);
            if (id1 == (id2 = InternalAPI.page.getPageSymbol(itemstack2))) {
                return 0;
            }
            if (id1 == null) {
                return -1;
            }
            if (id2 == null) {
                return 1;
            }
            IAgeSymbol symbol1 = InternalAPI.symbol.getSymbol(id1);
            IAgeSymbol symbol2 = InternalAPI.symbol.getSymbol(id2);
            return ComparatorSymbolAlphabetical.instance.compare(symbol1, symbol2);
        }
    }

    public static class ComparatorTagItemSymbolAlphabetical
    implements Comparator<NBTTagCompound> {
        public static ComparatorTagItemSymbolAlphabetical instance = new ComparatorTagItemSymbolAlphabetical();

        @Override
        public int compare(NBTTagCompound itemdata1, NBTTagCompound itemdata2) {
            ItemStack itemstack1 = new ItemStack(itemdata1);
            ItemStack itemstack2 = new ItemStack(itemdata2);
            return ComparatorItemSymbolAlphabetical.instance.compare(itemstack1, itemstack2);
        }
    }
}

