/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.page.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SymbolRemappings {
    private static HashMap<ResourceLocation, List<ResourceLocation>> mappings = new HashMap();

    public static void initialize() {
        SymbolRemappings.fogColorRemappings();
        SymbolRemappings.cloudColorRemappings();
        SymbolRemappings.skyColorRemappings();
        SymbolRemappings.horizonColorRemappings();
        SymbolRemappings.addSymbolRemappingInternal("ModMat_tile.stone", "ModMat_minecraft:stone_0");
        SymbolRemappings.addSymbolRemappingInternal("ModMat_tile.lava", "ModMat_minecraft:flowing_lava_0");
        SymbolRemappings.addSymbolRemappingInternal("ModMat_tile.water", "ModMat_minecraft:flowing_water_0");
        SymbolRemappings.addSymbolRemappingInternal("modmat_flowing_water_0", "modmat_water_0");
        SymbolRemappings.addSymbolRemappingInternal("ModMaroon", "ModColorMaroon");
        SymbolRemappings.addSymbolRemappingInternal("ModRed", "ModColorRed");
        SymbolRemappings.addSymbolRemappingInternal("ModOlive", "ModColorOlive");
        SymbolRemappings.addSymbolRemappingInternal("ModYellow", "ModColorYellow");
        SymbolRemappings.addSymbolRemappingInternal("ModDark Green", "ModColorDarkGreen");
        SymbolRemappings.addSymbolRemappingInternal("ModGreen", "ModColorGreen");
        SymbolRemappings.addSymbolRemappingInternal("ModTeal", "ModColorTeal");
        SymbolRemappings.addSymbolRemappingInternal("ModCyan", "ModColorCyan");
        SymbolRemappings.addSymbolRemappingInternal("ModNavy", "ModColorNavy");
        SymbolRemappings.addSymbolRemappingInternal("ModBlue", "ModColorBlue");
        SymbolRemappings.addSymbolRemappingInternal("ModPurple", "ModColorPurple");
        SymbolRemappings.addSymbolRemappingInternal("ModMagenta", "ModColorMagenta");
        SymbolRemappings.addSymbolRemappingInternal("ModBlack", "ModColorBlack");
        SymbolRemappings.addSymbolRemappingInternal("ModGrey", "ModColorGrey");
        SymbolRemappings.addSymbolRemappingInternal("ModSilver", "ModColorSilver");
        SymbolRemappings.addSymbolRemappingInternal("ModWhite", "ModColorWhite");
        SymbolRemappings.addSymbolRemappingInternal("LavaLakes", "ModMat_tile.lava", "LakesDeep");
        SymbolRemappings.addSymbolRemappingInternal("Lakes", "ModMat_tile.water", "LakesSurface");
        SymbolRemappings.addSymbolRemappingInternal("CryFormCry", "ModMat_tile.myst.crystal", "CryForm");
        SymbolRemappings.addSymbolRemappingInternal("CryFormGlow", "ModMat_tile.myst.lightgem", "CryForm");
        SymbolRemappings.addSymbolRemappingInternal("CryFormQuartz", "ModMat_tile.myst.netherquartz", "CryForm");
        SymbolRemappings.addSymbolRemappingInternal("Standard Terrain", "TerrainNormal");
        SymbolRemappings.addSymbolRemappingInternal("Star Fissure", "StarFissure");
        SymbolRemappings.addSymbolRemappingInternal("Rain", "WeatherRain");
        SymbolRemappings.addSymbolRemappingInternal("Snow", "WeatherSnow");
        SymbolRemappings.addSymbolRemappingInternal("Huge Trees", "HugeTrees");
        SymbolRemappings.addSymbolRemappingInternal("NormalStars", "StarsNormal");
        SymbolRemappings.addSymbolRemappingInternal("Single Biome", "BioConSingle");
        SymbolRemappings.addSymbolRemappingInternal("Checkerboard Biomes", "BioConTiled");
        SymbolRemappings.addSymbolRemappingInternal("BiomeControllerNative", "BioConNative");
        SymbolRemappings.addSymbolRemappingInternal("Lava Lakes", "LavaLakes");
        SymbolRemappings.addSymbolRemappingInternal("WeatherSun", "WeatherOff");
        SymbolRemappings.addSymbolRemappingInternal("Standard Lighting", "LightingNormal");
        SymbolRemappings.addSymbolRemappingInternal("Storm", "WeatherStorm");
        SymbolRemappings.addSymbolRemappingInternal("Fog", "ColorFog");
        SymbolRemappings.addSymbolRemappingInternal("ModFluid_tile.lava", "ModMat_tile.lava");
        SymbolRemappings.addSymbolRemappingInternal("ModFluid_tile.water", "ModMat_tile.water");
        SymbolRemappings.addSymbolRemappingInternal("ModFluidtile.water", "ModMat_tile.water");
        SymbolRemappings.addSymbolRemappingInternal("ModFluidtile.lava", "ModMat_tile.lava");
        SymbolRemappings.addSymbolRemappingInternal("ModLavaSea", "ModMat_tile.lava");
        SymbolRemappings.addSymbolRemappingInternal("ModNetherTerrain", "ModMat_tile.hellrock");
        SymbolRemappings.addSymbolRemappingInternal("ModMattile.hellrock", "ModMat_tile.hellrock");
        SymbolRemappings.addSymbolRemappingInternal("ModMattile.whiteStone", "ModMat_tile.whiteStone");
        SymbolRemappings.addSymbolRemappingInternal("ModMattile.oreDiamond", "ModMat_tile.oreDiamond");
        SymbolRemappings.addSymbolRemappingInternal("TendrilsIce", "ModMat_tile.ice", "Tendrils");
        SymbolRemappings.addSymbolRemappingInternal("WoodCaves", "Tendrils");
        SymbolRemappings.addSymbolRemappingInternal("SkyDropDark", "StarsDark");
        SymbolRemappings.addSymbolRemappingInternal("FTime", "ModHalf", "SunNormal", "ModHalf", "MoonNormal");
        SymbolRemappings.addSymbolRemappingInternal("STime", "ModDouble", "SunNormal", "ModDouble", "MoonNormal");
        SymbolRemappings.addSymbolRemappingInternal("NTime", "ModFull", "SunNormal", "ModFull", "MoonNormal");
        SymbolRemappings.addSymbolRemappingInternal("Dusk", "ModZero", "ModSetting", "SunNormal", "ModZero", "MoonNormal");
        SymbolRemappings.addSymbolRemappingInternal("Night", "SunDark", "ModZero", "MoonNormal");
        SymbolRemappings.addSymbolRemappingInternal("Day", "MoonDark", "ModZero", "ModNoon", "SunNormal");
        SymbolRemappings.addSymbolRemappingInternal("Heavy Resources", "DenseOres");
        SymbolRemappings.addSymbolRemappingInternal("SunsetNormal", "SunsetRed");
        SymbolRemappings.addSymbolRemappingInternal("CloudNormal", "CloudWhite");
        SymbolRemappings.addSymbolRemappingInternal("Normal Sunset Colors", "SunsetRed");
        SymbolRemappings.addSymbolRemappingInternal("NativeBiomeController", "BioConLarge");
        SymbolRemappings.addSymbolRemappingInternal("Flat Sea", "TerrainFlat");
        SymbolRemappings.addSymbolRemappingInternal("Sky Islands", "Skylands");
        SymbolRemappings.addSymbolRemappingInternal("Tree Age", "Huge Trees", "TerrainFlat", "Swampland", "BioConSingle");
        SymbolRemappings.addSymbolRemappingInternal("DefaultBiome", "BioConSingle");
        SymbolRemappings.addSymbolRemappingInternal("DefaultLighting", "Standard Lighting");
        SymbolRemappings.addSymbolRemappingInternal("DefaultSunrise", "Normal Sunset Colors");
        SymbolRemappings.addSymbolRemappingInternal("DefaultTerrain", "Standard Terrain");
        SymbolRemappings.addSymbolRemappingInternal("Flat", "TerrainFlat");
        SymbolRemappings.addSymbolRemappingInternal("Void", "TerrainVoid");
    }

    private static void addChromaticGradients(List<String> mapping) {
        mapping.add("ModBlack");
        mapping.add("ModRed");
        mapping.add("ModRed");
        mapping.add("ModGradient");
        mapping.add("ModBlack");
        mapping.add("ModGreen");
        mapping.add("ModGreen");
        mapping.add("ModGradient");
        mapping.add("ModBlack");
        mapping.add("ModBlue");
        mapping.add("ModBlue");
        mapping.add("ModGradient");
    }

    private static void fogColorRemappings() {
        ArrayList<String> mapping = new ArrayList<String>();
        SymbolRemappings.addChromaticGradients(mapping);
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemappingInternal("FogChromatic", mapping);
        mapping = new ArrayList();
        mapping.add("ModRed");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemappingInternal("FogRed", mapping);
        mapping = new ArrayList();
        mapping.add("ModGreen");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemappingInternal("FogGreen", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlue");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemappingInternal("FogBlue", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlack");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemappingInternal("FogBlack", mapping);
        mapping = new ArrayList();
        mapping.add("ModWhite");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemappingInternal("FogWhite", mapping);
        mapping = new ArrayList();
        mapping.add("ModWhite");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemappingInternal("FogNormal", mapping);
    }

    private static void cloudColorRemappings() {
        ArrayList<String> mapping = new ArrayList<String>();
        SymbolRemappings.addChromaticGradients(mapping);
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemappingInternal("CloudChromatic", mapping);
        mapping = new ArrayList();
        mapping.add("ModRed");
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemappingInternal("CloudRed", mapping);
        mapping = new ArrayList();
        mapping.add("ModGreen");
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemappingInternal("CloudGreen", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlue");
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemappingInternal("CloudBlue", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlack");
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemappingInternal("CloudBlack", mapping);
        mapping = new ArrayList();
        mapping.add("ModWhite");
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemappingInternal("CloudWhite", "ModWhite", "ColorCloud");
    }

    private static void skyColorRemappings() {
        ArrayList<String> mapping = new ArrayList<String>();
        mapping.add("ModGradient");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemappingInternal("ModGradient_HERE", mapping);
        mapping = new ArrayList();
        SymbolRemappings.addChromaticGradients(mapping);
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemappingInternal("SkyChromatic", mapping);
        mapping = new ArrayList();
        mapping.add("ModRed");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemappingInternal("SkyRed", mapping);
        mapping = new ArrayList();
        mapping.add("ModGreen");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemappingInternal("SkyGreen", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlue");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemappingInternal("SkyBlue", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlack");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemappingInternal("SkyBlack", mapping);
        mapping = new ArrayList();
        mapping.add("ModWhite");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemappingInternal("SkyWhite", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlue");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemappingInternal("SkyNormal", mapping);
    }

    private static void horizonColorRemappings() {
        ArrayList<String> mapping = new ArrayList<String>();
        SymbolRemappings.addChromaticGradients(mapping);
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemappingInternal("SunsetChromatic", mapping);
        mapping = new ArrayList();
        mapping.add("ModRed");
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemappingInternal("SunsetRed", mapping);
        mapping = new ArrayList();
        mapping.add("ModGreen");
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemappingInternal("SunsetGreen", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlue");
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemappingInternal("SunsetBlue", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlack");
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemappingInternal("SunsetBlack", mapping);
        mapping = new ArrayList();
        mapping.add("ModWhite");
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemappingInternal("SunsetWhite", mapping);
    }

    public static boolean hasRemapping(ResourceLocation symbol2) {
        if (symbol2.func_110624_b().startsWith("modmat_")) {
            return true;
        }
        if (symbol2.func_110624_b().equals("minecraft")) {
            return true;
        }
        return mappings.get(symbol2) != null;
    }

    public static List<ResourceLocation> remap(ResourceLocation symbol2) {
        List<ResourceLocation> symbols;
        if (symbol2 == null) {
            return null;
        }
        if (symbol2.func_110624_b().startsWith("modmat_")) {
            symbol2 = new ResourceLocation(symbol2.func_110624_b().replace("modmat_", ""), "modmat_" + symbol2.func_110623_a());
        }
        if (symbol2.func_110624_b().equals("minecraft")) {
            symbol2 = new ResourceLocation("mystcraft", symbol2.func_110623_a());
        }
        if ((symbols = mappings.get(symbol2)) == null) {
            symbols = new ArrayList<ResourceLocation>();
            symbols.add(symbol2);
        }
        return symbols;
    }

    public static List<ItemStack> remap(ItemStack page) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (page == null) {
            return result;
        }
        if (!(page.func_77973_b() instanceof ItemPage)) {
            return result;
        }
        ResourceLocation symbol2 = Page.getSymbol(page);
        List<ResourceLocation> symbols = SymbolRemappings.remap(symbol2);
        if (symbols != null) {
            for (ResourceLocation mapping : symbols) {
                result.add(Page.createSymbolPage(mapping));
            }
            if (symbols.size() > 0) {
                Page.setSymbol(page, Page.getSymbol((ItemStack)result.get(0)));
                result.set(0, page.func_77946_l());
            }
        } else {
            result.add(page);
        }
        return result;
    }

    public static <T> List<T> remap(List<T> collection) {
        int i = 0;
        while (i < collection.size()) {
            T element = collection.remove(i);
            List<ResourceLocation> mapping = null;
            if (element instanceof ResourceLocation) {
                mapping = SymbolRemappings.remap((ResourceLocation)element);
            }
            if (element instanceof ItemStack) {
                mapping = SymbolRemappings.remap((ItemStack)element);
            }
            if (mapping == null) continue;
            collection.addAll(i, mapping);
            ++i;
        }
        return collection;
    }

    private static void addSymbolRemappingInternal(String mystId, List<String> mapping) {
        LinkedList<ResourceLocation> mappingList = new LinkedList<ResourceLocation>();
        for (String str : mapping) {
            mappingList.add(new ResourceLocation("mystcraft", str));
        }
        SymbolRemappings.addSymbolRemapping(new ResourceLocation("mystcraft", mystId), mappingList);
    }

    private static void addSymbolRemappingInternal(String mystId, String ... newMappings) {
        ResourceLocation[] mappingArr = new ResourceLocation[newMappings.length];
        for (int i = 0; i < newMappings.length; ++i) {
            mappingArr[i] = new ResourceLocation("mystcraft", newMappings[i]);
        }
        SymbolRemappings.addSymbolRemapping(new ResourceLocation("mystcraft", mystId), mappingArr);
    }

    private static void addSymbolRemapping(ResourceLocation id, List<ResourceLocation> mapping) {
        mappings.put(id, mapping);
    }

    public static void addSymbolRemapping(ResourceLocation id, ResourceLocation ... newids) {
        ArrayList<ResourceLocation> mapping = new ArrayList<ResourceLocation>();
        for (ResourceLocation newid : newids) {
            mapping.add(newid);
        }
        mappings.put(id, mapping);
    }
}

