/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IDynamicColorProvider;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;

public class SymbolColorSky
extends SymbolBase {
    public SymbolColorSky(ResourceLocation identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        ColorGradient gradient = ModifierUtils.popGradient(controller, 1.0f, 1.0f, 1.0f);
        controller.registerInterface(new Colorizer(controller, gradient), "sky");
    }

    @Override
    public boolean generatesConfigOption() {
        return true;
    }

    private class Colorizer
    implements IDynamicColorProvider {
        ColorGradient gradient;
        private AgeDirector controller;

        public Colorizer(AgeDirector controller, ColorGradient gradient) {
            this.controller = controller;
            this.gradient = gradient;
        }

        @Override
        public Color getColor(Entity entity, Biome biome, float time, float celestial_angle, float partialtick) {
            float alpha = MathHelper.func_76134_b((float)(celestial_angle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
            if (alpha < 0.0f) {
                alpha = 0.0f;
            }
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            Color color = this.gradient.getColor((float)this.controller.getTime() / 12000.0f);
            color = new Color(color.r * alpha, color.g * alpha, color.b * alpha);
            return color;
        }
    }
}

