/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.gen.feature.WorldGenMystCrystalFormation;
import com.xcompwiz.mystcraft.world.gen.feature.WorldGeneratorAdv;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SymbolCrystalFormation
extends SymbolBase {
    public SymbolCrystalFormation(ResourceLocation identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        BlockDescriptor block = ModifierUtils.popBlockMatching(controller, BlockCategory.CRYSTAL);
        WorldGenMystCrystalFormation generator = block != null ? new WorldGenMystCrystalFormation(block.blockstate) : new WorldGenMystCrystalFormation(ModBlocks.crystal);
        controller.registerInterface(new Populator(generator));
    }

    @Override
    public boolean generatesConfigOption() {
        return true;
    }

    private static class Populator
    implements IPopulate {
        private WorldGeneratorAdv gen;
        private int rate;

        Populator(WorldGeneratorAdv gen) {
            this.gen = gen;
            this.rate = 15;
        }

        @Override
        public boolean populate(World worldObj, Random rand, int i, int j, boolean flag) {
            if (!flag && rand.nextInt(this.rate) == 0) {
                this.gen.func_180709_b(worldObj, rand, new BlockPos(i += rand.nextInt(16) + 8, 0, j += rand.nextInt(16) + 8));
            } else {
                this.gen.noGen();
            }
            return false;
        }
    }
}

