/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.client.render.RenderRainbow;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.symbols.CelestialBase;
import java.util.Random;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SymbolDoodadRainbow
extends SymbolBase {
    public SymbolDoodadRainbow(ResourceLocation identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        Number angle = controller.popModifier("angle").asNumber();
        controller.registerInterface(new CelestialObject(controller, seed, angle));
    }

    @Override
    public boolean generatesConfigOption() {
        return true;
    }

    private class CelestialObject
    extends CelestialBase {
        private Random rand;
        private float angle;
        private boolean initialized;
        private Integer rainbowGLCallList = null;

        CelestialObject(AgeDirector controller, long seed, Number angle) {
            this.rand = new Random(seed);
            if (angle == null) {
                angle = this.rand.nextDouble() * 360.0;
            }
            this.angle = -angle.floatValue();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(TextureManager eng, World worldObj, float partial) {
            if (!this.initialized) {
                this.initialize();
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            if (this.rainbowGLCallList == null) {
                RenderRainbow.renderRainbow(0.0f, 50.0f);
            } else {
                GlStateManager.func_179148_o((int)this.rainbowGLCallList);
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }

        @SideOnly(value=Side.CLIENT)
        private void initialize() {
            this.initialized = true;
            if (Mystcraft.fastRainbows) {
                this.rainbowGLCallList = GLAllocation.func_74526_a((int)1);
                GlStateManager.func_187423_f((int)this.rainbowGLCallList, (int)4864);
                GlStateManager.func_179094_E();
                RenderRainbow.renderRainbow(0.0f, 50.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_187415_K();
            }
        }
    }
}

