/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.ICelestial;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.symbol.SunsetRenderer;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SymbolMoonNormal
extends SymbolBase {
    public SymbolMoonNormal(ResourceLocation identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        Number period = controller.popModifier("wavelength").asNumber();
        Number angle = controller.popModifier("angle").asNumber();
        Number offset = controller.popModifier("phase").asNumber();
        ColorGradient sunset = controller.popModifier("sunset").asGradient();
        controller.registerInterface(new CelestialObject(controller, seed, period, angle, offset, sunset));
    }

    @Override
    public boolean generatesConfigOption() {
        return true;
    }

    private static class CelestialObject
    extends SunsetRenderer
    implements ICelestial {
        private Random rand;
        private long period;
        private float angle;
        private float offset;

        CelestialObject(AgeDirector controller, long seed, Number period, Number angle, Number offset, ColorGradient gradient) {
            super(controller, gradient);
            this.rand = new Random(seed);
            if (period == null) {
                period = 1.8 * this.rand.nextDouble() + 0.2;
            }
            this.period = (long)(period.doubleValue() * 24000.0);
            if (angle == null) {
                angle = this.rand.nextDouble() * 360.0;
            }
            this.angle = -angle.floatValue();
            if (offset != null) {
                offset = Float.valueOf(offset.floatValue() / 360.0f);
            }
            if (offset == null) {
                offset = Float.valueOf(this.rand.nextFloat());
                if (this.period == 0L) {
                    offset = Float.valueOf(offset.floatValue() / 2.0f + 0.25f);
                }
            }
            this.offset = offset.floatValue() - 0.5f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(TextureManager eng, World worldObj, float partial) {
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder vb = tes.func_178180_c();
            float invertRain = 1.0f - worldObj.func_72867_j(partial);
            float celestial_period = this.getAltitudeAngle(worldObj.func_72820_D(), partial);
            GlStateManager.func_179098_w();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)invertRain);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(celestial_period * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            double size = 20.0;
            int moonphase = this.getMoonPhase(worldObj.func_72820_D(), partial);
            int x = moonphase % 4;
            int y = moonphase / 4 % 2;
            double x1 = (double)(x + 0) / 4.0;
            double y1 = (double)(y + 0) / 2.0;
            double x2 = (double)(x + 1) / 4.0;
            double y2 = (double)(y + 1) / 2.0;
            eng.func_110577_a(Assets.Vanilla.normal_moon);
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(-size, 100.0, -size).func_187315_a(x2, y2).func_181675_d();
            vb.func_181662_b(size, 100.0, -size).func_187315_a(x1, y2).func_181675_d();
            vb.func_181662_b(size, 100.0, size).func_187315_a(x1, y1).func_181675_d();
            vb.func_181662_b(-size, 100.0, size).func_187315_a(x2, y1).func_181675_d();
            tes.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            if (this.gradient != null) {
                this.renderHorizon(eng, worldObj, celestial_period, this.angle, partial, 0.3f);
            }
        }

        @Override
        public float getAltitudeAngle(long time, float partialTime) {
            if (this.period == 0L) {
                return this.offset;
            }
            int i = (int)(time % this.period);
            float f = ((float)i + partialTime) / (float)this.period + this.offset;
            if (f < 0.0f) {
                f += 1.0f;
            }
            if (f > 1.0f) {
                f -= 1.0f;
            }
            float f1 = f;
            f = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
            f = f1 + (f - f1) / 3.0f;
            return f;
        }

        public int getMoonPhase(long time, float partialTime) {
            if (this.period == 0L) {
                return 0;
            }
            return (int)(time / this.period) % 8;
        }

        @Override
        public boolean providesLight() {
            return false;
        }

        @Override
        public Long getTimeToDawn(long time) {
            return null;
        }
    }
}

