/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IPrimerFilter;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainAlteration;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class SymbolSkylands
extends SymbolBase {
    public SymbolSkylands(ResourceLocation identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        NoiseGeneratorOctaves noise = new NoiseGeneratorOctaves(new Random(controller.getSeed()), 7);
        controller.registerInterface(new TerrainAlteration(noise));
        controller.setCloudHeight(42.5f);
        controller.setHorizon(0.0);
    }

    @Override
    public boolean generatesConfigOption() {
        return true;
    }

    private static class TerrainAlteration
    implements ITerrainAlteration {
        private double[] skyNoise = new double[256];
        private NoiseGeneratorOctaves noiseGen;

        public TerrainAlteration(NoiseGeneratorOctaves noise) {
            this.noiseGen = noise;
        }

        @Override
        @Nullable
        public IPrimerFilter getGenerationFilter(World world, ChunkPrimer primer, int chunkX, int chunkZ) {
            return new SkylandsFilter(this.noiseGen, chunkX, chunkZ);
        }

        @Override
        public void alterTerrain(World worldObj, int chunkX, int chunkZ, ChunkPrimer primer) {
        }

        static /* synthetic */ double[] access$102(TerrainAlteration x0, double[] x1) {
            x0.skyNoise = x1;
            return x1;
        }

        private class SkylandsFilter
        implements IPrimerFilter {
            private SkylandsFilter(NoiseGeneratorOctaves noise, int chunkX, int chunkZ) {
                TerrainAlteration.access$102(TerrainAlteration.this, noise.func_76305_a(TerrainAlteration.this.skyNoise, chunkX * 16, chunkZ * 16, 16, 16, 1.0, 1.0, 1.0));
            }

            @Override
            public IBlockState filter(int x, int y, int z, IBlockState state) {
                Material mat = state.func_185904_a();
                if (mat == Material.field_151579_a) {
                    return state;
                }
                int height = this.getCutOffHeight(x, z);
                if (y <= height) {
                    return null;
                }
                if (mat.func_76224_d()) {
                    return null;
                }
                return state;
            }

            private int getCutOffHeight(int x, int z) {
                return 76 + (int)TerrainAlteration.this.skyNoise[x << 4 | z];
            }
        }
    }
}

