/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.tileentity;

import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.inventory.IItemBuilder;
import com.xcompwiz.mystcraft.inventory.InventoryFolder;
import com.xcompwiz.mystcraft.item.ItemAgebook;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import com.xcompwiz.mystcraft.tileentity.IOInventory;
import com.xcompwiz.mystcraft.tileentity.InventoryFilter;
import com.xcompwiz.mystcraft.tileentity.TileEntityBase;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityBookBinder
extends TileEntityBase
implements IItemBuilder,
InventoryFilter {
    private IOInventory inventory;
    private List<ItemStack> pages = new LinkedList<ItemStack>();
    private String pendingtitle = null;
    private static final int cover_slot = 0;

    public TileEntityBookBinder() {
        this.inventory = this.buildInventory();
    }

    protected IOInventory buildInventory() {
        return new IOInventory(this, new int[]{0}, new int[0], EnumFacing.field_82609_l).setMiscSlots(0).applyFilter(this, 0);
    }

    @Override
    public boolean canAcceptItem(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return slot != 0 || this.isValidCover(stack);
    }

    private boolean isValidCover(ItemStack itemstack) {
        if (itemstack.func_77973_b().equals(Items.field_151116_aA)) {
            return true;
        }
        return itemstack.func_77973_b() == ModItems.folder && InventoryFolder.isEmpty(itemstack);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.inventory.readNBT(compound.func_74775_l("items"));
        this.pages.clear();
        NBTUtils.readItemStackCollection(compound.func_150295_c("pages", 10), this.pages);
        SymbolRemappings.remap(this.pages);
        this.pendingtitle = compound.func_74764_b("title") ? compound.func_74779_i("title") : null;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("items", (NBTBase)this.inventory.writeNBT());
        NBTTagList list = new NBTTagList();
        NBTUtils.writeItemStackCollection(list, this.pages);
        compound.func_74782_a("pages", (NBTBase)list);
        if (this.pendingtitle != null) {
            compound.func_74778_a("title", this.pendingtitle);
        }
    }

    @Nonnull
    public String getPendingTitle() {
        return this.pendingtitle == null ? "" : this.pendingtitle;
    }

    public void setBookTitle(@Nullable String name) {
        this.pendingtitle = name;
    }

    @Override
    public void buildItem(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player) {
        if (!this.canBuildItem()) {
            return;
        }
        if (itemstack.func_77973_b() instanceof ItemAgebook) {
            ItemAgebook.create(itemstack, player, this.pages, this.pendingtitle);
            this.pages.clear();
            this.pendingtitle = null;
            ItemStack remainder = this.inventory.getStackInSlot(0).func_77946_l();
            remainder.func_190918_g(1);
            this.inventory.setStackInSlot(0, remainder);
            if (this.inventory.getStackInSlot(1).func_190916_E() <= 0 || this.inventory.getStackInSlot(1).func_190926_b()) {
                this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
            }
            this.markForUpdate();
        } else {
            itemstack.func_190920_e(0);
        }
    }

    private boolean canBuildItem() {
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        if (!this.isValidCover(this.inventory.getStackInSlot(0))) {
            return false;
        }
        if (this.pages.size() == 0) {
            return false;
        }
        if (!Page.isLinkPanel(this.pages.get(0))) {
            return false;
        }
        if (this.pendingtitle == null || this.pendingtitle.equals("")) {
            return false;
        }
        for (int i = 1; i < this.pages.size(); ++i) {
            if (!Page.isLinkPanel(this.pages.get(i))) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack getCraftedItem() {
        if (!this.canBuildItem()) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)ModItems.agebook);
    }

    public void setPages(@Nonnull List<ItemStack> pages) {
        if (this.field_145850_b.field_72995_K) {
            this.pages = pages;
        }
    }

    public List<ItemStack> getPageList() {
        return this.pages;
    }

    @Nonnull
    public ItemStack insertPage(@Nonnull ItemStack stack, int i) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_77973_b().equals(Items.field_151121_aF)) {
            while (stack.func_190916_E() > 0) {
                ItemStack clone = stack.func_77946_l();
                clone.func_190920_e(1);
                clone = ItemPage.createItemstack(clone);
                if (clone.func_190926_b() || !this.insertPage(clone, i).func_190926_b()) {
                    return stack;
                }
                stack.func_190918_g(1);
            }
            if (stack.func_190916_E() == 0) {
                stack = ItemStack.field_190927_a;
            }
            return stack;
        }
        if (stack.func_77973_b() != ModItems.page) {
            return stack;
        }
        while (stack.func_190916_E() > 0) {
            ItemStack clone = stack.func_77946_l();
            clone.func_190920_e(1);
            this.pages.add(i, clone);
            stack.func_190918_g(1);
        }
        this.markForUpdate();
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertFromFolder(@Nonnull ItemStack folder, int index) {
        if (folder.func_77973_b() != ModItems.folder) {
            return folder;
        }
        int size = InventoryFolder.getLargestSlotId(folder);
        if (size == -1) {
            for (ItemStack page : this.pages) {
                InventoryFolder.addItem(folder, page);
            }
            this.pages.clear();
        } else {
            for (int slot = 0; slot < size + 1; ++slot) {
                ItemStack page = InventoryFolder.getItem(folder, slot);
                if (page.func_190926_b()) continue;
                if ((page = this.insertPage(page, index)).func_190926_b()) {
                    ++index;
                }
                InventoryFolder.setItem(folder, slot, page);
            }
        }
        this.markForUpdate();
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack removePage(int i) {
        if (i >= this.pages.size()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = this.pages.remove(i);
        this.markForUpdate();
        return itemstack;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory.hasCapability(facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getCapability(facing);
        }
        return null;
    }
}

