/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.treasure;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.tileentity.InventoryFilter;
import com.xcompwiz.mystcraft.treasure.TreasureGenWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootTableHandler {
    public static final LootTableHandler EVENT_INSTANCE = new LootTableHandler();
    public static final ResourceLocation MYST_TREASURE = new ResourceLocation("mystcraft", "mystcraft_treasure");
    private static final ImmutableSet<ResourceLocation> pageTables = ImmutableSet.of((Object)LootTableList.field_186429_k, (Object)LootTableList.field_186430_l, (Object)LootTableList.field_186426_h, (Object)LootTableList.field_186422_d);

    public static void init() {
        LootTableList.func_186375_a((ResourceLocation)MYST_TREASURE);
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        LootTable lt = event.getTable();
        if (event.getName().equals((Object)MYST_TREASURE)) {
            LootPool main = lt.getPool(MYST_TREASURE.toString());
            ArrayList<IAgeSymbol> symbols = SymbolManager.getAgeSymbols();
            for (IAgeSymbol symbol2 : symbols) {
                final int maxStack = SymbolManager.getSymbolTreasureMaxStack(symbol2);
                int chance = SymbolManager.getSymbolItemWeight(symbol2.getRegistryName());
                final ItemStack symbolStack = Page.createSymbolPage(symbol2.getRegistryName());
                main.addEntry(new LootEntry(chance, 0, new LootCondition[0], symbol2.getRegistryName().toString()){

                    public void func_186363_a(Collection<ItemStack> stacks, Random rand, LootContext context) {
                        ItemStack copy = symbolStack.func_77946_l();
                        copy.func_190920_e(1 + rand.nextInt(Math.max(1, maxStack - 1)));
                        stacks.add(copy);
                    }

                    protected void func_186362_a(JsonObject json, JsonSerializationContext context) {
                    }
                });
            }
        } else if (pageTables.contains((Object)event.getName())) {
            LootPool mainPool = lt.getPool("main");
            mainPool.addEntry((LootEntry)new TreasureGenWrapper(10, 0, "myst_treasure_hook"));
        }
    }

    public static ItemStack generateLecternItem(InventoryFilter filter, Random rand, LootTable lootTable, LootContext lootContext) {
        int failsafe = 0;
        Object item = null;
        while (item == null && failsafe++ < 100) {
            List result = lootTable.func_186462_a(rand, lootContext);
            for (ItemStack stack : result) {
                Integer symbolRank;
                ResourceLocation symbolid;
                if (stack.func_190916_E() > 0) {
                    stack.func_190920_e(1);
                }
                if (filter != null && !filter.canAcceptItem(0, stack) || stack.func_77973_b() == ModItems.page && ((symbolid = Page.getSymbol(stack)) == null || (symbolRank = SymbolManager.getSymbolItemCardRank(symbolid)) == null || symbolRank < 3)) continue;
                return stack;
            }
        }
        return null;
    }
}

