/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world;

import com.google.common.base.Predicate;
import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.chunk.ChunkPrimerMyst;
import com.xcompwiz.mystcraft.world.gen.structure.MapGenScatteredFeatureMyst;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderMyst
implements IChunkGenerator {
    private AgeController controller;
    private Random rand;
    private NoiseGeneratorPerlin stoneNoiseGen;
    private World worldObj;
    private AgeData agedata;
    private double[] stoneNoise;
    private Biome[] tempBiomesArray;
    private MapGenScatteredFeatureMyst scatteredFeatureGenerator = new MapGenScatteredFeatureMyst();
    private WorldGenMinable worldgenminablequartz = new WorldGenMinable(Blocks.field_150449_bY.func_176223_P(), 13, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));

    public ChunkProviderMyst(AgeController ageController, World world, AgeData age) {
        this.controller = ageController;
        this.stoneNoise = new double[256];
        this.worldObj = world;
        this.agedata = age;
        this.rand = new Random(this.agedata.getSeed());
        this.stoneNoiseGen = new NoiseGeneratorPerlin(this.rand, 4);
    }

    private void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] aBiome) {
        ChunkGeneratorEvent.ReplaceBiomeBlocks event = new ChunkGeneratorEvent.ReplaceBiomeBlocks((IChunkGenerator)this, chunkX, chunkZ, primer, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() != Event.Result.DENY) {
            double noisefactor = 0.03125;
            this.stoneNoise = this.stoneNoiseGen.func_151599_a(this.stoneNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, noisefactor * 2.0, noisefactor * 2.0, 1.0);
            for (int xoff = 0; xoff < 16; ++xoff) {
                for (int zoff = 0; zoff < 16; ++zoff) {
                    Biome b = aBiome[zoff + xoff * 16];
                    b.func_180622_a(this.worldObj, this.rand, primer, chunkX * 16 + xoff, chunkZ * 16 + zoff, this.stoneNoise[zoff + xoff * 16]);
                }
            }
        }
    }

    @Nonnull
    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimerMyst primer = new ChunkPrimerMyst();
        this.controller.getTerrainFilters(primer, chunkX, chunkZ).forEach(primer::addFilter);
        this.controller.generateTerrain(chunkX, chunkZ, primer);
        this.tempBiomesArray = this.worldObj.func_72959_q().func_76933_b(this.tempBiomesArray, chunkX * 16, chunkZ * 16, 16, 16);
        primer.inBiomeDecoration = true;
        this.replaceBlocksForBiome(chunkX, chunkZ, primer, this.tempBiomesArray);
        primer.inBiomeDecoration = false;
        this.controller.modifyTerrain(chunkX, chunkZ, primer);
        this.scatteredFeatureGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, primer);
        Chunk chunk = new Chunk(this.worldObj, (ChunkPrimer)primer, chunkX, chunkZ);
        chunk.func_76603_b();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 128; ++y) {
                    chunk.func_177431_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z), 0);
                }
            }
        }
        byte[] chunkBiomeArray = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomeArray.length; ++i) {
            chunkBiomeArray[i] = (byte)Biome.func_185362_a((Biome)this.tempBiomesArray[i]);
        }
        this.controller.finalizeChunk(chunk, chunkX, chunkZ);
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        Chunk chunk = this.worldObj.func_72964_e(chunkX, chunkZ);
        chunk.func_177446_d(false);
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos blockpos = new BlockPos(x, 0, z);
        Biome biome = this.worldObj.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.worldObj.func_72905_C());
        boolean flag = false;
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag);
        this.scatteredFeatureGenerator.func_175794_a(this.worldObj, this.rand, chunkpos);
        try {
            biome.func_180624_a(this.worldObj, this.rand, new BlockPos(x, 0, z));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Biome [%s] threw an error while populating chunk.", biome.getRegistryName()), e);
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biome, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        }
        this.controller.populate(this.worldObj, this.rand, x, z);
        blockpos = blockpos.func_177982_a(8, 0, 8);
        boolean doGen = TerrainGen.generateOre((World)this.worldObj, (Random)this.rand, (WorldGenerator)this.worldgenminablequartz, (BlockPos)new BlockPos(x, 0, z), (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.QUARTZ);
        for (int k1 = 0; doGen && k1 < 16; ++k1) {
            int gx = x + this.rand.nextInt(16);
            int gy = this.rand.nextInt(108) + 10;
            int gz = z + this.rand.nextInt(16);
            this.worldgenminablequartz.func_180709_b(this.worldObj, this.rand, new BlockPos(gx, gy, gz));
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.worldObj.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.worldObj.func_175675_v(blockpos2)) {
                        this.worldObj.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.worldObj.func_175708_f(blockpos1, true)) continue;
                    this.worldObj.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag);
        BlockFalling.field_149832_M = false;
        chunk.func_177446_d(true);
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        List list = null;
        Biome b = this.worldObj.func_180494_b(pos);
        list = b.func_76747_a(creatureType);
        return this.controller.affectCreatureList(creatureType, list, pos);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return this.controller.locateTerrainFeature(worldIn, structureName, position, findUnexplored);
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return this.controller.isInsideFeature(worldIn, structureName, pos);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        this.scatteredFeatureGenerator.func_186125_a(this.worldObj, x, z, null);
    }
}

