/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.storage;

import com.xcompwiz.mystcraft.instability.Deck;
import com.xcompwiz.mystcraft.instability.InstabilityManager;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;

public class StorageInstabilityData
extends WorldSavedData {
    public static final String ID = "MystInstabilityData";
    private HashMap<String, Collection<String>> decks = new HashMap();

    public StorageInstabilityData(String id) {
        super(id);
    }

    public void setAgeData(AgeData data) {
        NBTBase cruft = data.popCruft("instabilityeffects");
        if (cruft == null) {
            return;
        }
        ArrayList cards = NBTUtils.readStringCollection((NBTTagList)cruft, new ArrayList());
        for (String deck : InstabilityManager.getDecks()) {
            this.decks.put(deck, cards);
        }
    }

    public Collection<String> getDeck(String deckname) {
        Collection<String> cards = this.decks.get(deckname);
        if (cards == null) {
            return new ArrayList<String>();
        }
        return Collections.unmodifiableCollection(cards);
    }

    public void updateDeck(Deck deck) {
        ArrayList<String> cards = new ArrayList<String>();
        cards.addAll(deck.getCards());
        this.decks.put(deck.getName(), cards);
        this.func_76185_a();
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Collection<String>> entry : this.decks.entrySet()) {
            NBTTagCompound decknbt = new NBTTagCompound();
            decknbt.func_74778_a("Name", entry.getKey());
            decknbt.func_74782_a("Cards", (NBTBase)NBTUtils.writeStringCollection(new NBTTagList(), entry.getValue()));
            list.func_74742_a((NBTBase)decknbt);
        }
        nbt.func_74782_a("Decks", (NBTBase)list);
        return nbt;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Decks", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound decknbt = list.func_150305_b(i);
            String deckname = decknbt.func_74779_i("Name");
            ArrayList cards = NBTUtils.readStringCollection(decknbt.func_150295_c("Cards", 8), new ArrayList());
            this.decks.put(deckname, cards);
        }
    }
}

