/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.util.render;

import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.plugins.IBaublesPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import trinsdar.gravisuit.util.GravisuitConfig;
import trinsdar.gravisuit.util.Registry;
import trinsdar.gravisuit.util.baubles.BaublesLoader;

public class GUIHandler
extends Gui {
    private static final int ENERGY_LEVEL_FULL_COLOR = 0x55FF55;
    private static final int ENERGY_LEVEL_HIGH_COLOR = 0xFFAA00;
    private static final int ENERGY_LEVEL_LOW_COLOR = 0xFF5555;
    private static final String ENERGY_LEVEL_NAME = I18n.func_135052_a((String)"panelInfo.energyLevel", (Object[])new Object[0]) + ": ";
    private static int energyTextColor;
    private static String energyLevelString;
    private final Minecraft mc;
    private final ScaledResolution scaledResolution;
    private final EntityPlayer player;
    private ItemStack armorStack;
    private Item itemArmor;
    private String statusString;

    public GUIHandler(Minecraft mc) {
        this.mc = mc;
        this.scaledResolution = new ScaledResolution(mc);
        this.player = mc.field_71439_g;
        this.armorStack = this.player.func_184582_a(EntityEquipmentSlot.CHEST);
        this.itemArmor = this.armorStack.func_77973_b();
        this.statusString = "";
        int yPos1 = 3;
        if (GravisuitConfig.client.positions == GravisuitConfig.Client.Positions.BOTTOMLEFT || GravisuitConfig.client.positions == GravisuitConfig.Client.Positions.BOTTOMRIGHT) {
            yPos1 = this.scaledResolution.func_78328_b() - (mc.field_71466_p.field_78288_b * 2 + 5);
        }
        int yPos2 = yPos1 + mc.field_71466_p.field_78288_b + 2;
        if (!this.armorStack.func_190926_b() && this.isJetpackOrLappack(this.itemArmor)) {
            this.handleJetpackRendering(yPos1, yPos2);
        } else if (Loader.isModLoaded((String)"baubles") && IC2.loader.getPlugin("baubles", IBaublesPlugin.class) != null) {
            this.handleBaublesRendering(yPos1, yPos2);
        }
    }

    private boolean isJetpackOrLappack(Item item) {
        return this.or(item, new Item[]{Registry.getAdvancedLappack(), Registry.getUltimateLappack(), Registry.getAdvancedElectricJetpack(), Registry.getAdvancedNuclearJetpack(), Registry.advancedNanoChestplate, Registry.advancedNuclearNanoChestplate, Registry.gravisuit, Registry.nuclearGravisuit, Ic2Items.compactedElectricJetpack.func_77973_b(), Ic2Items.compactedNuclearJetpack.func_77973_b(), Ic2Items.quantumJetplate.func_77973_b(), Ic2Items.quantumNuclearJetplate.func_77973_b(), Ic2Items.lapPack.func_77973_b(), Ic2Items.quantumPack.func_77973_b()});
    }

    private void handleJetpackRendering(int yPos1, int yPos2) {
        int energyStatus;
        int currCharge = this.getCharge(this.armorStack);
        int n = energyStatus = this.itemArmor instanceof IElectricItem ? (int)((double)currCharge / ((IElectricItem)this.itemArmor).getMaxCharge(this.armorStack) * 100.0) : -1;
        if (this.player.field_70173_aa % 20 == 0) {
            energyLevelString = ENERGY_LEVEL_NAME + energyStatus;
            energyTextColor = this.getEnergyTextColor(energyStatus);
        }
        int xPos = 3;
        if (GravisuitConfig.client.positions == GravisuitConfig.Client.Positions.TOPRIGHT || GravisuitConfig.client.positions == GravisuitConfig.Client.Positions.BOTTOMRIGHT) {
            xPos = this.scaledResolution.func_78326_a() - 3 - this.mc.field_71466_p.func_78256_a(energyLevelString + "%");
        } else if (GravisuitConfig.client.positions == GravisuitConfig.Client.Positions.TOPMIDDLE) {
            xPos = (int)((float)this.scaledResolution.func_78326_a() * 0.5f) - this.mc.field_71466_p.func_78256_a(energyLevelString + "%") / 2;
        }
        this.func_73731_b(this.mc.field_71466_p, energyLevelString + "%", xPos, yPos1, energyTextColor);
        if (this.itemArmor != Registry.getAdvancedLappack() && this.itemArmor != Registry.getUltimateLappack() && this.itemArmor != Ic2Items.lapPack.func_77973_b() && this.itemArmor != Ic2Items.quantumPack.func_77973_b()) {
            NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)this.armorStack);
            if (tag.func_74767_n("enabled")) {
                this.statusString = I18n.func_135052_a((String)"panelInfo.gravitationEngineOn", (Object[])new Object[0]);
            } else if (!tag.func_74767_n("disabled") & !tag.func_74767_n("enabled")) {
                String engineStatus = I18n.func_135052_a((String)"panelInfo.jetpackEngineOn", (Object[])new Object[0]) + " ";
                ItemArmorJetpackBase.HoverMode hoverMode = ItemArmorJetpackBase.HoverMode.values()[tag.func_74771_c("HoverMode")];
                this.statusString = engineStatus + this.getHoverModeStatus(hoverMode);
            }
            xPos = 3;
            if (GravisuitConfig.client.positions == GravisuitConfig.Client.Positions.TOPRIGHT || GravisuitConfig.client.positions == GravisuitConfig.Client.Positions.BOTTOMRIGHT) {
                xPos = this.scaledResolution.func_78326_a() - 3 - this.mc.field_71466_p.func_78256_a(this.statusString);
            } else if (GravisuitConfig.client.positions == GravisuitConfig.Client.Positions.TOPMIDDLE) {
                xPos = (int)((float)this.scaledResolution.func_78326_a() * 0.5f) - this.mc.field_71466_p.func_78256_a(this.statusString) / 2;
            }
            this.func_73731_b(this.mc.field_71466_p, this.statusString, xPos, yPos2, 0x55FF55);
        }
    }

    private String getHoverModeStatus(ItemArmorJetpackBase.HoverMode hoverMode) {
        if (hoverMode == ItemArmorJetpackBase.HoverMode.Basic) {
            return "(" + I18n.func_135052_a((String)"panelInfo.jetpackHoverMode", (Object[])new Object[0]) + ")";
        }
        if (hoverMode == ItemArmorJetpackBase.HoverMode.Adv) {
            return "(" + I18n.func_135052_a((String)"panelInfo.jetpackExtremeHoverMode", (Object[])new Object[0]) + ")";
        }
        return "";
    }

    private void handleBaublesRendering(int yPos1, int yPos2) {
        this.armorStack = BaublesLoader.getBaublesChestSlot(this.player);
        this.itemArmor = this.armorStack.func_77973_b();
        if (!this.armorStack.func_190926_b() && this.isJetpackOrLappack(this.itemArmor)) {
            this.handleJetpackRendering(yPos1, yPos2);
        }
    }

    private boolean or(Item compare, Item ... items) {
        for (Item item : items) {
            if (compare != item) continue;
            return true;
        }
        return false;
    }

    private int getEnergyTextColor(int energyLevel) {
        if (energyLevel == 100) {
            return 0x55FF55;
        }
        if (energyLevel > 50) {
            return 0xFFAA00;
        }
        return 0xFF5555;
    }

    private int getCharge(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        return nbt.func_74762_e("charge");
    }
}

