/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.debark;

import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.debark.DebarkMod;
import pl.asie.debark.DebarkProxyCommon;
import pl.asie.debark.messy.DebarkTopSprite;
import pl.asie.debark.messy.LogColoredSprite;
import pl.asie.debark.messy.StrippedBarkColoredSprite;
import pl.asie.debark.util.ModelDataLookup;
import pl.asie.debark.util.ModelLoaderEarlyView;
import pl.asie.debark.util.ResourceUtils;

public class DebarkProxyClient
extends DebarkProxyCommon {
    @Override
    public void preInit() {
        super.preInit();
    }

    @SubscribeEvent
    public void modelRegister(ModelRegistryEvent event) {
        DebarkMod.blocksMap.forEach((state, debarkedBlock) -> {
            ModelResourceLocation invModelLocation = new ModelResourceLocation(debarkedBlock.getBlock().getRegistryName(), "axis=y,variant=" + debarkedBlock.getVariant());
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)debarkedBlock.getBlock()), (int)debarkedBlock.getVariant(), (ModelResourceLocation)invModelLocation);
        });
    }

    @SubscribeEvent
    public void modelBake(ModelBakeEvent event) {
        try {
            IModel baseModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("minecraft", "block/cube_column"));
            DebarkMod.blocksMap.forEach((state, debarkedBlock) -> {
                ResourceLocation blockSide = new ResourceLocation("debark", "blocks/debark_side_" + debarkedBlock.getTextureKey());
                ResourceLocation blockTop = new ResourceLocation("debark", "blocks/debark_top_" + debarkedBlock.getTextureKey());
                IModel retexturedModel = baseModel.retexture(ImmutableMap.of((Object)"side", (Object)blockSide.toString(), (Object)"end", (Object)blockTop.toString(), (Object)"#side", (Object)blockSide.toString(), (Object)"#end", (Object)blockTop.toString()));
                IModel retexturedModelBark = baseModel.retexture(ImmutableMap.of((Object)"side", (Object)blockSide.toString(), (Object)"end", (Object)blockSide.toString(), (Object)"#side", (Object)blockSide.toString(), (Object)"#end", (Object)blockSide.toString()));
                for (BlockLog.EnumAxis axis : BlockLog.EnumAxis.values()) {
                    IModel srcModel = axis == BlockLog.EnumAxis.NONE ? retexturedModelBark : retexturedModel;
                    ModelRotation rotation = ModelRotation.X0_Y0;
                    switch (axis) {
                        case X: {
                            rotation = ModelRotation.X90_Y90;
                            break;
                        }
                        case Z: {
                            rotation = ModelRotation.X90_Y0;
                        }
                    }
                    IBakedModel bakedModel = srcModel.bake((IModelState)rotation, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
                    ModelResourceLocation bakedModelLocation = new ModelResourceLocation(debarkedBlock.getBlock().getRegistryName(), "axis=" + axis.func_176610_l() + ",variant=" + debarkedBlock.getVariant());
                    event.getModelRegistry().func_82595_a((Object)bakedModelLocation, (Object)bakedModel);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void registerTextures(TextureStitchEvent.Pre event) {
        ModelLoaderEarlyView modelLoaderEarlyView = new ModelLoaderEarlyView();
        ResourceLocation templateSide = new ResourceLocation("debark", "blocks/debark_side");
        ResourceLocation templateTop = new ResourceLocation("debark", "blocks/debark_top");
        if (!ResourceUtils.textureExists(templateTop)) {
            event.getMap().setTextureEntry((TextureAtlasSprite)new DebarkTopSprite("debark:blocks/debark_top", new ResourceLocation("minecraft", "blocks/log_oak_top")));
        }
        DebarkMod.blocksMap.forEach((state, debarkedBlock) -> {
            IModel model = modelLoaderEarlyView.getModel((IBlockState)state);
            if (model == null) {
                System.out.println("AAAAAAAAAA");
                return;
            }
            ResourceLocation logTopLocation = ModelDataLookup.getLocation(state, EnumFacing.UP, model);
            ResourceLocation logSideLocation = ModelDataLookup.getLocation(state, EnumFacing.NORTH, model);
            ResourceLocation blockSide = new ResourceLocation("debark", "blocks/debark_side_" + debarkedBlock.getTextureKey());
            ResourceLocation blockTop = new ResourceLocation("debark", "blocks/debark_top_" + debarkedBlock.getTextureKey());
            if (!ResourceUtils.textureExists(blockSide)) {
                if (ResourceUtils.textureExists(templateSide)) {
                    event.getMap().setTextureEntry((TextureAtlasSprite)new LogColoredSprite(blockSide.toString(), logTopLocation, templateSide));
                } else {
                    event.getMap().setTextureEntry((TextureAtlasSprite)new StrippedBarkColoredSprite(blockSide.toString(), logTopLocation, logSideLocation));
                }
            }
            if (!ResourceUtils.textureExists(blockTop)) {
                event.getMap().setTextureEntry((TextureAtlasSprite)new LogColoredSprite(blockTop.toString(), logTopLocation, templateTop));
            }
        });
    }
}

