/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.debark.messy;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import pl.asie.debark.old.UCWColorspaceUtils;
import pl.asie.debark.util.CustomSprite;
import pl.asie.debark.util.SpriteUtils;

public class StrippedBarkColoredSprite
extends CustomSprite {
    private final ResourceLocation logTop;
    private final ResourceLocation logSide;

    public StrippedBarkColoredSprite(String spriteName, ResourceLocation logTop, ResourceLocation logSide) {
        super(spriteName);
        this.logTop = logTop;
        this.logSide = logSide;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableSet.of((Object)this.logTop, (Object)this.logSide);
    }

    private float[] getGammaCorrectedLumaRange(TextureAtlasSprite baseTex, int offset16) {
        float minL = Float.MAX_VALUE;
        float maxL = Float.MIN_VALUE;
        double A = 0.0;
        double B = 0.0;
        int count = 0;
        int offsetX = offset16 * baseTex.func_94211_a() / 16;
        int offsetY = offset16 * baseTex.func_94216_b() / 16;
        int[] baseData = SpriteUtils.getFrameDataOrWarn(baseTex);
        for (int iy = offsetY; iy < baseTex.func_94216_b() - offsetY; ++iy) {
            for (int ix = offsetX; ix < baseTex.func_94211_a() - offsetX; ++ix) {
                int pixel = baseData[iy * baseTex.func_94211_a() + ix];
                float[] lab = UCWColorspaceUtils.XYZtoLAB(UCWColorspaceUtils.sRGBtoXYZ(UCWColorspaceUtils.fromInt(pixel)));
                if (lab[0] < minL) {
                    minL = lab[0];
                }
                if (lab[0] > maxL) {
                    maxL = lab[0];
                }
                A += (double)lab[1];
                B += (double)lab[2];
                ++count;
            }
        }
        assert (count >= 1);
        minL = (float)Math.pow(minL / 100.0f, 2.2) * 100.0f;
        maxL = (float)Math.pow(maxL / 100.0f, 2.2) * 100.0f;
        return new float[]{minL, maxL, (float)(A /= (double)count), (float)(B /= (double)count)};
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        TextureAtlasSprite baseTex = SpriteUtils.loadSpriteOrWarn(this.logSide, textureGetter);
        float[] gcrMiddle = this.getGammaCorrectedLumaRange(SpriteUtils.loadSpriteOrWarn(this.logTop, textureGetter), 2);
        float[] gcrSide = this.getGammaCorrectedLumaRange(baseTex, 0);
        float[] gcrLeft = new float[]{-0.28125f, -0.234375f};
        gcrLeft[0] = gcrLeft[0] * (gcrMiddle[1] - gcrMiddle[0]) + gcrMiddle[0];
        gcrLeft[1] = gcrLeft[1] * (gcrMiddle[1] - gcrMiddle[0]) + gcrMiddle[0];
        if (gcrLeft[0] < 0.0f) {
            gcrLeft[0] = 0.0f;
        }
        if (gcrLeft[1] < 0.0f) {
            gcrLeft[1] = 0.0f;
        }
        int[] templateData = new int[baseTex.func_94211_a() * baseTex.func_94216_b()];
        int[] templateInput = SpriteUtils.getFrameDataOrWarn(baseTex);
        for (int ix = 0; ix < baseTex.func_94211_a(); ++ix) {
            float offset = Math.abs(7.5f - (float)ix * 15.0f / (float)(baseTex.func_94211_a() - 1)) - 2.5f;
            if (offset < 0.0f) {
                offset = 0.0f;
            }
            offset = 1.0f - offset / 5.0f;
            offset = (float)Math.pow(offset, 0.65);
            float minL = gcrLeft[0] * (1.0f - offset) + (gcrMiddle[0] * 0.75f + gcrMiddle[1] * 0.25f) * offset;
            float maxL = gcrLeft[1] * (1.0f - offset) + (gcrMiddle[1] * 0.75f + gcrMiddle[0] * 0.25f) * offset;
            minL /= 100.0f;
            maxL /= 100.0f;
            for (int iy = 0; iy < baseTex.func_94216_b(); ++iy) {
                int ip = iy * baseTex.func_94211_a() + ix;
                int pixel = templateInput[ip];
                float[] lab = UCWColorspaceUtils.XYZtoLAB(UCWColorspaceUtils.sRGBtoXYZ(UCWColorspaceUtils.fromInt(pixel)));
                float lum = (float)Math.pow(lab[0] / 100.0f, 2.2) * 100.0f;
                lum = (lum - gcrSide[0]) / (gcrSide[1] - gcrSide[0]);
                lum = lum * (maxL - minL) + minL;
                lab[0] = lum = (float)Math.pow(lum, 0.45454545454545453) * 100.0f;
                lab[1] = gcrMiddle[2];
                lab[2] = gcrMiddle[3];
                templateData[ip] = UCWColorspaceUtils.asInt(UCWColorspaceUtils.XYZtosRGB(UCWColorspaceUtils.LABtoXYZ(lab))) | 0xFF000000;
            }
        }
        this.func_110966_b(baseTex.func_94211_a());
        this.func_110969_c(baseTex.func_94216_b());
        this.addFrameTextureData(templateData);
        return false;
    }
}

