/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.debark.util;

import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import pl.asie.debark.DebarkMod;

public final class SpriteUtils {
    private static final int[] MISSINGNO_DATA = new int[256];

    private SpriteUtils() {
    }

    public static boolean isMissingno(TextureAtlasSprite sprite) {
        return "missingno".equals(sprite.func_94215_i()) || "minecraft:missingno".equals(sprite.func_94215_i());
    }

    public static TextureAtlasSprite loadSpriteOrWarn(ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> getter) {
        TextureAtlasSprite sprite = getter.apply(location);
        if (sprite == null && (sprite = getter.apply(TextureMap.field_174945_f)) == null) {
            throw new RuntimeException("Could not load " + location + " or fallback!");
        }
        if (SpriteUtils.isMissingno(sprite)) {
            DebarkMod.logger.error("Could not locate texture " + location + "!");
        }
        return sprite;
    }

    public static int[] getFrameDataOrWarn(TextureAtlasSprite sprite) {
        if (SpriteUtils.isMissingno(sprite)) {
            return MISSINGNO_DATA;
        }
        int[][] data = null;
        if (sprite.func_110970_k() <= 0) {
            DebarkMod.logger.error("Could not read texture data for " + sprite.func_94215_i() + "! - invalid frame count " + sprite.func_110970_k() + "!");
            return MISSINGNO_DATA;
        }
        try {
            data = sprite.func_147965_a(0);
        }
        catch (Exception e) {
            DebarkMod.logger.error("Could not read texture data for " + sprite.func_94215_i() + "!", (Throwable)e);
            return MISSINGNO_DATA;
        }
        if (data == null || data.length <= 0 || data[0] == null || data[0].length <= 0) {
            DebarkMod.logger.error("Could not read texture data for " + sprite.func_94215_i() + " - frame 0 array missing!");
            return MISSINGNO_DATA;
        }
        return data[0];
    }

    static {
        for (int i = 0; i < 256; ++i) {
            SpriteUtils.MISSINGNO_DATA[i] = ((i >> 3 ^ i >> 7) & 1) != 0 ? -65281 : -16777216;
        }
    }
}

