/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.linking_tweaks.listeners;

import com.xcompwiz.mystcraft.api.event.StarFissureLinkEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import veovismuaddib.linking_tweaks.ModConfig;
import veovismuaddib.linking_tweaks.ModMain;
import veovismuaddib.linking_tweaks.listeners.StarFissureSavedData;

public class StarFissureDropListener {
    @SubscribeEvent
    public void onStarFissureLink(StarFissureLinkEvent e) {
        if (!ModConfig.fissure_drop.enabled) {
            return;
        }
        StarFissureSavedData data = StarFissureSavedData.get(e.worldObj);
        BlockPos spawn = DimensionManager.getProvider((int)e.info.getDimensionUID()).getRandomizedSpawnPoint();
        e.info.setSpawn(spawn.func_177981_b(ModConfig.fissure_drop.height));
        if (e.entity instanceof EntityLivingBase) {
            data.addSurvivingEntity(e.entity);
            ModMain.logger.info("Preparing to save " + e.entity.getPersistentID().toString() + " from a star fissure fall.");
        }
    }

    @SubscribeEvent
    public void onStarFissureFall(LivingFallEvent e) {
        EntityLivingBase entity = e.getEntityLiving();
        StarFissureSavedData data = StarFissureSavedData.get(e.getEntity().field_70170_p);
        if (data.containsSurvivingEntity((Entity)entity) && !e.getEntity().func_130014_f_().field_72995_K) {
            boolean saved = true;
            switch (ModConfig.fissure_drop.fall_safety_type) {
                case hearts_left: {
                    this.heartsLeftHandler(e, entity);
                    break;
                }
                case hearts_taken: {
                    this.heartsTakenHandler(e, entity);
                    break;
                }
                case no_damage: {
                    this.noDamageHandler(e);
                    break;
                }
                case normal_damage: {
                    saved = false;
                }
            }
            if (saved) {
                ModMain.logger.info("Saved " + entity.getPersistentID().toString() + " from a fall of " + e.getDistance() + "m.");
            }
            data.removeSurvivingEntity((Entity)entity);
        }
    }

    private void heartsLeftHandler(LivingFallEvent e, EntityLivingBase entity) {
        float entityHealth = entity.func_110143_aJ();
        float minimumHealth = Math.min(entityHealth, (float)ModConfig.fissure_drop.fall_safety_hearts);
        entity.func_70097_a(DamageSource.field_76379_h, Math.max(0.0f, entityHealth - minimumHealth));
        e.setDamageMultiplier(0.0f);
    }

    private void heartsTakenHandler(LivingFallEvent e, EntityLivingBase entity) {
        entity.func_70097_a(DamageSource.field_76379_h, (float)ModConfig.fissure_drop.fall_safety_hearts);
        e.setDamageMultiplier(0.0f);
    }

    private void noDamageHandler(LivingFallEvent e) {
        e.setDamageMultiplier(0.0f);
    }
}

