/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import ic2.api.network.INetworkManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.tile.TileCableIC2Sealed;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidPipe;
import micdoodle8.mods.galacticraft.core.tile.TileEntityNull;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnclosed
extends Block
implements IPartialSealableBlock,
ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public static Item[] pipeItemsBC = new Item[6];
    public static Block blockPipeBC = null;
    public static Method onBlockNeighbourChangeIC2a = null;
    public static Method onBlockNeighbourChangeIC2b = null;
    private static Class icCableContainerClass;
    private static Class icWireRegClass;
    private static Field icWireRegInstance;
    private static Method icContainerGetMethod;
    private static Constructor icTileCableConstuctor;
    public static final PropertyEnum<EnumEnclosedBlockType> TYPE;

    public BlockEnclosed(String assetName) {
        super(Material.field_151571_B);
        this.func_149752_b(0.2f);
        this.func_149711_c(0.4f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.ALUMINUM_WIRE.getMeta()));
        list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.ALUMINUM_WIRE_HEAVY.getMeta()));
        list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.OXYGEN_PIPE.getMeta()));
        if (CompatibilityManager.isTELoaded() || GCBlocks.registeringSorted) {
            // empty if block
        }
        if (CompatibilityManager.isIc2Loaded() || GCBlocks.registeringSorted) {
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.IC2_COPPER_CABLE.getMeta()));
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.IC2_GOLD_CABLE.getMeta()));
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.IC2_HV_CABLE.getMeta()));
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.IC2_GLASS_FIBRE_CABLE.getMeta()));
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.IC2_LV_CABLE.getMeta()));
        }
        if (CompatibilityManager.isBCraftTransportLoaded() || GCBlocks.registeringSorted) {
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.BC_ITEM_COBBLESTONEPIPE.getMeta()));
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.BC_ITEM_STONEPIPE.getMeta()));
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.BC_FLUIDS_COBBLESTONEPIPE.getMeta()));
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.BC_FLUIDS_STONEPIPE.getMeta()));
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.BC_POWER_STONEPIPE.getMeta()));
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.BC_POWER_GOLDPIPE.getMeta()));
        }
        if (CompatibilityManager.isAppEngLoaded() || GCBlocks.registeringSorted) {
            list.add((Object)new ItemStack((Block)this, 1, EnumEnclosedBlockType.ME_CABLE.getMeta()));
        }
    }

    public static void initialiseBC() {
        try {
            if (CompatibilityManager.classBCTransport != null) {
                for (int i = 0; i < 6; ++i) {
                    String pipeName = EnumEnclosedBlockType.values()[i + 7].getBCPipeType();
                    BlockEnclosed.pipeItemsBC[i] = (Item)CompatibilityManager.classBCTransport.getField(pipeName).get(null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumEnclosedBlockType type = (EnumEnclosedBlockType)((Object)state.func_177229_b(TYPE));
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (type == EnumEnclosedBlockType.TE_CONDUIT) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        } else if (type == EnumEnclosedBlockType.OXYGEN_PIPE) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
            if (tileEntity instanceof INetworkConnection) {
                ((INetworkConnection)tileEntity).refresh();
            }
        } else if (type.getMeta() <= 6) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
            if (CompatibilityManager.isIc2Loaded() && tileEntity != null) {
                try {
                    if (onBlockNeighbourChangeIC2a != null) {
                        onBlockNeighbourChangeIC2a.invoke((Object)tileEntity, blockIn);
                    } else if (onBlockNeighbourChangeIC2b != null) {
                        onBlockNeighbourChangeIC2b.invoke((Object)tileEntity, blockIn, pos);
                    }
                    return;
                }
                catch (Exception exception) {}
            }
        } else if (type.getMeta() <= 12) {
            if (CompatibilityManager.isBCraftTransportLoaded() && blockPipeBC != null) {
                try {
                    blockPipeBC.func_189540_a(state, worldIn, pos, blockIn, fromPos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        } else if (type.getMeta() <= EnumEnclosedBlockType.ME_CABLE.getMeta()) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
            if (CompatibilityManager.isAppEngLoaded()) {
                // empty if block
            }
        } else if (type.getMeta() <= EnumEnclosedBlockType.ALUMINUM_WIRE.getMeta()) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
            if (tileEntity instanceof IConductor) {
                ((IConductor)tileEntity).refresh();
            }
        } else if (type.getMeta() <= EnumEnclosedBlockType.ALUMINUM_WIRE_HEAVY.getMeta()) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
            if (tileEntity instanceof IConductor) {
                ((IConductor)tileEntity).refresh();
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata != EnumEnclosedBlockType.TE_CONDUIT.getMeta()) {
            if (metadata == EnumEnclosedBlockType.OXYGEN_PIPE.getMeta()) {
                return new TileEntityFluidPipe();
            }
            if (metadata <= 6) {
                if (CompatibilityManager.isIc2Loaded()) {
                    try {
                        EnumEnclosedBlockType enclosedType = EnumEnclosedBlockType.byMetadata(metadata);
                        if (CompatibilityManager.isIc2ClassicLoaded()) {
                            if (icCableContainerClass == null) {
                                icCableContainerClass = Class.forName("ic2.core.block.wiring.cables.CableContainer");
                                icWireRegClass = Class.forName("ic2.core.block.wiring.cables.WireRegistry");
                                icWireRegInstance = icWireRegClass.getDeclaredField("instance");
                                icContainerGetMethod = icWireRegClass.getMethod("getContainerFromMeta", Integer.TYPE);
                                icTileCableConstuctor = CompatibilityManager.classIc2ClassicTileCable.getConstructor(icCableContainerClass);
                            }
                            Object wireRegInstance = icWireRegInstance.get(null);
                            Object container = icContainerGetMethod.invoke(wireRegInstance, enclosedType.icClassicMeta);
                            return (TileEntity)icTileCableConstuctor.newInstance(container);
                        }
                        Enum[] enums = (Enum[])CompatibilityManager.classIC2cableType.getEnumConstants();
                        Enum foundEnum = null;
                        for (Enum e : enums) {
                            if (!e.name().equals(enclosedType.getIc2Enum())) continue;
                            foundEnum = e;
                            break;
                        }
                        return new TileCableIC2Sealed().setupInsulation(foundEnum, enclosedType.getIc2Insulation());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else if (metadata <= 12) {
                if (CompatibilityManager.isBCraftTransportLoaded()) {
                    try {
                        return (TileEntity)CompatibilityManager.classBCTransportPipeTile.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (metadata <= EnumEnclosedBlockType.ME_CABLE.getMeta()) {
                if (CompatibilityManager.isAppEngLoaded()) {
                    try {
                        Class<?> cableBusClass = Class.forName("appeng.tile.networking.TileCableBus");
                        return (TileEntity)cableBusClass.newInstance();
                    }
                    catch (Exception e) {
                        GalacticraftCore.logger.catching(e);
                    }
                }
            } else {
                if (metadata <= EnumEnclosedBlockType.ALUMINUM_WIRE.getMeta()) {
                    return new TileEntityAluminumWire(1);
                }
                if (metadata <= EnumEnclosedBlockType.ALUMINUM_WIRE_HEAVY.getMeta()) {
                    return new TileEntityAluminumWire(2);
                }
            }
        }
        return new TileEntityNull();
    }

    @Override
    public boolean isSealed(World world, BlockPos pos, EnumFacing direction) {
        return true;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        int metadata = stack.func_77952_i();
        if (metadata >= EnumEnclosedBlockType.BC_ITEM_STONEPIPE.getMeta() && metadata <= EnumEnclosedBlockType.BC_POWER_GOLDPIPE.getMeta()) {
            try {
                TileEntity tile = worldIn.func_175625_s(pos);
                if (CompatibilityManager.classBCTransportPipeTile.isInstance(tile)) {
                    Method m = CompatibilityManager.classBCTransportPipeTile.getMethod("onPlacedBy", EntityLivingBase.class, ItemStack.class);
                    m.invoke((Object)tile, placer, new ItemStack(pipeItemsBC[metadata - 7]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!worldIn.field_72995_K && metadata <= EnumEnclosedBlockType.IC2_LV_CABLE.getMeta() && metadata != EnumEnclosedBlockType.OXYGEN_PIPE.getMeta() && metadata != EnumEnclosedBlockType.TE_CONDUIT.getMeta() && CompatibilityManager.isIc2Loaded() && (te = worldIn.func_175625_s(pos)) != null) {
            try {
                Object network = CompatibilityManager.fieldIC2networkManager.get(null);
                if (CompatibilityManager.isIc2ClassicLoaded()) {
                    Method get = network.getClass().getMethod("get", new Class[0]);
                    Object manager = get.invoke(network, new Object[0]);
                    Method sendMethod = CompatibilityManager.classIc2ClassicNetworkManager.getMethod("sendInitialData", EntityPlayerMP.class, TileEntity.class);
                    sendMethod.invoke(manager, placer, te);
                } else {
                    INetworkManager manager = null;
                    Method get = network.getClass().getMethod("get", Boolean.TYPE);
                    manager = (INetworkManager)get.invoke(network, true);
                    if (manager != null) {
                        manager.sendInitialData(te);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumEnclosedBlockType type = EnumEnclosedBlockType.byMetadata(meta);
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumEnclosedBlockType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.TRANSMITTER;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    static {
        TYPE = PropertyEnum.func_177709_a((String)"type", EnumEnclosedBlockType.class);
    }

    public static enum EnumEnclosedBlockType implements IStringSerializable
    {
        IC2_HV_CABLE(0, "iron", 2, 7, "enclosed_hv_cable"),
        OXYGEN_PIPE(1, "enclosed_fluid_pipe"),
        IC2_COPPER_CABLE(2, "copper", 1, 1, "enclosed_copper_cable"),
        IC2_GOLD_CABLE(3, "gold", 2, 4, "enclosed_gold_cable"),
        TE_CONDUIT(4, "enclosed_te_conduit"),
        IC2_GLASS_FIBRE_CABLE(5, "glass", 0, 9, "enclosed_glass_fibre_cable"),
        IC2_LV_CABLE(6, "tin", 1, 10, "enclosed_lv_cable"),
        BC_ITEM_STONEPIPE(7, "pipeItemStone", "enclosed_pipe_items_stone"),
        BC_ITEM_COBBLESTONEPIPE(8, "pipeItemCobble", "enclosed_pipe_items_cobblestone"),
        BC_FLUIDS_STONEPIPE(9, "pipeFluidStone", "enclosed_pipe_fluids_stone"),
        BC_FLUIDS_COBBLESTONEPIPE(10, "pipeFluidCobble", "enclosed_pipe_fluids_cobblestone"),
        BC_POWER_STONEPIPE(11, "pipePowerStone", "enclosed_pipe_power_stone"),
        BC_POWER_GOLDPIPE(12, "pipePowerGold", "enclosed_pipe_power_gold"),
        ME_CABLE(13, "enclosed_me_cable"),
        ALUMINUM_WIRE(14, "enclosed_aluminum_wire"),
        ALUMINUM_WIRE_HEAVY(15, "enclosed_heavy_aluminum_wire");

        private final int meta;
        private final String name;
        private final String ic2Enum;
        private final int ic2Insulation;
        private final int icClassicMeta;
        private final String bcPipeType;
        private static final EnumEnclosedBlockType[] values;

        private EnumEnclosedBlockType(int meta, String bcPipeType, String name) {
            this(meta, null, -1, -1, bcPipeType, name);
        }

        private EnumEnclosedBlockType(int meta, String name) {
            this(meta, null, -1, -1, null, name);
        }

        private EnumEnclosedBlockType(int meta, String ic2Enum, int ic2Insulation, int icClassicMeta, String name) {
            this(meta, ic2Enum, ic2Insulation, icClassicMeta, null, name);
        }

        private EnumEnclosedBlockType(int meta, String ic2Enum, int ic2Insulation, int icClassicMeta, String bcPipeType, String name) {
            this.meta = meta;
            this.ic2Enum = ic2Enum;
            this.ic2Insulation = ic2Insulation;
            this.icClassicMeta = icClassicMeta;
            this.bcPipeType = bcPipeType;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String getIc2Enum() {
            return this.ic2Enum;
        }

        public int getIc2Insulation() {
            return this.ic2Insulation;
        }

        public String getBCPipeType() {
            return this.bcPipeType;
        }

        public static EnumEnclosedBlockType byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumEnclosedBlockType.values();
        }
    }
}

