/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.railcraft.patcher;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public final class IC2EmitterLogicPatcher
extends ClassVisitor {
    public IC2EmitterLogicPatcher(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        switch (name) {
            case "onStructureChanged": {
                return new StructureChangedPatcher(this.api, mv);
            }
            case "addToNet": {
                return new AddToENetPatcher(this.api, mv);
            }
            case "dropFromNet": {
                return new RemoveFromENetPatcher(this.api, mv);
            }
        }
        return mv;
    }

    static final class RemoveFromENetPatcher
    extends MethodVisitor {
        private final MethodVisitor realMv;

        public RemoveFromENetPatcher(int api, MethodVisitor mv) {
            super(api, null);
            this.realMv = mv;
        }

        public void visitCode() {
            this.realMv.visitCode();
            this.realMv.visitVarInsn(25, 0);
            this.realMv.visitFieldInsn(180, "mods/railcraft/common/blocks/logic/IC2EmitterLogic", "added", "Z");
            Label jumpTarget = new Label();
            this.realMv.visitJumpInsn(154, jumpTarget);
            this.realMv.visitInsn(177);
            this.realMv.visitFrame(3, 0, new Object[0], 0, new Object[0]);
            this.realMv.visitLabel(jumpTarget);
            this.realMv.visitVarInsn(25, 0);
            this.realMv.visitInsn(89);
            this.realMv.visitInsn(3);
            this.realMv.visitFieldInsn(181, "mods/railcraft/common/blocks/logic/IC2EmitterLogic", "added", "Z");
            this.realMv.visitMethodInsn(184, "info/tritusk/modpack/railcraft/patcher/IC2Hook", "removeFromENet0", "(Lmods/railcraft/common/blocks/logic/IC2EmitterLogic;)V", false);
            this.realMv.visitInsn(177);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            this.realMv.visitMaxs(3, 3);
        }

        public void visitEnd() {
            this.realMv.visitEnd();
        }
    }

    static final class AddToENetPatcher
    extends MethodVisitor {
        private final MethodVisitor realMv;

        public AddToENetPatcher(int api, MethodVisitor mv) {
            super(api, null);
            this.realMv = mv;
        }

        public void visitParameter(String name, int access) {
            this.realMv.visitParameter(name, access);
        }

        public void visitCode() {
            this.realMv.visitCode();
            this.realMv.visitVarInsn(25, 0);
            this.realMv.visitFieldInsn(180, "mods/railcraft/common/blocks/logic/IC2EmitterLogic", "added", "Z");
            Label jumpTarget = new Label();
            this.realMv.visitJumpInsn(153, jumpTarget);
            this.realMv.visitInsn(177);
            this.realMv.visitFrame(3, 0, new Object[0], 0, new Object[0]);
            this.realMv.visitLabel(jumpTarget);
            this.realMv.visitVarInsn(25, 0);
            this.realMv.visitInsn(89);
            this.realMv.visitInsn(4);
            this.realMv.visitFieldInsn(181, "mods/railcraft/common/blocks/logic/IC2EmitterLogic", "added", "Z");
            this.realMv.visitMethodInsn(184, "info/tritusk/modpack/railcraft/patcher/IC2Hook", "addToENet0", "(Lmods/railcraft/common/blocks/logic/IC2EmitterLogic;)V", false);
            this.realMv.visitInsn(177);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            this.realMv.visitMaxs(3, 3);
        }

        public void visitEnd() {
            this.realMv.visitEnd();
        }
    }

    static final class StructureChangedPatcher
    extends MethodVisitor {
        private int firstArgRefCount = 0;

        public StructureChangedPatcher(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            desc = "(Lmods/railcraft/common/blocks/logic/IC2EmitterLogic;ZZ)Ljava/util/function/Consumer;";
            bsmArgs[1] = new Handle(6, "info/tritusk/modpack/railcraft/patcher/IC2Hook", "eNetCallback", "(Lmods/railcraft/common/blocks/logic/IC2EmitterLogic;ZZLnet/minecraft/world/World;)V", false);
            if (this.firstArgRefCount == 1) {
                super.visitVarInsn(21, 1);
            }
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }

        public void visitVarInsn(int opcode, int var) {
            if (opcode == 21 && var == 1) {
                ++this.firstArgRefCount;
            }
            super.visitVarInsn(opcode, var);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(maxStack + 1, maxLocals + 1);
        }
    }
}

