/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.blocks.crafter;

import griglog.thaumtweaks.SF;
import griglog.thaumtweaks.blocks.crafter.helpers.CrystalHandler;
import griglog.thaumtweaks.blocks.crafter.helpers.ExitHandler;
import griglog.thaumtweaks.blocks.crafter.helpers.GridHandler;
import griglog.thaumtweaks.items.ItemFiller;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.ThaumcraftInvHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.ContainerDummy;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.common.container.InventoryArcaneWorkbench;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraHandler;

public class TileArcaneCrafter
extends TileEntity {
    public InventoryArcaneWorkbench inventoryCraft = new InventoryArcaneWorkbench((TileEntity)this, (Container)new ContainerDummy());
    public InventoryCraftResult inventoryResult = new InventoryCraftResult();
    public int auraVisServer = 0;
    public int auraVisClient = 0;
    private static final EnumFacing[] FACES_GRID = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.WEST};
    private static final EnumFacing[] FACES_CRYSTALS = new EnumFacing[]{EnumFacing.SOUTH};
    private static final EnumFacing[] FACES_EXIT = new EnumFacing[]{EnumFacing.DOWN};
    private static final HashMap<Aspect, Integer> aspectSlots = new HashMap<Aspect, Integer>(){
        {
            this.put(Aspect.AIR, 0);
            this.put(Aspect.FIRE, 1);
            this.put(Aspect.WATER, 2);
            this.put(Aspect.EARTH, 3);
            this.put(Aspect.ORDER, 4);
            this.put(Aspect.ENTROPY, 5);
        }
    };
    CrystalHandler crystals = new CrystalHandler((TileEntity)this, (InventoryCrafting)this.inventoryCraft);
    GridHandler grid = new GridHandler((TileEntity)this, (InventoryCrafting)this.inventoryCraft);
    ExitHandler exit = new ExitHandler((TileEntity)this, this.inventoryResult);
    boolean ignoreInvUpdates = false;

    public void onInventoryUpdate() {
        if (!this.ignoreInvUpdates) {
            this.ignoreInvUpdates = true;
            this.checkCrafting();
            this.ignoreInvUpdates = false;
        }
    }

    public void checkCrafting() {
        boolean hasVis;
        FakePlayer player;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        InventoryCrafting grid = this.parseFillers(this.inventoryCraft);
        IArcaneRecipe recipe = ThaumcraftCraftingManager.findMatchingArcaneRecipe((InventoryCrafting)grid, (EntityPlayer)(player = SF.getFake((WorldServer)this.field_145850_b)));
        if (recipe == null) {
            return;
        }
        if (!((IPlayerKnowledge)this.getCapability(ThaumcraftCapabilities.KNOWLEDGE, null)).isResearchKnown(recipe.getResearch())) {
            return;
        }
        int vis = recipe.getVis();
        this.updateAura();
        boolean bl = this.func_145831_w().field_72995_K ? this.auraVisClient >= vis : (hasVis = this.auraVisServer >= vis);
        if (hasVis && this.hasCrystals((IRecipe)recipe)) {
            this.autoCraftOneItem(recipe);
        }
    }

    private void autoCraftOneItem(IArcaneRecipe recipe) {
        InventoryCrafting parsedGrid = this.parseFillers(this.inventoryCraft);
        ItemStack itemstack = recipe.func_77572_b(parsedGrid);
        ItemStack current = this.inventoryResult.func_70301_a(0);
        int count = current.func_190916_E();
        if (count + itemstack.func_190916_E() <= current.func_77976_d()) {
            count += itemstack.func_190916_E();
            this.consumeItems(recipe);
        }
        current = itemstack.func_77946_l();
        current.func_190920_e(count);
        this.inventoryResult.func_70299_a(0, current);
    }

    private boolean hasCrystals(IRecipe recipe) {
        boolean hasCrystals = true;
        AspectList crystals = ((IArcaneRecipe)recipe).getCrystals();
        if (crystals != null && crystals.size() > 0) {
            Aspect[] aspects;
            for (Aspect aspect : aspects = crystals.getAspects()) {
                if (ThaumcraftInvHelper.countTotalItemsIn((IItemHandler)ThaumcraftInvHelper.wrapInventory((IInventory)this.parseFillers(this.inventoryCraft), (EnumFacing)EnumFacing.UP), (ItemStack)ThaumcraftApiHelper.makeCrystal((Aspect)aspect, (int)crystals.getAmount(aspect)), (ThaumcraftInvHelper.InvFilter)ThaumcraftInvHelper.InvFilter.STRICT) >= crystals.getAmount(aspect)) continue;
                hasCrystals = false;
                break;
            }
        }
        return hasCrystals;
    }

    private void consumeItems(IArcaneRecipe recipe) {
        int vis;
        for (int i = 0; i < this.grid.getSlots(); ++i) {
            ItemStack is = this.grid.getStackInSlot(i);
            if (is.func_190926_b() || is.func_77973_b() instanceof ItemFiller) continue;
            is.func_190920_e(is.func_190916_E() - 1);
        }
        if (recipe.getCrystals() != null && recipe.getCrystals().getAspects() != null) {
            for (Aspect a : recipe.getCrystals().getAspects()) {
                ItemStack is = this.crystals.getStackInSlot(aspectSlots.get(a));
                is.func_190920_e(is.func_190916_E() - recipe.getCrystals().getAmount(a));
            }
        }
        if ((vis = recipe.getVis()) > 0) {
            this.updateAura();
            this.spendAura(vis);
        }
    }

    private InventoryCrafting parseFillers(InventoryArcaneWorkbench inv) {
        InventoryArcaneWorkbench res = new InventoryArcaneWorkbench(null, (Container)new ContainerDummy());
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() instanceof ItemFiller) {
                stack = ItemStack.field_190927_a;
            }
            res.func_70299_a(i, stack);
        }
        return res;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.exit);
            }
            if (facing == EnumFacing.func_82600_a((int)this.func_145832_p())) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.crystals);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.grid);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NonNullList contents = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)contents);
        for (int i = 0; i < 15; ++i) {
            this.inventoryCraft.func_70299_a(i, (ItemStack)contents.get(i));
        }
        this.inventoryResult.func_70299_a(0, (ItemStack)contents.get(15));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NonNullList contents = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < 15; ++i) {
            contents.set(i, (Object)this.inventoryCraft.func_70301_a(i));
        }
        contents.set(15, (Object)this.inventoryResult.func_70301_a(0));
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)contents);
        return nbt;
    }

    public void updateAura() {
        if (!this.func_145831_w().field_72995_K) {
            int t = 0;
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a()).func_177230_c() != BlocksTC.arcaneWorkbenchCharger) {
                t = (int)AuraHandler.getVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
            } else {
                int sx = this.field_174879_c.func_177958_n() >> 4;
                int sz = this.field_174879_c.func_177952_p() >> 4;
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        AuraChunk ac = AuraHandler.getAuraChunk((int)this.field_145850_b.field_73011_w.getDimension(), (int)(sx + xx), (int)(sz + zz));
                        if (ac == null) continue;
                        t = (int)((float)t + ac.getVis());
                    }
                }
            }
            this.auraVisServer = t;
        }
    }

    public void spendAura(int vis) {
        if (!this.func_145831_w().field_72995_K) {
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a()).func_177230_c() == BlocksTC.arcaneWorkbenchCharger) {
                int q = vis;
                int z = Math.max(1, vis / 9);
                int attempts = 0;
                while (q > 0) {
                    ++attempts;
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            if (z > q) {
                                z = q;
                            }
                            if ((q = (int)((float)q - AuraHandler.drainVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(xx * 16, 0, zz * 16), (float)z, (boolean)false))) > 0 && attempts <= 1000) continue;
                            return;
                        }
                    }
                }
            } else {
                AuraHandler.drainVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (float)vis, (boolean)false);
            }
        }
    }
}

