/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.mixins.blocks;

import griglog.thaumtweaks.TTConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.IInfusionStabiliser;
import thaumcraft.api.crafting.IInfusionStabiliserExt;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.blocks.devices.BlockPedestal;
import thaumcraft.common.tiles.TileThaumcraft;
import thaumcraft.common.tiles.crafting.TileInfusionMatrix;

@Mixin(value={TileInfusionMatrix.class})
public abstract class MatrixMixin
extends TileThaumcraft {
    @Shadow(remap=false)
    private ArrayList<BlockPos> pedestals;
    @Shadow(remap=false)
    HashMap<Block, Integer> tempBlockCount;
    @Shadow(remap=false)
    private ArrayList<BlockPos> problemBlocks;
    @Shadow(remap=false)
    private int cycleTime;
    @Shadow(remap=false)
    public float stabilityReplenish;
    @Shadow(remap=false)
    public float costMult;
    @Shadow(remap=false)
    private int countDelay;

    private void getSurroundings() {
        this.pedestals.clear();
        this.tempBlockCount.clear();
        this.problemBlocks.clear();
        this.cycleTime = 10;
        this.stabilityReplenish = 0.0f;
        this.costMult = 1.0f;
        HashSet<Long> stuff = new HashSet<Long>();
        try {
            this.findAffectors(stuff);
            this.iterateFoundAffectors(stuff);
            this.checkPillarMaterials();
            this.checkBoostStones();
            this.checkPedestalMaterials();
            this.countDelay = Math.max(1, this.cycleTime / 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void findAffectors(Set<Long> stuff) {
        for (int xx = -8; xx <= 8; ++xx) {
            for (int zz = -8; zz <= 8; ++zz) {
                for (int yy = -3; yy <= 7; ++yy) {
                    int z;
                    int y;
                    if (xx == 0 && zz == 0) continue;
                    int x = this.field_174879_c.func_177958_n() + xx;
                    BlockPos pos = new BlockPos(x, y = this.field_174879_c.func_177956_o() - yy, z = this.field_174879_c.func_177952_p() + zz);
                    Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
                    if (block instanceof BlockPedestal) {
                        this.pedestals.add(pos);
                    }
                    try {
                        if (block != Blocks.field_150465_bP && (!(block instanceof IInfusionStabiliser) || !((IInfusionStabiliser)block).canStabaliseInfusion(this.func_145831_w(), pos))) continue;
                        stuff.add(pos.func_177986_g());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void iterateFoundAffectors(Set<Long> stuff) {
        Long[] stuffPoses;
        while (!stuff.isEmpty() && (stuffPoses = stuff.toArray(new Long[0]))[0] != null) {
            long lpos = stuffPoses[0];
            try {
                BlockPos pos = BlockPos.func_177969_a((long)lpos);
                int x = 2 * this.field_174879_c.func_177958_n() - pos.func_177958_n();
                int z = 2 * this.field_174879_c.func_177952_p() - pos.func_177952_p();
                BlockPos posSym = new BlockPos(x, pos.func_177956_o(), z);
                Block b1 = this.field_145850_b.func_180495_p(pos).func_177230_c();
                Block b2 = this.field_145850_b.func_180495_p(posSym).func_177230_c();
                this.affectStability(pos, posSym, b1, b2);
                stuff.remove(posSym.func_177986_g());
            }
            catch (Exception exception) {
                // empty catch block
            }
            stuff.remove(lpos);
        }
    }

    void affectStability(BlockPos pos, BlockPos posSym, Block b1, Block b2) {
        float amt1 = 0.1f;
        float amt2 = 0.1f;
        if (b1 instanceof IInfusionStabiliserExt) {
            amt1 = ((IInfusionStabiliserExt)b1).getStabilizationAmount(this.func_145831_w(), pos);
        }
        if (b2 instanceof IInfusionStabiliserExt) {
            amt2 = ((IInfusionStabiliserExt)b2).getStabilizationAmount(this.func_145831_w(), posSym);
        }
        if (b1 == b2 && amt1 == amt2) {
            if (b1 instanceof IInfusionStabiliserExt && ((IInfusionStabiliserExt)b1).hasSymmetryPenalty(this.func_145831_w(), pos, posSym)) {
                this.stabilityReplenish -= ((IInfusionStabiliserExt)b1).getSymmetryPenalty(this.func_145831_w(), pos);
                this.problemBlocks.add(pos);
            } else {
                this.stabilityReplenish += this.calcDeminishingReturns(b1, amt1);
            }
        } else {
            this.stabilityReplenish -= Math.max(amt1, amt2);
            this.problemBlocks.add(pos);
        }
    }

    void checkPillarMaterials() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, -1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, -1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, 1)).func_177230_c() instanceof BlockPillar && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, 1)).func_177230_c() instanceof BlockPillar) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, -1)).func_177230_c() == BlocksTC.pillarAncient && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, -1)).func_177230_c() == BlocksTC.pillarAncient && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, 1)).func_177230_c() == BlocksTC.pillarAncient && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, 1)).func_177230_c() == BlocksTC.pillarAncient) {
                this.cycleTime -= TTConfig.matrix.allow ? TTConfig.matrix.ancientSpeedUp : 1;
                this.costMult = (float)((double)this.costMult - (TTConfig.matrix.allow ? TTConfig.matrix.ancientDiscount : 0.1));
                this.stabilityReplenish -= 0.1f;
            }
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, -1)).func_177230_c() == BlocksTC.pillarEldritch && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, -1)).func_177230_c() == BlocksTC.pillarEldritch && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, -2, 1)).func_177230_c() == BlocksTC.pillarEldritch && this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, -2, 1)).func_177230_c() == BlocksTC.pillarEldritch) {
                this.cycleTime -= TTConfig.matrix.allow ? TTConfig.matrix.eldritchSpeedUp : 3;
                this.costMult = (float)((double)this.costMult + (TTConfig.matrix.allow ? TTConfig.matrix.eldritchIncrease : 0.05));
                this.stabilityReplenish += 0.2f;
            }
        }
    }

    void checkBoostStones() {
        double dCycleTime = 0.0;
        int[] xm = new int[]{-1, 1, 1, -1};
        int[] zm = new int[]{-1, -1, 1, 1};
        for (int a = 0; a < 4; ++a) {
            Block b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(xm[a], -3, zm[a])).func_177230_c();
            if (b == BlocksTC.matrixSpeed) {
                dCycleTime -= TTConfig.matrix.allow ? TTConfig.matrix.stoneSpeedSpeed : 1.0;
                this.costMult = (float)((double)this.costMult + (TTConfig.matrix.allow ? TTConfig.matrix.stoneSpeedCost : 0.01));
            }
            if (b != BlocksTC.matrixCost) continue;
            dCycleTime += TTConfig.matrix.allow ? TTConfig.matrix.stoneSlowSpeed : 1.0;
            this.costMult = (float)((double)this.costMult - (TTConfig.matrix.allow ? TTConfig.matrix.stoneSlowCost : 0.02));
        }
        this.cycleTime = (int)((double)this.cycleTime + dCycleTime);
    }

    void checkPedestalMaterials() {
        for (BlockPos pedPos : this.pedestals) {
            int x = this.field_174879_c.func_177958_n() - pedPos.func_177958_n();
            int z = this.field_174879_c.func_177952_p() - pedPos.func_177952_p();
            Block block = this.field_145850_b.func_180495_p(pedPos).func_177230_c();
            if (block == BlocksTC.pedestalEldritch) {
                this.costMult = (float)((double)this.costMult - (TTConfig.matrix.allow ? TTConfig.matrix.pedestalEldritchCost : 0.0025));
            }
            if (block != BlocksTC.pedestalAncient) continue;
            this.costMult = (float)((double)this.costMult - (TTConfig.matrix.allow ? TTConfig.matrix.pedestalAncientCost : 0.01));
        }
    }

    @Shadow(remap=false)
    private float calcDeminishingReturns(Block sb1, float amt1) {
        return 0.0f;
    }
}

