/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.mixins.events;

import griglog.thaumtweaks.SF;
import griglog.thaumtweaks.TTConfig;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.common.entities.construct.EntityOwnedConstruct;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.items.armor.ItemFortressArmor;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.events.EntityEvents;
import thaumcraft.common.lib.events.PlayerEvents;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXShield;
import thaumcraft.common.lib.utils.EntityUtils;

@Mixin(value={EntityEvents.class})
public class EntityEventsMixin {
    private static HashMap<Integer, Integer> lastMaxCharge;
    private static HashMap<Integer, Integer> runicInfo;

    @Inject(method={"entityHurt"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void entityHurt(LivingHurtEvent event, CallbackInfo ci) {
        EntityEventsMixin.knowledgeStuff(event);
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityEventsMixin.tryHealingMask(event);
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            EntityEventsMixin.tryWitherMask(event, player);
            EntityEventsMixin.runicShielding(event, player);
        } else {
            if (EntityEventsMixin.tryTaint(event)) {
                return;
            }
            if (event.getEntity() instanceof EntityMob) {
                EntityEventsMixin.tryChampionStuff(event);
            }
        }
    }

    private static void knowledgeStuff(LivingHurtEvent event) {
        IPlayerKnowledge knowledge;
        if (event.getSource().func_76347_k() && event.getEntity() instanceof EntityPlayer && ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)((EntityPlayer)event.getEntity()), (String[])new String[]{"BASEAUROMANCY@2"}) && !ThaumcraftCapabilities.knowsResearch((EntityPlayer)((EntityPlayer)event.getEntity()), (String[])new String[]{"f_onfire"})) {
            knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)((EntityPlayer)event.getEntity()));
            knowledge.addResearch("f_onfire");
            knowledge.sync((EntityPlayerMP)event.getEntity());
            ((EntityPlayer)event.getEntity()).func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"got.onfire")), true);
        }
        if (event.getSource().func_76364_f() != null && event.getEntity() instanceof EntityPlayer && ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)((EntityPlayer)event.getEntity()), (String[])new String[]{"FOCUSPROJECTILE@2"})) {
            knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)((EntityPlayer)event.getEntity()));
            if (!ThaumcraftCapabilities.knowsResearch((EntityPlayer)((EntityPlayer)event.getEntity()), (String[])new String[]{"f_arrow"}) && event.getSource().func_76364_f() instanceof EntityArrow) {
                knowledge.addResearch("f_arrow");
                knowledge.sync((EntityPlayerMP)event.getEntity());
                ((EntityPlayer)event.getEntity()).func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"got.projectile")), true);
            }
            if (!ThaumcraftCapabilities.knowsResearch((EntityPlayer)((EntityPlayer)event.getEntity()), (String[])new String[]{"f_fireball"}) && event.getSource().func_76364_f() instanceof EntityFireball) {
                knowledge.addResearch("f_fireball");
                knowledge.sync((EntityPlayerMP)event.getEntity());
                ((EntityPlayer)event.getEntity()).func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"got.projectile")), true);
            }
            if (!ThaumcraftCapabilities.knowsResearch((EntityPlayer)((EntityPlayer)event.getEntity()), (String[])new String[]{"f_spit"}) && event.getSource().func_76364_f() instanceof EntityLlamaSpit) {
                knowledge.addResearch("f_spit");
                knowledge.sync((EntityPlayerMP)event.getEntity());
                ((EntityPlayer)event.getEntity()).func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"got.projectile")), true);
            }
        }
    }

    private static void runicShielding(LivingHurtEvent event, EntityPlayer player) {
        int charge = (int)player.func_110139_bj();
        if (charge > 0 && runicInfo.containsKey(player.func_145782_y()) && lastMaxCharge.containsKey(player.func_145782_y())) {
            long time = System.currentTimeMillis();
            int target = -1;
            if (event.getSource().func_76346_g() != null) {
                target = event.getSource().func_76346_g().func_145782_y();
            }
            if (event.getSource() == DamageSource.field_76379_h) {
                target = -2;
            }
            if (event.getSource() == DamageSource.field_82729_p) {
                target = -3;
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXShield(event.getEntity().func_145782_y(), target), new NetworkRegistry.TargetPoint(event.getEntity().field_70170_p.field_73011_w.getDimension(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, 32.0));
        }
    }

    private static void tryWitherMask(LivingHurtEvent event, EntityPlayer player) {
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            ItemStack helm = (ItemStack)player.field_71071_by.field_70460_b.get(3);
            if (!helm.func_190926_b() && helm.func_77973_b() instanceof ItemFortressArmor && helm.func_77942_o() && helm.func_77978_p().func_74764_b("mask") && helm.func_77978_p().func_74762_e("mask") == 1) {
                try {
                    if (TTConfig.fortressMask.allow) {
                        attacker.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 20 * TTConfig.fortressMask.witherDuration, TTConfig.fortressMask.witherLevel - 1));
                    } else if (player.field_70170_p.field_73012_v.nextFloat() < event.getAmount() / 10.0f) {
                        attacker.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 80));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void tryHealingMask(LivingHurtEvent event) {
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        ItemStack helm = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (!helm.func_190926_b() && helm.func_77973_b() instanceof ItemFortressArmor && helm.func_77942_o() && helm.func_77978_p().func_74764_b("mask") && helm.func_77978_p().func_74762_e("mask") == 2) {
            if (TTConfig.fortressMask.allow) {
                player.func_70691_i(event.getAmount() * (float)TTConfig.fortressMask.healCoeff);
            } else if (player.field_70170_p.field_73012_v.nextFloat() < event.getAmount() / 12.0f) {
                player.func_70691_i(1.0f);
            }
        }
    }

    private static void tryChampionStuff(LivingHurtEvent event) {
        int t;
        EntityMob mob;
        IAttributeInstance cai = ((EntityMob)event.getEntity()).func_110148_a(ThaumcraftApiHelper.CHAMPION_MOD);
        if (cai != null && cai.func_111126_e() >= 0.0 || event.getEntity() instanceof IEldritchMob) {
            mob = (EntityMob)event.getEntity();
            t = (int)cai.func_111126_e();
            if ((t == 5 || event.getEntity() instanceof IEldritchMob) && mob.func_110139_bj() > 0.0f) {
                int target = -1;
                if (event.getSource().func_76346_g() != null) {
                    target = event.getSource().func_76346_g().func_145782_y();
                }
                if (event.getSource() == DamageSource.field_76379_h) {
                    target = -2;
                }
                if (event.getSource() == DamageSource.field_82729_p) {
                    target = -3;
                }
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXShield(mob.func_145782_y(), target), new NetworkRegistry.TargetPoint(event.getEntity().field_70170_p.field_73011_w.getDimension(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, 32.0));
                event.getEntity().func_184185_a(SoundsTC.runicShieldCharge, 0.66f, 1.1f + event.getEntity().field_70170_p.field_73012_v.nextFloat() * 0.1f);
            } else if (t >= 0 && ChampionModifier.mods[t].type == 2 && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
                event.setAmount(ChampionModifier.mods[t].effect.performEffect((EntityLivingBase)mob, attacker, event.getSource(), event.getAmount()));
            }
        }
        if (event.getAmount() > 0.0f && event.getSource().func_76346_g() != null && event.getEntity() instanceof EntityLivingBase && event.getSource().func_76346_g() instanceof EntityMob && ((EntityMob)event.getSource().func_76346_g()).func_110148_a(ThaumcraftApiHelper.CHAMPION_MOD).func_111126_e() >= 0.0) {
            mob = (EntityMob)event.getSource().func_76346_g();
            t = (int)mob.func_110148_a(ThaumcraftApiHelper.CHAMPION_MOD).func_111126_e();
            if (ChampionModifier.mods[t].type == 1) {
                event.setAmount(ChampionModifier.mods[t].effect.performEffect((EntityLivingBase)mob, (EntityLivingBase)event.getEntity(), event.getSource(), event.getAmount()));
            }
        }
    }

    private static boolean tryTaint(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving().func_110143_aJ() < 2.0f && !event.getEntityLiving().func_70662_br() && !event.getEntityLiving().field_70128_L && !(event.getEntityLiving() instanceof EntityOwnedConstruct) && !(event.getEntityLiving() instanceof ITaintedMob) && event.getEntityLiving().func_70644_a(PotionFluxTaint.instance) && event.getEntityLiving().func_70681_au().nextBoolean()) {
            EntityUtils.makeTainted((EntityLivingBase)event.getEntityLiving());
            return true;
        }
        return false;
    }

    static {
        try {
            Field f = PlayerEvents.class.getDeclaredField("lastMaxCharge");
            f.setAccessible(true);
            lastMaxCharge = (HashMap)f.get(null);
            f = PlayerEvents.class.getDeclaredField("runicInfo");
            f.setAccessible(true);
            runicInfo = (HashMap)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            for (Field f : PlayerEvents.class.getDeclaredFields()) {
                SF.print(f.getName());
            }
            e.printStackTrace();
        }
    }
}

