/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.mixins.events;

import baubles.api.BaublesApi;
import griglog.thaumtweaks.TTConfig;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.common.config.ModConfig;
import thaumcraft.common.lib.events.PlayerEvents;

@Mixin(value={PlayerEvents.class})
public class PlayerEventsMixin {
    private static final double XP_MULT = TTConfig.curBand.xpMult;
    private static final int THEORY_MULT = TTConfig.curBand.theorMult;
    @Shadow(remap=false)
    static HashMap<Integer, Long> nextCycle;
    @Shadow(remap=false)
    static HashMap<Integer, Integer> lastCharge;
    @Shadow(remap=false)
    static HashMap<Integer, Integer> runicInfo;

    @Inject(method={"pickupXP"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void pickupXP(PlayerPickupXpEvent event, CallbackInfo ci) {
        if (TTConfig.curBand.allow && event.getEntityPlayer() != null && !event.getEntityPlayer().field_70170_p.field_72995_K && BaublesApi.isBaubleEquipped((EntityPlayer)event.getEntityPlayer(), (Item)ItemsTC.bandCuriosity) >= 0 && event.getOrb().func_70526_d() > 1) {
            int exp = event.getOrb().field_70530_e / 2;
            EntityXPOrb orb = event.getOrb();
            orb.field_70530_e -= exp;
            PlayerEventsMixin.addTheories(event.getEntityPlayer(), exp);
        }
        ci.cancel();
    }

    @Inject(method={"handleRunicArmor"}, at={@At(value="FIELD", target="Lthaumcraft/common/lib/events/PlayerEvents;runicInfo:Ljava/util/HashMap;", ordinal=3)}, cancellable=true, remap=false)
    private static void tryRechargeFromInventory(EntityPlayer player, CallbackInfo ci) {
        ItemStack chosen;
        ArrayList<ItemStack> equip;
        long time = System.currentTimeMillis();
        int charge = (int)player.func_110139_bj();
        if (charge < runicInfo.get(player.func_145782_y()) && nextCycle.get(player.func_145782_y()) < time && (equip = PlayerEventsMixin.getRechargables(player)).size() > 0 && RechargeHelper.consumeCharge((ItemStack)(chosen = equip.get(player.field_70170_p.field_73012_v.nextInt(equip.size()))), (EntityLivingBase)player, (int)5)) {
            double boost = TTConfig.runShield.allow ? TTConfig.runShield.invBoost : 1.0;
            PlayerEventsMixin.recoverShield(player, charge, time, (int)((double)ModConfig.CONFIG_MISC.shieldRecharge / boost));
            ci.cancel();
        }
    }

    private static void recoverShield(EntityPlayer player, int charge, long time, int cd) {
        nextCycle.put(player.func_145782_y(), time + (long)cd);
        player.func_110149_m((float)(charge + 1));
        lastCharge.put(player.func_145782_y(), charge + 1);
    }

    private static ArrayList<ItemStack> getRechargables(EntityPlayer player) {
        ArrayList<ItemStack> equip = new ArrayList<ItemStack>();
        for (ItemStack is : player.func_184193_aE()) {
            if (!(is.func_77973_b() instanceof IRechargable)) continue;
            equip.add(is);
        }
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (int i = 0; i < baubles.func_70302_i_(); ++i) {
            ItemStack is = baubles.func_70301_a(i);
            if (!(is.func_77973_b() instanceof IRechargable)) continue;
            equip.add(is);
        }
        ItemStack held = player.func_184614_ca();
        if (held.func_77973_b() instanceof IRechargable) {
            equip.add(held);
        }
        if ((held = player.func_184592_cb()).func_77973_b() instanceof IRechargable) {
            equip.add(held);
        }
        return equip;
    }

    private static void addTheories(EntityPlayer player, double d) {
        double r = player.func_70681_au().nextFloat();
        if (r < 0.05 * d * XP_MULT) {
            String[] s = ResearchCategories.researchCategories.keySet().toArray(new String[0]);
            String cat = s[player.func_70681_au().nextInt(s.length)];
            ThaumcraftApi.internalMethods.addKnowledge(player, IPlayerKnowledge.EnumKnowledgeType.THEORY, ResearchCategories.getResearchCategory((String)cat), THEORY_MULT);
        } else if (r < 0.2 * d * XP_MULT) {
            String[] s = ResearchCategories.researchCategories.keySet().toArray(new String[0]);
            String cat = s[player.func_70681_au().nextInt(s.length)];
            ThaumcraftApi.internalMethods.addKnowledge(player, IPlayerKnowledge.EnumKnowledgeType.OBSERVATION, ResearchCategories.getResearchCategory((String)cat), THEORY_MULT);
        }
    }
}

