/*
 * Decompiled with CFR 0.152.
 */
package griglog.thaumtweaks.mixins.events;

import griglog.thaumtweaks.TTConfig;
import griglog.thaumtweaks.events.EventHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;
import thaumcraft.common.lib.events.ToolEvents;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.lib.utils.Utils;

@Mixin(value={ToolEvents.class})
public class ToolEventsMixin {
    @Shadow(remap=false)
    static boolean blockDestructiveRecursion;
    @Shadow(remap=false)
    static HashMap<Integer, EnumFacing> lastFaceClicked;

    @Inject(method={"harvestBlockEvent"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void harvestBlockEvent(BlockEvent.HarvestDropsEvent event, CallbackInfo ci) {
        ItemStack heldItem;
        if (!event.getWorld().field_72995_K && event.getHarvester() != null && !(heldItem = event.getHarvester().func_184586_b(event.getHarvester().func_184600_cs())).func_190926_b()) {
            List list = EnumInfusionEnchantment.getInfusionEnchantments((ItemStack)heldItem);
            if (event.isSilkTouching() || ToolEventsMixin.isToolEffective(heldItem, event.getState()) || heldItem.func_77973_b() instanceof ItemTool && ((ItemTool)heldItem.func_77973_b()).func_150893_a(heldItem, event.getState()) > 1.0f) {
                if (list.contains(EnumInfusionEnchantment.REFINING)) {
                    ToolEventsMixin.doRefining(event, heldItem);
                }
                if (list.contains(EnumInfusionEnchantment.DESTRUCTIVE) && !blockDestructiveRecursion && !event.getHarvester().func_70093_af()) {
                    ToolEventsMixin.doDestructive(event, heldItem);
                }
                if (list.contains(EnumInfusionEnchantment.COLLECTOR) && !event.getHarvester().func_70093_af()) {
                    InventoryUtils.dropHarvestsAtPos((World)event.getWorld(), (BlockPos)event.getPos(), (List)event.getDrops(), (boolean)true, (int)10, (Entity)event.getHarvester());
                    event.getDrops().clear();
                }
                if (list.contains(EnumInfusionEnchantment.LAMPLIGHT) && !event.getHarvester().func_70093_af() && event.getHarvester() instanceof EntityPlayerMP) {
                    WorldServer mainThread = ((EntityPlayerMP)event.getHarvester()).func_71121_q();
                    EventHelper.GlimmRunnable r = new EventHelper.GlimmRunnable(event);
                    mainThread.func_152344_a((Runnable)r);
                }
            }
        }
        ToolEventsMixin.dropEarths(event);
        ci.cancel();
    }

    private static boolean isToolEffective(ItemStack stack, IBlockState state) {
        for (String toolClass : stack.func_77973_b().getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(toolClass, state)) continue;
            return true;
        }
        return false;
    }

    private static void dropEarths(BlockEvent.HarvestDropsEvent event) {
        Block block = event.getState().func_177230_c();
        double r = event.getWorld().field_73012_v.nextDouble();
        double mult = 1.0;
        int refining = 0;
        if (TTConfig.general.earths && event.getHarvester() != null && event.getHarvester().func_184600_cs() != null) {
            ItemStack heldItem = event.getHarvester().func_184586_b(event.getHarvester().func_184600_cs());
            int fort = EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (ItemStack)heldItem);
            mult = 1.0 / (double)(fort + 2) + (double)(fort + 1) / 2.0;
            refining = EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)heldItem, (EnumInfusionEnchantment)EnumInfusionEnchantment.REFINING);
        }
        if (!event.getWorld().field_72995_K && !event.isSilkTouching() && (block == Blocks.field_150482_ag && r < 0.05 * mult || block == Blocks.field_150412_bA && r < 0.075 * mult || block == Blocks.field_150369_x && r < 0.01 * mult || block == Blocks.field_150365_q && r < 0.001 * mult || block == Blocks.field_150439_ay && r < 0.01 * mult || block == Blocks.field_150450_ax && r < 0.01 * mult || block == Blocks.field_150449_bY && r < 0.01 * mult || block == BlocksTC.oreAmber && r < 0.05 * mult || block == BlocksTC.oreQuartz && r < 0.05 * mult)) {
            boolean bonusDrop = event.getWorld().field_73012_v.nextDouble() < (double)refining * 0.25;
            event.getDrops().add(new ItemStack(ItemsTC.nuggets, bonusDrop ? 2 : 1, 10));
        }
    }

    private static void doDestructive(BlockEvent.HarvestDropsEvent event, ItemStack heldItem) {
        blockDestructiveRecursion = true;
        EnumFacing face = lastFaceClicked.get(event.getHarvester().func_145782_y());
        if (face == null) {
            face = EnumFacing.func_190914_a((BlockPos)event.getPos(), (EntityLivingBase)event.getHarvester());
        }
        int aa = -1;
        while (true) {
            if (aa > 1) break;
            for (int bb = -1; bb <= 1; ++bb) {
                if (aa == 0 && bb == 0) continue;
                int xx = 0;
                int yy = 0;
                int zz = 0;
                if (face.ordinal() <= 1) {
                    xx = aa;
                    zz = bb;
                } else if (face.ordinal() <= 3) {
                    xx = aa;
                    yy = bb;
                } else {
                    zz = aa;
                    yy = bb;
                }
                IBlockState bl = event.getWorld().func_180495_p(event.getPos().func_177982_a(xx, yy, zz));
                if (!(bl.func_185887_b(event.getWorld(), event.getPos().func_177982_a(xx, yy, zz)) >= 0.0f) || !ForgeHooks.isToolEffective((IBlockAccess)event.getWorld(), (BlockPos)event.getPos().func_177982_a(xx, yy, zz), (ItemStack)heldItem) && (!(heldItem.func_77973_b() instanceof ItemTool) || !(((ItemTool)heldItem.func_77973_b()).func_150893_a(heldItem, bl) > 1.0f))) continue;
                if (event.getHarvester().func_70005_c_().equals("FakeThaumcraftBore")) {
                    ++event.getHarvester().field_71090_bL;
                } else {
                    heldItem.func_77972_a(1, (EntityLivingBase)event.getHarvester());
                }
                BlockUtils.harvestBlock((World)event.getWorld(), (EntityPlayer)event.getHarvester(), (BlockPos)event.getPos().func_177982_a(xx, yy, zz));
            }
            ++aa;
        }
        blockDestructiveRecursion = false;
    }

    private static void doRefining(BlockEvent.HarvestDropsEvent event, ItemStack heldItem) {
        int fortune = 1 + EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)heldItem, (EnumInfusionEnchantment)EnumInfusionEnchantment.REFINING);
        float chance = (float)fortune * 0.125f;
        boolean b = false;
        for (int i = 0; i < event.getDrops().size(); ++i) {
            ItemStack cluster;
            ItemStack is = (ItemStack)event.getDrops().get(i);
            if (is.func_77969_a(cluster = Utils.findSpecialMiningResult((ItemStack)is, (float)chance, (Random)event.getWorld().field_73012_v))) continue;
            event.getDrops().set(i, cluster);
            b = true;
        }
        if (b) {
            event.getWorld().func_184133_a(null, event.getPos(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.7f + event.getWorld().field_73012_v.nextFloat() * 0.2f);
        }
    }
}

