/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropSeedDropBase;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropHemp
extends CropSeedDropBase {
    public CropHemp() {
        super(new CropProperties(3, 2, 2, 0, 2, 0));
    }

    @Override
    public ItemStack getSeed(ICropTile tile) {
        return Ic2Items.hempSeeds.func_77946_l();
    }

    @Override
    public String getDiscoveredBy() {
        return "Speiger";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state < 6) {
            return this.getSprite("bc")[61 + state];
        }
        return this.getSprite("bc")[87];
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Leaves", "Ingredient", "Green"};
    }

    @Override
    public String getId() {
        return "Hemp";
    }

    @Override
    public int getMaxSize() {
        return 6;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return Ic2Items.hemp.func_77946_l();
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 6 && cropTile.getLightLevel() >= 7;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 6;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 6;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 4;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() >= 4) {
            return 100;
        }
        return super.getGrowthDuration(cropTile);
    }
}

