/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.high;

import com.google.common.math.DoubleMath;
import ic2.api.classic.item.IElectricTool;
import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorEnchanterExp;
import ic2.core.block.base.util.comparator.comparators.ComparatorEnchanterMode;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.EnergyUsageInfo;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.misc.IEnergyUser;
import ic2.core.block.machine.high.container.ContainerElectricEnchanter;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.EnchanterFilter;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileEntityElectricEnchanter
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
IHasGui,
INetworkClientTileEventListener,
IEnergyUser {
    static int[] input = new int[]{1, 10, 100, 1000};
    static int[] output = new int[]{10, 100, 1000};
    public BookInformation info = new BookInformation(this);
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit8)
    public int mode = 0;
    @NetworkField(index=8, compression=NetworkField.BitLevel.Bit16)
    public int storedExp;
    @NetworkField(index=9, compression=NetworkField.BitLevel.Bit16)
    public int progress;
    @NetworkField(index=10, compression=NetworkField.BitLevel.Bit8)
    public int enchantLevel;
    @NetworkField(index=11, compression=NetworkField.BitLevel.Bit16)
    public int neededExp;
    @NetworkField(index=12)
    public boolean isDefined = false;
    @NetworkField(index=13)
    public boolean started = false;
    public IFilter filter;

    public TileEntityElectricEnchanter() {
        super(7, 512);
        this.maxEnergy = 1000000;
        this.setFuelSlot(0);
        this.addGuiFields("started", "isDefined", "neededExp", "enchantLevel", "progress", "storedExp", "mode");
        this.addInfos(new EnergyUsageInfo(this), new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        this.filter = new EnchanterFilter(this);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerDefaultSlotAccess(AccessRule.Import, 1, 2, 3, 4, 5);
        handler.registerDefaultSlotAccess(AccessRule.Export, 6);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 0);
        handler.registerDefaultSlotsForSide(RotationList.UP, 2, 3, 4);
        handler.registerDefaultSlotsForSide(RotationList.HORIZONTAL, 1, 5);
        handler.registerInputFilter(CommonFilters.DischargeEU, 0);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 0);
        handler.registerInputFilter(CommonFilters.lapisFilter, new int[0]);
        handler.registerInputFilter(CommonFilters.bookEnchanting, 2, 3, 4);
        handler.registerInputFilter(this.filter, 5);
        handler.registerSlotType(SlotType.Discharge, 0);
        handler.registerSlotType(SlotType.Fuel, 1);
        handler.registerSlotType(SlotType.Book, 2, 3, 4);
        handler.registerSlotType(SlotType.Tools, 5);
        handler.registerSlotType(SlotType.Output, 6);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
        manager.addComparatorMode(new ComparatorEnchanterMode(this));
        manager.addComparatorMode(new ComparatorEnchanterExp(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74762_e("Mode");
        this.storedExp = nbt.func_74762_e("StoredExp");
        this.progress = nbt.func_74762_e("Progress");
        this.enchantLevel = nbt.func_74762_e("EnchLvl");
        this.neededExp = nbt.func_74762_e("Needed");
        this.isDefined = nbt.func_74767_n("defined");
        this.started = nbt.func_74767_n("start");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Mode", this.mode);
        nbt.func_74768_a("StoredExp", this.storedExp);
        nbt.func_74768_a("Progress", this.progress);
        nbt.func_74768_a("EnchLvl", this.enchantLevel);
        nbt.func_74768_a("Needed", this.neededExp);
        nbt.func_74757_a("defined", this.isDefined);
        nbt.func_74757_a("start", this.started);
        return nbt;
    }

    @Override
    public int getEnergyUsage() {
        return 500;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.electricEnchanter;
    }

    @Override
    public float getMaxProgress() {
        return this.mode == 0 ? 1000.0f : 100.0f;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    public float getRecipeProgress() {
        if (this.mode == 0) {
            float result = (float)this.progress / 1000.0f;
            if (result > 1.0f) {
                result = 1.0f;
            }
            return result;
        }
        float result = (float)this.progress / 100.0f;
        if (result > 1.0f) {
            result = 1.0f;
        }
        return result;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        if ((slot != 0 || slot == 6 && !stack.func_190926_b()) && this.isSimulating()) {
            this.started = false;
            this.progress = 0;
            this.isDefined = false;
            this.neededExp = 0;
            this.enchantLevel = 0;
            this.getNetwork().updateTileGuiField(this, "started");
            this.getNetwork().updateTileGuiField(this, "isDefined");
            this.getNetwork().updateTileGuiField(this, "neededExp");
            this.getNetwork().updateTileGuiField(this, "enchantLevel");
            this.getNetwork().updateTileGuiField(this, "progress");
        }
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        this.handleChargeSlot(this.maxEnergy);
        if (!((ItemStack)this.inventory.get(6)).func_190926_b() || ((ItemStack)this.inventory.get(5)).func_190926_b()) {
            this.setActive(false);
            if (this.isDefined) {
                this.isDefined = false;
                this.started = false;
                this.getNetwork().updateTileGuiField(this, "isDefined");
            }
            this.updateComparators();
            return;
        }
        if (this.mode == 0) {
            this.handleEnchanter();
        } else {
            this.handleAnvil();
        }
        this.updateComparators();
    }

    public void handleAnvil() {
        if (!this.isDefined && this.isExtrasValid(true) && this.isItemValidToEnchant((ItemStack)this.inventory.get(5))) {
            this.isDefined = true;
            this.calculateAnvilCost();
            this.getNetwork().updateTileGuiField(this, "isDefined");
        }
        if (!this.isDefined) {
            this.setActive(false);
            return;
        }
        if (this.neededExp <= 0) {
            this.setActive(false);
            return;
        }
        if (!this.started) {
            this.setActive(false);
            return;
        }
        if (this.energy >= 500) {
            if (this.energy >= 500) {
                this.setActive(true);
                ++this.progress;
                this.useEnergy(500);
                if (this.progress >= 100) {
                    this.anvilItem();
                    this.storedExp -= this.neededExp;
                    this.neededExp = 0;
                    this.isDefined = false;
                    this.started = false;
                    this.progress = 0;
                    this.getNetwork().updateTileGuiField(this, "neededExp");
                    this.getNetwork().updateTileGuiField(this, "storedExp");
                    this.getNetwork().updateTileGuiField(this, "isDefined");
                    this.getNetwork().updateTileGuiField(this, "started");
                }
                this.getNetwork().updateTileGuiField(this, "progress");
            } else {
                this.setActive(false);
            }
        }
    }

    public void anvilItem() {
        boolean flag = ((ItemStack)this.inventory.get(5)).func_77973_b() instanceof IElectricTool;
        EnumEnchantmentType type = flag ? ((IElectricTool)((ItemStack)this.inventory.get(5)).func_77973_b()).getType((ItemStack)this.inventory.get(5)) : null;
        HashMap<Enchantment, Integer> ench = new HashMap<Enchantment, Integer>(EnchantmentHelper.func_82781_a((ItemStack)((ItemStack)this.inventory.get(5))));
        for (EnchantmentData data : this.getBookEnchantments(3)) {
            if (!(flag && this.isValidEnchantment(type, data.field_76302_b, (ItemStack)this.inventory.get(5)) || !flag && data.field_76302_b.func_92089_a((ItemStack)this.inventory.get(5))) && (!data.field_76302_b.isAllowedOnBooks() || ((ItemStack)this.inventory.get(5)).func_77973_b() != Items.field_151122_aG)) continue;
            if (ench.containsKey(data.field_76302_b)) {
                int lvl = (Integer)ench.get(data.field_76302_b);
                if (lvl < data.field_76303_c) {
                    ench.put(data.field_76302_b, data.field_76303_c);
                    continue;
                }
                if (lvl != data.field_76303_c || data.field_76302_b.func_77325_b() <= lvl) continue;
                ench.put(data.field_76302_b, data.field_76303_c + 1);
                continue;
            }
            if (!this.isCombineable(ench.keySet(), data.field_76302_b)) continue;
            ench.put(data.field_76302_b, data.field_76303_c);
        }
        if (((ItemStack)this.inventory.get(5)).func_77973_b() == Items.field_151122_aG) {
            ItemStack item = new ItemStack(Items.field_151134_bR);
            EnchantmentHelper.func_82782_a(ench, (ItemStack)item);
            this.inventory.set(6, (Object)item);
            ((ItemStack)this.inventory.get(5)).func_190918_g(1);
        } else {
            EnchantmentHelper.func_82782_a(ench, (ItemStack)((ItemStack)this.inventory.get(5)));
            ((ItemStack)this.inventory.get(5)).func_82841_c(((ItemStack)this.inventory.get(5)).func_82838_A() + this.field_145850_b.field_73012_v.nextInt(1 + ench.size()));
            this.inventory.set(6, this.inventory.get(5));
            this.inventory.set(5, (Object)ItemStack.field_190927_a);
        }
        for (int i = 2; i < 5; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i);
            if (item.func_190926_b()) continue;
            item.func_190918_g(1);
        }
    }

    public boolean isCombineable(Set<Enchantment> set, Enchantment ench) {
        for (Enchantment entry : set) {
            if (entry == ench || entry.func_191560_c(ench)) continue;
            return false;
        }
        return true;
    }

    public void calculateAnvilCost() {
        this.enchantLevel = 0;
        this.neededExp = this.getAnvilCost() * 10;
        this.getNetwork().updateTileGuiField(this, "enchantLevel");
        this.getNetwork().updateTileGuiField(this, "neededExp");
    }

    public int getAnvilCost() {
        int cost = this.getEnchantmentCount((ItemStack)this.inventory.get(5));
        int extra = 0;
        for (int i = 2; i < 5; ++i) {
            extra += this.getEnchantmentCount((ItemStack)this.inventory.get(i));
        }
        if (extra <= 0) {
            return 0;
        }
        return cost + extra;
    }

    public int getEnchantmentCount(ItemStack item) {
        if (item.func_77973_b() == Items.field_151134_bR) {
            return ItemEnchantedBook.func_92110_g((ItemStack)item).func_74745_c() + item.func_82838_A();
        }
        return (!item.func_77942_o() ? 0 : item.func_77986_q().func_74745_c()) + item.func_82838_A();
    }

    public void handleEnchanter() {
        if (!this.isDefined && this.isExtrasValid(false) && this.isItemValidToEnchant((ItemStack)this.inventory.get(5))) {
            this.isDefined = true;
            this.caclulateEnchantmentCost();
            this.getNetwork().updateTileGuiField(this, "isDefined");
        }
        if (!this.isDefined) {
            this.setActive(false);
            return;
        }
        if (!this.started && this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.caclulateEnchantmentCost();
        }
        if (this.enchantLevel <= 0) {
            this.setActive(false);
            return;
        }
        if (!this.started) {
            this.setActive(false);
            return;
        }
        if (this.isItemValidToEnchant((ItemStack)this.inventory.get(5)) && this.isExtrasValid(false)) {
            if (this.energy >= 500) {
                this.setActive(true);
                ++this.progress;
                this.useEnergy(500);
                if (this.progress >= 1000) {
                    this.enchantItem();
                    this.storedExp -= this.neededExp;
                    this.neededExp = 0;
                    this.isDefined = false;
                    this.started = false;
                    this.progress = 0;
                    this.getNetwork().updateTileGuiField(this, "neededExp");
                    this.getNetwork().updateTileGuiField(this, "storedExp");
                    this.getNetwork().updateTileGuiField(this, "isDefined");
                    this.getNetwork().updateTileGuiField(this, "started");
                }
                this.getNetwork().updateTileGuiField(this, "progress");
            } else {
                this.setActive(false);
            }
        } else {
            this.progress = 0;
            this.started = false;
            this.setActive(false);
            this.getNetwork().updateTileGuiField(this, "neededExp");
            this.getNetwork().updateTileGuiField(this, "progress");
        }
    }

    public void enchantItem() {
        int count = 0;
        for (int i = 2; i < 5; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i);
            if (item.func_77973_b() != Items.field_151122_aG && item.func_77973_b() != Items.field_151134_bR) continue;
            ++count;
        }
        HashMap<Enchantment, Integer> enchs = new HashMap<Enchantment, Integer>();
        List<EnchantmentData> data = this.getPossibleEnchantments(count);
        for (EnchantmentData ench : data) {
            int level;
            if (enchs.containsKey(ench.field_76302_b) && (level = ((Integer)enchs.get(ench.field_76302_b)).intValue()) >= ench.field_76303_c) continue;
            enchs.put(ench.field_76302_b, ench.field_76303_c);
        }
        if (((ItemStack)this.inventory.get(5)).func_77973_b() == Items.field_151122_aG) {
            ItemStack item = new ItemStack(Items.field_151134_bR);
            EnchantmentHelper.func_82782_a(enchs, (ItemStack)item);
            this.inventory.set(6, (Object)item);
            ((ItemStack)this.inventory.get(5)).func_190918_g(1);
        } else {
            EnchantmentHelper.func_82782_a(enchs, (ItemStack)((ItemStack)this.inventory.get(5)));
            this.inventory.set(6, this.inventory.get(5));
            this.inventory.set(5, (Object)ItemStack.field_190927_a);
        }
        int used = DoubleMath.roundToInt((double)((double)this.enchantLevel / 10.0), (RoundingMode)RoundingMode.CEILING);
        ((ItemStack)this.inventory.get(1)).func_190918_g(used);
        for (int i = 2; i < 5; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i);
            if (item.func_190926_b()) continue;
            item.func_190918_g(1);
        }
    }

    public List<EnchantmentData> getPossibleEnchantments(int lvl) {
        float f;
        LinkedHashMap<Enchantment, EnchantmentData> data = new LinkedHashMap<Enchantment, EnchantmentData>();
        int ability = ((ItemStack)this.inventory.get(5)).func_77973_b().getItemEnchantability((ItemStack)this.inventory.get(5));
        ability /= 2;
        int combo = (ability = 1 + this.field_145850_b.field_73012_v.nextInt((ability >> 1) + 1) + this.field_145850_b.field_73012_v.nextInt((ability >> 1) + 1)) + this.enchantLevel;
        int needed = (int)((float)combo * (1.0f + (f = (this.field_145850_b.field_73012_v.nextFloat() + this.field_145850_b.field_73012_v.nextFloat() - 1.0f) * 0.15f)) + 0.5f);
        if (needed < 1) {
            needed = 1;
        }
        boolean book = ((ItemStack)this.inventory.get(5)).func_77973_b() == Items.field_151122_aG;
        boolean flag = ((ItemStack)this.inventory.get(5)).func_77973_b() instanceof IElectricTool;
        EnumEnchantmentType type = flag ? ((IElectricTool)((ItemStack)this.inventory.get(5)).func_77973_b()).getType((ItemStack)this.inventory.get(5)) : null;
        for (Enchantment ench : Enchantment.field_185264_b) {
            if (!book && ench.func_190936_d() || !(flag && this.isValidEnchantment(type, ench, (ItemStack)this.inventory.get(5)) || !flag && ench.canApplyAtEnchantingTable((ItemStack)this.inventory.get(5))) && (!ench.isAllowedOnBooks() || ((ItemStack)this.inventory.get(5)).func_77973_b() != Items.field_151122_aG)) continue;
            for (int i = ench.func_77319_d(); i <= ench.func_77325_b(); ++i) {
                if (needed < ench.func_77321_a(i) || needed > ench.func_77317_b(i)) continue;
                data.put(ench, new EnchantmentData(ench, i));
            }
        }
        ArrayList list = new ArrayList(data.values());
        Collections.shuffle(list);
        ArrayList<EnchantmentData> results = new ArrayList<EnchantmentData>(data.size());
        List<EnchantmentData> books = this.getBookEnchantments(lvl);
        for (EnchantmentData entry : list) {
            if (!this.isCombineable(entry, results) || !this.isCombineable(entry, books)) continue;
            results.add(entry);
        }
        Collections.shuffle(results);
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        ArrayList<EnchantmentData> dataList = new ArrayList<EnchantmentData>(results.subList(0, Math.min(lvl, results.size())));
        for (EnchantmentData entry : dataList) {
            map.put(entry.field_76302_b, entry.field_76303_c);
        }
        for (EnchantmentData entry : books) {
            if (!(flag && this.isValidEnchantment(type, entry.field_76302_b, (ItemStack)this.inventory.get(5)) || !flag && entry.field_76302_b.func_92089_a((ItemStack)this.inventory.get(5))) && (!entry.field_76302_b.isAllowedOnBooks() || ((ItemStack)this.inventory.get(5)).func_77973_b() != Items.field_151122_aG) || !this.isCombineable(entry, dataList)) continue;
            if (map.containsKey(entry.field_76302_b)) {
                int oldLvl = (Integer)map.get(entry.field_76302_b);
                if (oldLvl < entry.field_76303_c) {
                    map.put(entry.field_76302_b, entry.field_76303_c);
                    continue;
                }
                if (oldLvl != entry.field_76303_c || entry.field_76302_b.func_77325_b() <= oldLvl) continue;
                map.put(entry.field_76302_b, entry.field_76303_c + 1);
                continue;
            }
            results.add(entry);
        }
        ArrayList<EnchantmentData> endList = new ArrayList<EnchantmentData>();
        for (Map.Entry entry : map.entrySet()) {
            endList.add(new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        return endList;
    }

    public List<EnchantmentData> getBookEnchantments(int lvl) {
        int max = 0;
        ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>();
        for (int i = 2; i < 5 && max < lvl; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i);
            if (item.func_77973_b() != Items.field_151134_bR) continue;
            Map map = EnchantmentHelper.func_82781_a((ItemStack)item);
            for (Map.Entry entry : map.entrySet()) {
                list.add(new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            }
            ++max;
        }
        return list;
    }

    public boolean isCombineable(EnchantmentData ench, List<EnchantmentData> list) {
        for (EnchantmentData entry : list) {
            if (ench.field_76302_b == entry.field_76302_b || ench.field_76302_b.func_191560_c(entry.field_76302_b)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidEnchantment(EnumEnchantmentType type, Enchantment ench, ItemStack item) {
        IElectricTool tool;
        block9: {
            block8: {
                tool = (IElectricTool)item.func_77973_b();
                if (tool.isExcluded(item, ench)) {
                    return false;
                }
                if (type == EnumEnchantmentType.ALL) {
                    return true;
                }
                if (ench.field_77351_y == type) {
                    if (type == EnumEnchantmentType.BREAKABLE) {
                        return item.func_77984_f();
                    }
                    return true;
                }
                if (type == EnumEnchantmentType.ARMOR_FEET) break block8;
                if (type == EnumEnchantmentType.ARMOR_HEAD) break block8;
                if (type == EnumEnchantmentType.ARMOR_LEGS) break block8;
                if (type != EnumEnchantmentType.ARMOR_CHEST) break block9;
            }
            if (ench.field_77351_y == EnumEnchantmentType.ARMOR) {
                return true;
            }
        }
        return tool.isSpecialSupported(item, ench);
    }

    public void caclulateEnchantmentCost() {
        int neededLvl;
        int maxLvl = this.getBookCount();
        if (maxLvl < (neededLvl = this.getMaxLevel())) {
            neededLvl = maxLvl;
        }
        this.enchantLevel = neededLvl;
        int lvl = DoubleMath.roundToInt((double)((double)neededLvl / 10.0), (RoundingMode)RoundingMode.UP) - 1;
        this.neededExp = 7 + lvl * 2;
        this.getNetwork().updateTileGuiField(this, "enchantLevel");
        this.getNetwork().updateTileGuiField(this, "neededExp");
    }

    public boolean isExtrasValid(boolean anvil) {
        int count = 0;
        for (int i = 2; i < 5; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i);
            if (item.func_190926_b()) continue;
            if (item.func_77973_b() != Items.field_151122_aG && item.func_77973_b() != Items.field_151134_bR) {
                return false;
            }
            if (anvil && item.func_77973_b() != Items.field_151134_bR) {
                return false;
            }
            ++count;
        }
        return count > 0 && (anvil || ((ItemStack)this.inventory.get(1)).func_190916_E() > 0);
    }

    public boolean isItemValidToEnchant(ItemStack item) {
        return item.func_77973_b() == Items.field_151122_aG || item.func_77973_b().func_77616_k(item) || item.func_77973_b() instanceof IElectricTool;
    }

    public int getBookCount() {
        int amount = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.func_174877_v());
        BlockPos blockPos = this.func_174877_v();
        for (int y = 0; y < 2; ++y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    pos.func_181079_c(blockPos.func_177958_n() + x, blockPos.func_177956_o() + y, blockPos.func_177952_p() + z);
                    amount += (int)this.field_145850_b.func_180495_p((BlockPos)pos).func_177230_c().getEnchantPowerBonus(this.field_145850_b, (BlockPos)pos);
                }
            }
        }
        return Math.min(amount, 30);
    }

    public int getMaxLevel() {
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return 0;
        }
        int max = Math.min(3, ((ItemStack)this.inventory.get(1)).func_190916_E());
        if (max <= 0) {
            return 0;
        }
        return max * 10;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerElectricEnchanter(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event, int value) {
        if (event == 0 && this.isDefined && !this.started && this.storedExp >= this.neededExp) {
            this.started = true;
            this.getNetwork().updateTileGuiField(this, "started");
        }
        if (event == 1) {
            ++this.mode;
            if (this.mode > 1) {
                this.mode = 0;
            }
            this.isDefined = false;
            this.started = false;
            this.neededExp = 0;
            this.enchantLevel = 0;
            this.getNetwork().updateTileGuiField(this, "mode");
            this.getNetwork().updateTileGuiField(this, "started");
            this.getNetwork().updateTileGuiField(this, "isDefined");
            this.getNetwork().updateTileGuiField(this, "neededExp");
            this.getNetwork().updateTileGuiField(this, "enchantLevel");
        }
        if (event == 2) {
            if (this.started) {
                return;
            }
            if (value != 3) {
                int remove = output[value];
                if (remove > this.storedExp) {
                    remove = this.storedExp;
                }
                player.func_71023_q(remove);
                this.storedExp -= remove;
                this.getNetwork().updateTileGuiField(this, "storedExp");
            } else {
                player.func_71023_q(this.storedExp);
                this.storedExp = 0;
                this.getNetwork().updateTileGuiField(this, "storedExp");
            }
        }
        if (event == 3) {
            if (this.storedExp >= 10000) {
                return;
            }
            int add = Math.min(input[value], 10000 - this.storedExp);
            if (player.field_71075_bZ.field_75098_d) {
                this.storedExp += add;
                if (this.storedExp > 10000) {
                    this.storedExp = 10000;
                }
                this.getNetwork().updateTileGuiField(this, "storedExp");
                return;
            }
            int stored = this.getXP(player);
            if (add > stored) {
                add = stored;
            }
            this.storedExp += add;
            player.field_71067_cb = stored -= add;
            player.field_71068_ca = this.getLvlForXP(stored);
            player.field_71106_cc = (float)(stored - this.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
            player.func_192024_a(ItemStack.field_190927_a, 0);
            this.getNetwork().updateTileGuiField(this, "storedExp");
        }
    }

    public int getXP(EntityPlayer player) {
        return this.getXPForLvl(player.field_71068_ca) + DoubleMath.roundToInt((double)(player.field_71106_cc * (float)player.func_71050_bK()), (RoundingMode)RoundingMode.HALF_UP);
    }

    private int getXPForLvl(int level) {
        if (level < 0) {
            return Integer.MAX_VALUE;
        }
        if (level <= 15) {
            return level * level + 6 * level;
        }
        if (level <= 30) {
            return (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
        }
        return (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
    }

    private int getLvlForXP(int totalXP) {
        int result = 0;
        while (this.getXPForLvl(result) <= totalXP) {
            ++result;
        }
        return --result;
    }

    public static class BookInformation {
        public int tickCount;
        public float pageFlip;
        public float pageFlipPrev;
        public float flipT;
        public float flipA;
        public float bookSpread;
        public float bookSpreadPrev;
        public float bookRotation;
        public float bookRotationPrev;
        public float tRot;
        public long lastTick = -1L;
        TileEntityElectricEnchanter ench;

        public BookInformation(TileEntityElectricEnchanter tile) {
            this.ench = tile;
        }

        public void tick() {
            float f2;
            block12: {
                block10: {
                    block11: {
                        World world = this.ench.func_145831_w();
                        if (world.func_82737_E() < this.lastTick) {
                            return;
                        }
                        this.lastTick = world.func_82737_E();
                        BlockPos pos = this.ench.func_174877_v();
                        this.bookSpreadPrev = this.bookSpread;
                        this.bookRotationPrev = this.bookRotation;
                        EntityPlayer player = world.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 4.0, false);
                        if (player == null || !(Math.sqrt(player.func_174818_b(this.ench.func_174877_v())) <= 3.0)) break block10;
                        double d0 = player.field_70165_t - (double)((float)this.ench.field_174879_c.func_177958_n() + 0.5f);
                        double d1 = player.field_70161_v - (double)((float)this.ench.field_174879_c.func_177952_p() + 0.5f);
                        this.tRot = (float)MathHelper.func_181159_b((double)d1, (double)d0);
                        this.bookSpread += 0.1f;
                        if (this.bookSpread < 0.5f) break block11;
                        if (random.nextInt(40) != 0) break block12;
                    }
                    float f1 = this.flipT;
                    do {
                        this.flipT += (float)(random.nextInt(4) - random.nextInt(4));
                    } while (f1 == this.flipT);
                    break block12;
                }
                this.tRot += 0.02f;
                this.bookSpread -= 0.1f;
            }
            while (this.bookRotation >= (float)Math.PI) {
                this.bookRotation -= (float)Math.PI * 2;
            }
            while (this.bookRotation < (float)(-Math.PI)) {
                this.bookRotation += (float)Math.PI * 2;
            }
            while (this.tRot >= (float)Math.PI) {
                this.tRot -= (float)Math.PI * 2;
            }
            while (this.tRot < (float)(-Math.PI)) {
                this.tRot += (float)Math.PI * 2;
            }
            for (f2 = this.tRot - this.bookRotation; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
            }
            while (f2 < (float)(-Math.PI)) {
                f2 += (float)Math.PI * 2;
            }
            this.bookRotation += f2 * 0.4f;
            this.bookSpread = MathHelper.func_76131_a((float)this.bookSpread, (float)0.0f, (float)1.0f);
            ++this.tickCount;
            this.pageFlipPrev = this.pageFlip;
            float f = (this.flipT - this.pageFlip) * 0.4f;
            float f3 = 0.2f;
            f = MathHelper.func_76131_a((float)f, (float)(-f3), (float)f3);
            this.flipA += (f - this.flipA) * 0.9f;
            this.pageFlip += this.flipA;
        }
    }
}

