/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.machine.low.container.ContainerIndustrialWorktable;
import ic2.core.block.machine.low.logic.crafter.CraftList;
import ic2.core.block.machine.low.logic.crafter.CraftingRecipe;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.base.IInventoryNotify;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.inventory.transport.transporter.PriorityTransporter;
import ic2.core.inventory.transport.wrapper.ChachedInventory;
import ic2.core.item.tool.ItemMemoryStick;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.util.math.IntCounter;
import ic2.core.util.math.MathUtil;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityIndustrialWorktable
extends TileEntityMachine
implements IHasGui,
INetworkClientTileEventListener,
IInventoryNotify {
    public static final InventoryCrafting crafting = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }
    }, 3, 3);
    public PersonalInventory memorySlots = new PersonalInventory(2);
    public PersonalInventory craftingInventory = new PersonalInventory(10);
    @NetworkField(index=3)
    public CraftingRecipe currentRecipe = new CraftingRecipe();
    public CraftList recipeList = new CraftList();
    @NetworkField(index=4)
    public boolean restock = false;
    @NetworkField(index=5)
    public boolean recursive = false;
    @NetworkField(index=6, compression=NetworkField.BitLevel.Bit8)
    public boolean[] recipeSlots = MathUtil.flagsFromNumber(27, 511);
    @NetworkField(index=7)
    public boolean isCentered = false;
    private boolean isSnapShotting = false;
    private ChachedInventory snapShot = null;
    @NetworkField(index=8)
    private boolean hasCustom = false;
    private ChachedInventory customSnapshot = null;

    public TileEntityIndustrialWorktable() {
        super(27);
        this.addNetworkFields("isCentered");
        this.addGuiFields("currentRecipe", "restock", "recursive", "recipeLimit", "recipeSlots", "hasCustom");
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        int[] slots = MathUtil.fromTo(0, 27);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, slots);
        handler.registerDefaultSlotsForSide(RotationList.ALL, slots);
        handler.registerSlotType(SlotType.Storage, 0);
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.industrialWorktable;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerIndustrialWorktable(this, player.field_71071_by);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onNetworkUpdate(String field) {
        Container cont;
        super.onNetworkUpdate(field);
        if (field.equals("isCentered") && (cont = Minecraft.func_71410_x().field_71439_g.field_71070_bA) instanceof ContainerIndustrialWorktable && ((TileEntityIndustrialWorktable)((ContainerIndustrialWorktable)cont).getGuiHolder()).func_174877_v().equals((Object)this.func_174877_v())) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.recursive = nbt.func_74767_n("Recursive");
        this.restock = nbt.func_74767_n("Restock");
        this.craftingInventory.readFromNBT(nbt.func_74775_l("CraftingDisplay"));
        this.currentRecipe.readFromNBT(nbt.func_74775_l("currentRecipe"));
        this.recipeList.readFromNBT(nbt.func_74775_l("recipeList"));
        this.memorySlots.readFromNBT(nbt.func_74775_l("MemorySlots"));
        if (nbt.func_74764_b("customSnapShot")) {
            this.customSnapshot = new ChachedInventory(this, nbt.func_74775_l("customSnapShot"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.craftingInventory.writeToNBT(this.getTag(nbt, "CraftingDisplay"));
        this.currentRecipe.writeToNBT(this.getTag(nbt, "currentRecipe"));
        this.recipeList.writeToNBT(this.getTag(nbt, "recipeList"));
        this.memorySlots.writeToNBT(this.getTag(nbt, "MemorySlots"));
        nbt.func_74757_a("Recursive", this.recursive);
        nbt.func_74757_a("Restock", this.restock);
        if (this.customSnapshot != null) {
            nbt.func_74782_a("customSnapShot", (NBTBase)this.customSnapshot.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.validateSlots();
        this.recipeList.validateRecipes(this.func_145831_w(), this.recipeSlots);
        if (this.currentRecipe.validate(this.func_145831_w())) {
            this.craftingInventory.setStackInSlot(9, this.currentRecipe.getFakeOutput(this.func_145831_w()));
        } else {
            this.currentRecipe.clear();
            this.craftingInventory.setStackInSlot(9, ItemStack.field_190927_a);
        }
    }

    public void validateSlots() {
        for (int i = 0; i < 2; ++i) {
            ItemStack stack = this.memorySlots.getStackInSlot(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemMemoryStick)) continue;
            for (int x = 0; x < 9; ++x) {
                this.recipeSlots[x + (1 + i) * 9] = true;
            }
        }
        this.getNetwork().updateTileGuiField(this, "recipeSlots");
    }

    public boolean saveRecipe(int slot) {
        if (!this.recipeSlots[slot]) {
            return false;
        }
        CraftingRecipe copy = this.currentRecipe.copy();
        if (copy.validate(this.func_145831_w())) {
            this.recipeList.saveRecipe(slot, copy);
            if (slot >= 9) {
                this.saveToBattery((slot - 9) / 9, slot % 9, copy);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onSlotChanged(IHasInventory inv, int slot) {
        if (inv != this.memorySlots || this.isRendering()) {
            return;
        }
        ItemStack stack = inv.getStackInSlot(slot);
        if (stack.func_190926_b()) {
            for (int i = 0; i < 9; ++i) {
                int index = 9 + slot * 9 + i;
                this.recipeList.deleteRecipe(index);
                this.recipeSlots[index] = false;
                this.recipeList.setStackInSlot(index, ItemStack.field_190927_a);
            }
            this.getNetwork().updateTileGuiField(this, "recipeSlots");
        } else if (stack.func_77973_b() instanceof ItemMemoryStick) {
            for (int i = 0; i < 9; ++i) {
                int index = 9 + slot * 9 + i;
                this.recipeSlots[index] = true;
                CraftingRecipe recipe = ItemMemoryStick.loadRecipe(stack, i);
                if (recipe != null && recipe.validate(this.func_145831_w())) {
                    this.recipeList.saveRecipe(index, recipe);
                    continue;
                }
                this.recipeList.deleteRecipe(index);
            }
        }
        this.getNetwork().updateTileGuiField(this, "recipeSlots");
    }

    public void saveToBattery(int batterySlot, int slotIndex, CraftingRecipe recipe) {
        ItemStack stack = this.memorySlots.getStackInSlot(batterySlot);
        if (!(stack.func_77973_b() instanceof ItemMemoryStick)) {
            return;
        }
        ItemMemoryStick.saveRecipe(stack, slotIndex, recipe);
    }

    public void deleteRecipe(int slot) {
        this.recipeList.deleteRecipe(slot);
        if (slot >= 9) {
            ItemStack stack = this.memorySlots.getStackInSlot((slot - 9) / 9);
            if (!(stack.func_77973_b() instanceof ItemMemoryStick)) {
                return;
            }
            ItemMemoryStick.deleteRecipe(stack, slot % 9);
        }
    }

    public void setRecipe(int index) {
        this.setRecipe(this.recipeList.getCopy(index));
    }

    public void setRecipe(CraftingRecipe copy) {
        if (copy == null || !copy.validate(this.func_145831_w())) {
            this.currentRecipe.clear();
            this.craftingInventory.clear();
        } else {
            this.currentRecipe = copy;
            this.craftingInventory.clear();
            this.currentRecipe.applyTo(this.craftingInventory, this.func_145831_w());
        }
        this.getNetwork().updateTileGuiField(this, "currentRecipe");
    }

    public void createSnapshot() {
        if (this.isSnapShotting) {
            throw new RuntimeException("Is already doing a Snapshot");
        }
        this.isSnapShotting = true;
        this.snapShot = this.customSnapshot != null ? this.customSnapshot.copy() : new ChachedInventory(this);
    }

    public boolean hasCustomSnapshot() {
        return this.hasCustom;
    }

    public void setSnapShot(ChachedInventory inv) {
        if (this.isSnapShotting) {
            throw new RuntimeException("Is already doing a Snapshot");
        }
        this.isSnapShotting = true;
        this.snapShot = inv;
    }

    public ChachedInventory takeSnapShot() {
        if (this.isSnapShotting) {
            this.isSnapShotting = false;
            ChachedInventory inv = this.snapShot;
            this.snapShot = null;
            return inv;
        }
        return null;
    }

    public void destroySnapShot() {
        if (!this.isSnapShotting) {
            return;
        }
        this.isSnapShotting = false;
        this.snapShot = null;
    }

    public void releaseSnapShot() {
        if (!this.isSnapShotting) {
            return;
        }
        this.snapShot.applyChanges();
        this.snapShot = null;
        this.isSnapShotting = false;
    }

    public void manuallyRefill(EntityPlayer player) {
        if (!this.hasCustom || this.customSnapshot == null) {
            IC2.platform.messagePlayer(player, Ic2GuiLang.manualRefilFail);
            return;
        }
        ChachedInventory copy = new ChachedInventory(this);
        Map<Integer, ItemStack[]> data = this.customSnapshot.getManualDifference();
        ArrayList<ItemStack> toLaterAdd = new ArrayList<ItemStack>();
        LinkedHashMap<Integer, Object> toRefill = new LinkedHashMap<Integer, Object>();
        for (Map.Entry<Integer, ItemStack[]> entry : data.entrySet()) {
            ItemStack expected = entry.getValue()[1];
            ItemStack itemStack = entry.getValue()[0];
            int slot = entry.getKey();
            if (!expected.func_190926_b() && !itemStack.func_190926_b()) {
                if (expected.func_77984_f() ? !ItemStack.func_185132_d((ItemStack)expected, (ItemStack)itemStack) : !ItemStack.func_179545_c((ItemStack)expected, (ItemStack)itemStack)) {
                    toLaterAdd.add(itemStack);
                    copy.setStackInSlot(slot, ItemStack.field_190927_a);
                    toRefill.put(slot, expected);
                    continue;
                }
                if (expected.func_77976_d() <= itemStack.func_190916_E()) continue;
                toRefill.put(slot, StackUtil.copyWithSize(expected, expected.func_77976_d() - itemStack.func_190916_E()));
                continue;
            }
            if (expected.func_190926_b() || !itemStack.func_190926_b()) continue;
            toRefill.put(slot, StackUtil.copyWithSize(expected, expected.func_77976_d()));
        }
        List<Tuple<IItemTransporter, EnumFacing>> list = this.getTransporter();
        if (list.isEmpty()) {
            copy = null;
            IC2.platform.messagePlayer(player, Ic2GuiLang.manualRefilFailNoInv);
            return;
        }
        int moved = 0;
        block1: for (Map.Entry entry : toRefill.entrySet()) {
            ItemStack value = (ItemStack)entry.getValue();
            BasicItemFilter filter = new BasicItemFilter(value.func_77984_f() ? StackUtil.copyWithWildCard(value) : value.func_77946_l());
            for (Tuple<IItemTransporter, EnumFacing> transporter : list) {
                ItemStack removed = ((IItemTransporter)transporter.func_76341_a()).removeItem(filter, (EnumFacing)transporter.func_76340_b(), value.func_190916_E(), true);
                if (removed.func_190926_b()) continue;
                moved += removed.func_190916_E();
                value.func_190918_g(removed.func_190916_E());
                ItemStack stored = this.getStackInSlot((Integer)entry.getKey());
                if (!stored.func_190926_b()) {
                    stored.func_190917_f(removed.func_190916_E());
                    copy.setStackInSlot((Integer)entry.getKey(), stored);
                } else {
                    copy.setStackInSlot((Integer)entry.getKey(), removed.func_77946_l());
                }
                if (!value.func_190926_b()) continue;
                continue block1;
            }
        }
        IItemTransporter transporter = TransporterManager.manager.getTransporter(copy, true);
        for (ItemStack stack : toLaterAdd) {
            ItemStack added = transporter.addItem(stack, null, true);
            stack.func_190918_g(added.func_190916_E());
            if (stack.func_190916_E() <= 0 || player.field_71071_by.func_70441_a(stack)) continue;
            player.func_71019_a(stack, true);
        }
        copy.applyChanges();
        if (moved > 0) {
            IC2.platform.messagePlayer(player, Ic2GuiLang.manualRefilSuccess);
        } else {
            IC2.platform.messagePlayer(player, Ic2GuiLang.manualRefilFailNoItems);
        }
    }

    public void releaseSnapshot(EntityPlayer player) {
        if (!this.isSnapShotting) {
            return;
        }
        if (!this.restock) {
            this.destroySnapShot();
            return;
        }
        this.isSnapShotting = false;
        Map<Integer, ItemStack[]> changes = this.snapShot.getDifferences();
        this.snapShot = new ChachedInventory(this);
        ArrayList<ItemStack> toLaterAdd = new ArrayList<ItemStack>();
        LinkedHashMap<Integer, ItemStack> toRefill = new LinkedHashMap<Integer, ItemStack>();
        for (Map.Entry<Integer, ItemStack[]> entry : changes.entrySet()) {
            ItemStack itemStack = entry.getValue()[1];
            ItemStack stored = entry.getValue()[0];
            int slot = entry.getKey();
            if (!itemStack.func_190926_b() && !stored.func_190926_b()) {
                if (itemStack.func_77984_f() ? !ItemStack.func_185132_d((ItemStack)itemStack, (ItemStack)stored) : !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)stored)) {
                    toLaterAdd.add(stored);
                    this.snapShot.setStackInSlot(slot, ItemStack.field_190927_a);
                    toRefill.put(slot, itemStack);
                    continue;
                }
                if (itemStack.func_77976_d() <= stored.func_190916_E()) continue;
                toRefill.put(slot, StackUtil.copyWithSize(itemStack, itemStack.func_77976_d() - stored.func_190916_E()));
                continue;
            }
            if (itemStack.func_190926_b() || !stored.func_190926_b()) continue;
            toRefill.put(slot, StackUtil.copyWithSize(itemStack, itemStack.func_77976_d()));
        }
        List<Tuple<IItemTransporter, EnumFacing>> list = this.getTransporter();
        if (list.isEmpty()) {
            this.snapShot = null;
            return;
        }
        block1: for (Map.Entry entry : toRefill.entrySet()) {
            ItemStack value = (ItemStack)entry.getValue();
            BasicItemFilter filter = new BasicItemFilter(value.func_77984_f() ? StackUtil.copyWithWildCard(value) : value.func_77946_l());
            for (Tuple<IItemTransporter, EnumFacing> transporter : list) {
                ItemStack removed = ((IItemTransporter)transporter.func_76341_a()).removeItem(filter, (EnumFacing)transporter.func_76340_b(), value.func_190916_E(), true);
                if (removed.func_190926_b()) continue;
                value.func_190918_g(removed.func_190916_E());
                ItemStack stored = this.snapShot.getStackInSlot((Integer)entry.getKey());
                if (!stored.func_190926_b()) {
                    stored.func_190917_f(removed.func_190916_E());
                    this.snapShot.setStackInSlot((Integer)entry.getKey(), stored);
                } else {
                    this.snapShot.setStackInSlot((Integer)entry.getKey(), removed.func_77946_l());
                }
                if (!value.func_190926_b()) continue;
                continue block1;
            }
        }
        IItemTransporter iItemTransporter = TransporterManager.manager.getTransporter(this.snapShot, true);
        for (ItemStack stack : toLaterAdd) {
            ItemStack added = iItemTransporter.addItem(stack, null, true);
            stack.func_190918_g(added.func_190916_E());
            if (stack.func_190916_E() <= 0 || player.field_71071_by.func_70441_a(stack)) continue;
            player.func_71019_a(stack, true);
        }
        this.snapShot.applyChanges();
        this.snapShot = null;
    }

    public List<Tuple<IItemTransporter, EnumFacing>> getTransporter() {
        ArrayList<Tuple<IItemTransporter, EnumFacing>> list = new ArrayList<Tuple<IItemTransporter, EnumFacing>>();
        for (Direction dir : Direction.directions) {
            IItemTransporter transporter;
            TileEntity tile = dir.applyToTileEntity(this);
            if (tile == null || (transporter = TransporterManager.manager.getTransporter(tile, true)) == null) continue;
            list.add((Tuple<IItemTransporter, EnumFacing>)new Tuple((Object)transporter, (Object)dir.getInverse().toFacing()));
        }
        return list;
    }

    public int getTotalSize() {
        return this.craftingInventory.getSlotCount() + this.getSlotCount() + this.recipeList.getSlotCount() + this.memorySlots.getSlotCount();
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> list = super.getDrops();
        for (int i = 0; i < this.memorySlots.getSlotCount(); ++i) {
            ItemStack stack = this.memorySlots.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            list.add(stack);
        }
        return list;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event, int value) {
        if (event == 0) {
            ContainerIndustrialWorktable container = this.getContainer(player);
            if (container.isSaving) {
                container.isSaving = false;
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            } else if (player.field_71071_by.func_70445_o().func_190926_b()) {
                player.field_71071_by.func_70437_b(this.currentRecipe.getDisplayItem());
                container.isSaving = true;
            }
        } else if (event == 1) {
            this.craftingInventory.clear();
            this.currentRecipe.clear();
            player.field_71070_bA.func_75142_b();
        } else if (event == 2) {
            this.currentRecipe.changeValue(value);
            this.getNetwork().updateTileGuiField(this, "currentRecipe");
        } else if (event == 3) {
            if (value == 0) {
                this.restock = !this.restock;
                this.getNetwork().updateTileGuiField(this, "restock");
            } else if (value == 1) {
                this.recursive = !this.recursive;
                this.getNetwork().updateTileGuiField(this, "recursive");
            }
        } else if (event == 4) {
            this.isCentered = !this.isCentered;
            this.getNetwork().updateTileEntityField(this, "isCentered");
        } else if (event == 5) {
            this.hasCustom = !this.hasCustom;
            this.getNetwork().updateTileEntityField(this, "hasCustom");
            this.customSnapshot = this.hasCustom ? new ChachedInventory(this) : null;
        } else if (event == 6) {
            this.manuallyRefill(player);
        }
    }

    public ContainerIndustrialWorktable getContainer(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerIndustrialWorktable) {
            return (ContainerIndustrialWorktable)player.field_71070_bA;
        }
        return null;
    }

    public void generateRecipe() {
        for (int i = 0; i < 9; ++i) {
            crafting.func_70299_a(i, this.craftingInventory.getStackInSlot(i).func_77946_l());
        }
        IRecipe recipe = this.findMatchingRecipe(crafting);
        if (recipe != null) {
            this.currentRecipe.validate(recipe, this.craftingInventory);
            this.craftingInventory.setStackInSlot(9, this.currentRecipe.getOutput(crafting, this.func_145831_w()));
        } else {
            this.currentRecipe.clear();
            this.craftingInventory.setStackInSlot(9, ItemStack.field_190927_a);
        }
        crafting.func_174888_l();
    }

    public IRecipe findMatchingRecipe(InventoryCrafting entry) {
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!recipe.func_77569_a(entry, this.func_145831_w())) continue;
            return recipe;
        }
        return null;
    }

    public CraftingRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public boolean canCraft(EntityPlayer player) {
        if (this.currentRecipe != null) {
            boolean result = !this.tryCraftItems(player, this.currentRecipe, new ChachedInventory(this), crafting, false).func_190926_b();
            crafting.func_174888_l();
            return result;
        }
        return false;
    }

    public ItemStack craftItems(EntityPlayer player, InventoryCrafting craft) {
        if (this.currentRecipe != null) {
            ChachedInventory inv = new ChachedInventory(this);
            ItemStack result = this.tryCraftItems(player, this.currentRecipe, inv, craft, true);
            inv.applyChanges();
            return result;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack tryCraftItems(EntityPlayer player, CraftingRecipe recipe, ChachedInventory inv, InventoryCrafting table, boolean consume) {
        IntCounter craftsLeft = new IntCounter(512);
        PersonalInventory junkJard = new PersonalInventory(15);
        IItemTransporter finalTransporter = TransporterManager.manager.getTransporter(inv, true);
        PriorityTransporter transporter = new PriorityTransporter(finalTransporter, TransporterManager.manager.getTransporter(junkJard, true));
        PersonalInventory finalCraft = new PersonalInventory(9);
        ArrayList<IRecipe> toUnlock = new ArrayList<IRecipe>();
        toUnlock.add(recipe.getRecipe(this.func_145831_w()));
        for (Map.Entry<IFilter, int[]> entry : recipe.getFilters().entrySet()) {
            CraftingRecipe superRecipe;
            int[] value = entry.getValue();
            ItemStack consumed = transporter.removeItem(entry.getKey(), null, value[1], true);
            if (consumed.func_190926_b()) {
                if (!this.recursive) {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.requiredReqursive, recipe.getDisplayItemName(value[0]));
                    return ItemStack.field_190927_a;
                }
                superRecipe = this.getSuperRecipe(entry.getKey());
                if (superRecipe == null) {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.noRecipeFound, recipe.getDisplayItemName(value[0]));
                    return ItemStack.field_190927_a;
                }
                consumed = this.tryCraftItems(superRecipe, transporter, player, 6, craftsLeft, consume);
                if (consumed.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                toUnlock.add(superRecipe.getRecipe(this.func_145831_w()));
            }
            while (consumed.func_190916_E() < value[1]) {
                if (!this.recursive) {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.requiredReqursive, recipe.getDisplayItemName(value[0]));
                    return ItemStack.field_190927_a;
                }
                superRecipe = this.getSuperRecipe(entry.getKey());
                if (superRecipe == null) {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.noRecipeFound, recipe.getDisplayItemName(value[0]));
                    return ItemStack.field_190927_a;
                }
                ItemStack crafted = this.tryCraftItems(superRecipe, transporter, player, 6, craftsLeft, consume);
                if (crafted.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                consumed.func_190917_f(crafted.func_190916_E());
                toUnlock.add(superRecipe.getRecipe(this.func_145831_w()));
            }
            if ((consumed = consumed.func_77946_l()).func_190916_E() > value[1]) {
                transporter.addItem(consumed.func_77979_a(consumed.func_190916_E() - value[1]), null, true);
            }
            finalCraft.setStackInSlot(value[0], consumed);
        }
        table.func_174888_l();
        for (int i = 0; i < 9; ++i) {
            table.func_70299_a(i, finalCraft.getStackInSlot(i));
        }
        ItemStack stack = recipe.getOutput(table, this.func_145831_w());
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < junkJard.getSlotCount(); ++i) {
            ItemStack toAdd = junkJard.getStackInSlot(i);
            if (toAdd == null) continue;
            ItemStack added = finalTransporter.addItem(toAdd, null, true);
            toAdd.func_190918_g(added.func_190916_E());
            if (toAdd.func_190916_E() <= 0) continue;
            if (!consume) {
                IC2.platform.messagePlayer(player, Ic2GuiLang.toMuchOverflow);
                return ItemStack.field_190927_a;
            }
            if (player.field_71071_by.func_70441_a(toAdd)) continue;
            player.func_71019_a(toAdd, true);
        }
        if (consume) {
            ArrayList<IRecipe> toAdd = new ArrayList<IRecipe>();
            for (IRecipe entry : toUnlock) {
                if (entry.func_192399_d()) continue;
                toAdd.add(entry);
            }
            player.func_192021_a(toAdd);
        }
        return stack.func_77946_l();
    }

    public ItemStack tryCraftItems(CraftingRecipe recipe, IItemTransporter transporter, EntityPlayer player, int layer, IntCounter craftsLeft, boolean consume) {
        int i;
        craftsLeft.decrease();
        if (layer <= 0) {
            IC2.platform.messagePlayer(player, Ic2GuiLang.toDeepRecipe);
            return ItemStack.field_190927_a;
        }
        if (craftsLeft.getValue() < 0) {
            IC2.platform.messagePlayer(player, Ic2GuiLang.recipeToComplex, craftsLeft.getStartValue());
            return ItemStack.field_190927_a;
        }
        PersonalInventory craft = new PersonalInventory(9);
        for (Map.Entry<IFilter, int[]> entry : recipe.getFilters().entrySet()) {
            CraftingRecipe superRecipe;
            int[] value = entry.getValue();
            ItemStack consumed = transporter.removeItem(entry.getKey(), null, value[1], true);
            if (consumed.func_190926_b()) {
                superRecipe = this.getSuperRecipe(entry.getKey());
                if (superRecipe == null) {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.noSubRecipeFound, recipe.getDisplayItemName(value[0]), recipe.getDisplayName());
                    return ItemStack.field_190927_a;
                }
                consumed = this.tryCraftItems(superRecipe, transporter, player, layer - 1, craftsLeft, consume);
                if (consumed.func_190926_b()) {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.subCraftFailed, superRecipe.getDisplayName(), recipe.getDisplayName());
                    return ItemStack.field_190927_a;
                }
            }
            while (consumed.func_190916_E() < value[1]) {
                superRecipe = this.getSuperRecipe(entry.getKey());
                if (superRecipe == null) {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.noSubRecipeFound, recipe.getDisplayItemName(value[0]), recipe.getDisplayName());
                    return ItemStack.field_190927_a;
                }
                ItemStack crafted = this.tryCraftItems(superRecipe, transporter, player, layer - 1, craftsLeft, consume);
                if (crafted.func_190926_b()) {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.subCraftFailed, superRecipe.getDisplayName(), recipe.getDisplayName());
                    return ItemStack.field_190927_a;
                }
                consumed.func_190917_f(crafted.func_190916_E());
            }
            if ((consumed = consumed.func_77946_l()).func_190916_E() > value[1]) {
                transporter.addItem(consumed.func_77979_a(consumed.func_190916_E() - value[1]), null, true);
            }
            craft.setStackInSlot(value[0], consumed);
        }
        crafting.func_174888_l();
        for (int i2 = 0; i2 < 9; ++i2) {
            crafting.func_70299_a(i2, craft.getStackInSlot(i2));
        }
        ItemStack stack = recipe.getOutput(crafting, this.func_145831_w());
        if (stack.func_190926_b()) {
            crafting.func_174888_l();
            IC2.platform.messagePlayer(player, Ic2GuiLang.subCraftFailedUnknown, recipe.getDisplayName());
            return ItemStack.field_190927_a;
        }
        if (consume) {
            FMLCommonHandler.instance().firePlayerCraftingEvent(player, stack, (IInventory)crafting);
        }
        ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        NonNullList gotBack = NonNullList.func_191196_a();
        gotBack.addAll(recipe.getRemainingItems(crafting, this.func_145831_w()));
        ForgeHooks.setCraftingPlayer(null);
        for (i = 0; i < 9; ++i) {
            ItemStack subStack = crafting.func_70301_a(i);
            if (subStack.func_190926_b()) continue;
            subStack.func_190918_g(1);
            if (subStack.func_190926_b()) continue;
            gotBack.add((Object)subStack);
        }
        if (gotBack.size() > 0) {
            for (i = 0; i < gotBack.size(); ++i) {
                if (((ItemStack)gotBack.get(i)).func_190926_b()) continue;
                transporter.addItem((ItemStack)gotBack.get(i), null, true);
            }
        }
        crafting.func_174888_l();
        return stack;
    }

    public CraftingRecipe getSuperRecipe(IFilter filter) {
        return this.recipeList.getFromFilter(filter);
    }

    public void onJEIData(NBTTagCompound nbt) {
        this.craftingInventory.clear();
        NBTTagList list = nbt.func_150295_c("RecipeData", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("SlotID");
            this.craftingInventory.setStackInSlot(slot, new ItemStack(data));
        }
        this.generateRecipe();
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return facing != this.getFacing() && facing.func_176740_k().func_176722_c();
    }

    @Override
    public double getWrenchDropRate() {
        return 0.95;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }
}

