/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.misc.tile;

import com.google.common.base.Strings;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.IInfoTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.block.base.util.info.BarrelInfo;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.ChunkUpdater;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;

public class TileEntityBarrel
extends TileEntity
implements ITickable,
INetworkDataProvider,
INetworkUpdateListener,
IInfoTile {
    private boolean loaded = false;
    public int type = 0;
    public int boozeAmount = 0;
    public int age = 0;
    public boolean detailed = true;
    @NetworkField(index=0, compression=NetworkField.BitLevel.Bit8)
    public int treeTabSide = -1;
    public int hopsCount = 0;
    public int wheatCount = 0;
    public int solidRatio = 0;
    public int hopsRatio = 0;
    public int timeRatio = 0;
    @NetworkField(index=1)
    public int clientData = 0;
    public String customName = "";
    List<IInfoTile.InfoComponent> components = new ArrayList<IInfoTile.InfoComponent>();

    public TileEntityBarrel() {
        for (int i = 0; i < 8; ++i) {
            this.components.add(new BarrelInfo(this, i));
        }
    }

    @Override
    public List<IInfoTile.InfoComponent> getComponents() {
        return this.components;
    }

    public void updateMeta() {
        this.clientData = this.createMeta();
        IC2.network.get().updateTileEntityField(this, "clientData");
    }

    public int createMeta() {
        ByteShifter shifter = new ByteShifter();
        if (this.type == 1) {
            shifter.writeInteger(this.hopsRatio, 3);
            shifter.writeInteger(this.solidRatio, 3);
            shifter.writeInteger(this.timeRatio, 3);
        }
        if (this.type == 2) {
            int progress = this.age / this.timeNedForRum(this.boozeAmount) * 100;
            if (progress > 100) {
                progress = 100;
            }
            shifter.writeInteger(progress, 7);
        }
        if (this.type > 0) {
            shifter.writeInteger(this.boozeAmount, 6);
        }
        shifter.writeInteger(this.type, 2);
        return shifter.getEncodedData();
    }

    public void unfoldMeta(int meta) {
        ByteShifter shifter = new ByteShifter(meta);
        this.type = shifter.readInt(2);
        if (this.type > 0) {
            this.boozeAmount = shifter.readInt(6);
        }
        if (this.type == 1) {
            this.detailed = false;
            this.timeRatio = shifter.readInt(3);
            this.solidRatio = shifter.readInt(3);
            this.hopsRatio = shifter.readInt(3);
        }
        if (this.type == 2) {
            this.detailed = true;
            this.age = this.timeNedForRum(this.boozeAmount) * (shifter.readInt(7) / 100);
        }
    }

    public ItemStack getBarrelStack() {
        ItemStack stack = Ic2Items.barrel.func_77946_l();
        if (!Strings.isNullOrEmpty((String)this.customName)) {
            stack.func_151001_c(this.customName);
        }
        stack.func_77964_b(this.createMeta());
        return stack;
    }

    public void loadFromStack(ItemStack stack) {
        if (stack.func_82837_s()) {
            this.customName = stack.func_82833_r();
        }
        this.unfoldMeta(stack.func_77960_j());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = nbt.func_74762_e("type");
        this.boozeAmount = nbt.func_74762_e("waterCount");
        this.age = nbt.func_74762_e("age");
        this.treeTabSide = nbt.func_74762_e("treetapSide");
        this.detailed = nbt.func_74767_n("detailed");
        if (this.type == 1) {
            if (this.detailed) {
                this.hopsCount = nbt.func_74762_e("hopsCount");
                this.wheatCount = nbt.func_74762_e("wheatCount");
            }
            this.solidRatio = nbt.func_74762_e("solidRatio");
            this.hopsRatio = nbt.func_74762_e("hopsRatio");
            this.timeRatio = nbt.func_74762_e("timeRatio");
        }
        this.clientData = nbt.func_74762_e("ItemMeta");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("type", (byte)this.type);
        nbt.func_74774_a("waterCount", (byte)this.boozeAmount);
        nbt.func_74768_a("age", this.age);
        nbt.func_74774_a("treetapSide", (byte)this.treeTabSide);
        nbt.func_74757_a("detailed", this.detailed);
        nbt.func_74778_a("Name", this.customName);
        if (this.type == 1) {
            if (this.detailed) {
                nbt.func_74774_a("hopsCount", (byte)this.hopsCount);
                nbt.func_74774_a("wheatCount", (byte)this.wheatCount);
            }
            nbt.func_74774_a("solidRatio", (byte)this.solidRatio);
            nbt.func_74774_a("hopsRatio", (byte)this.hopsRatio);
            nbt.func_74774_a("timeRatio", (byte)this.timeRatio);
        }
        nbt.func_74768_a("ItemMeta", this.clientData);
        return nbt;
    }

    public boolean onRigthClick(EntityPlayer playerIn, EnumHand hand) {
        ItemStack currentItem = playerIn.func_184586_b(hand);
        if (currentItem.func_190926_b()) {
            return false;
        }
        if (currentItem.func_77973_b() == Items.field_151057_cb) {
            if (currentItem.func_82837_s()) {
                this.customName = currentItem.func_82833_r();
            }
            return true;
        }
        if (currentItem.func_77973_b() == Items.field_151131_as) {
            if (!this.detailed || this.boozeAmount >= 32 || this.type > 1) {
                return false;
            }
            this.type = 1;
            playerIn.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            ++this.boozeAmount;
            this.updateMeta();
            return true;
        }
        if (StackUtil.isStackEqual(currentItem, Ic2Items.waterCell)) {
            if (!this.detailed || this.type > 1) {
                return false;
            }
            this.type = 1;
            int wantgive = currentItem.func_190916_E();
            if (playerIn.func_70093_af()) {
                wantgive = 1;
            }
            if (wantgive > 32 - this.boozeAmount) {
                wantgive = 32 - this.boozeAmount;
            }
            if (wantgive <= 0) {
                return false;
            }
            this.boozeAmount += wantgive;
            this.updateMeta();
            currentItem.func_190918_g(wantgive);
            return true;
        }
        if (currentItem.func_77973_b() == Items.field_151015_O) {
            if (!this.detailed || this.type > 1) {
                return false;
            }
            this.type = 1;
            int wantgive = currentItem.func_190916_E();
            if (playerIn.func_70093_af()) {
                wantgive = 1;
            }
            if (wantgive > 64 - this.wheatCount) {
                wantgive = 64 - this.wheatCount;
            }
            if (wantgive <= 0) {
                return false;
            }
            this.wheatCount += wantgive;
            currentItem.func_190918_g(wantgive);
            this.alterComposition();
            return true;
        }
        if (StackUtil.isStackEqual(currentItem, Ic2Items.hops)) {
            if (!this.detailed || this.type > 1) {
                return false;
            }
            this.type = 1;
            int wantgive = currentItem.func_190916_E();
            if (playerIn.func_70093_af()) {
                wantgive = 1;
            }
            if (wantgive > 64 - this.hopsCount) {
                wantgive = 64 - this.hopsCount;
            }
            if (wantgive <= 0) {
                return false;
            }
            this.hopsCount += wantgive;
            currentItem.func_190918_g(wantgive);
            this.alterComposition();
            return true;
        }
        if (currentItem.func_77973_b() != Items.field_151120_aE) {
            return false;
        }
        if (this.age > 600 || this.type > 0 && this.type != 2) {
            return false;
        }
        this.type = 2;
        int wantgive = currentItem.func_190916_E();
        if (playerIn.func_70093_af()) {
            wantgive = 1;
        }
        if (wantgive > 32 - this.boozeAmount) {
            wantgive = 32 - this.boozeAmount;
        }
        if (wantgive <= 0) {
            return false;
        }
        this.boozeAmount += wantgive;
        this.clientData = this.createMeta();
        IC2.network.get().updateTileEntityField(this, "clientData");
        currentItem.func_190918_g(wantgive);
        return true;
    }

    public void func_73660_a() {
        if (!this.isEmpty() && this.treeTabSide < 0 && this.detailed) {
            this.age += 1000;
            if (this.type == 1 && this.timeRatio < 5) {
                int x = this.timeRatio;
                if (x == 4) {
                    x += 2;
                }
                if ((double)this.age >= 24000.0 * Math.pow(3.0, x)) {
                    this.age = 0;
                    ++this.timeRatio;
                    this.updateMeta();
                }
            }
        }
    }

    public void updateBlock() {
        IC2.network.get().updateTileEntityField(this, "treeTabSide");
        this.enforceUndetailed();
    }

    public boolean isEmpty() {
        return this.type == 0 || this.boozeAmount <= 0;
    }

    public void alterComposition() {
        if (this.timeRatio == 0) {
            this.age = 0;
        }
        if (this.timeRatio == 1) {
            if (this.field_145850_b.field_73012_v.nextBoolean()) {
                this.timeRatio = 0;
            } else if (this.field_145850_b.field_73012_v.nextBoolean()) {
                this.timeRatio = 5;
            }
        }
        if (this.timeRatio == 2 && this.field_145850_b.field_73012_v.nextBoolean()) {
            this.timeRatio = 5;
        }
        if (this.timeRatio > 2) {
            this.timeRatio = 5;
        }
        this.updateMeta();
    }

    public ItemStack drainAmount(int amount) {
        if (this.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (amount > this.boozeAmount) {
            amount = this.boozeAmount;
        }
        ItemStack stack = Ic2Items.mugBooze.func_77946_l();
        this.enforceUndetailed();
        this.applyData(stack);
        stack.func_190920_e(amount);
        if (this.type == 2) {
            int progress = this.age * 100 / this.timeNedForRum(this.boozeAmount);
            this.boozeAmount -= amount;
            this.age = progress / 100 * this.timeNedForRum(this.boozeAmount);
        } else {
            this.boozeAmount -= amount;
        }
        if (this.boozeAmount <= 0) {
            if (this.type == 1) {
                this.hopsCount = 0;
                this.wheatCount = 0;
                this.hopsRatio = 0;
                this.solidRatio = 0;
                this.timeRatio = 0;
            }
            this.type = 0;
            this.detailed = true;
            this.boozeAmount = 0;
        }
        this.updateMeta();
        return stack;
    }

    private void applyData(ItemStack stack) {
        ByteShifter shifter = new ByteShifter();
        if (!Strings.isNullOrEmpty((String)this.customName)) {
            StackUtil.addToolTip(stack, this.customName);
        }
        if (this.type == 1) {
            shifter.writeInteger(this.solidRatio, 3);
            shifter.writeInteger(this.hopsRatio, 3);
            shifter.writeInteger(this.timeRatio, 3);
        } else if (this.type == 2) {
            int progress = this.age * 100 / this.timeNedForRum(this.boozeAmount);
            if (progress > 100) {
                progress = 100;
            }
            shifter.writeInteger(progress, 7);
        }
        shifter.writeInteger(this.type, 2);
        stack.func_77964_b(shifter.getEncodedData());
    }

    public int timeNedForRum(int amount) {
        return (int)(1200.0 * (double)amount * Math.pow(0.95, amount - 1));
    }

    public void enforceUndetailed() {
        if (!this.detailed) {
            return;
        }
        this.detailed = false;
        if (this.type == 1) {
            float solid;
            float hops;
            float f = hops = this.wheatCount > 0 ? (float)(this.hopsCount / this.wheatCount) : 10.0f;
            if (this.hopsCount <= 0 && this.wheatCount <= 0) {
                hops = 0.0f;
            }
            float f2 = solid = this.boozeAmount > 0 ? (float)((this.hopsCount + this.wheatCount) / this.boozeAmount) : 10.0f;
            if (hops <= 0.25f) {
                this.hopsRatio = 0;
            }
            if (hops > 0.25f && hops <= 0.3333333f) {
                this.hopsRatio = 1;
            }
            if (hops > 0.3333333f && hops <= 0.5f) {
                this.hopsRatio = 2;
            }
            if (hops > 0.5f && hops < 2.0f) {
                this.hopsRatio = 3;
            }
            if (hops >= 2.0f && hops < 3.0f) {
                this.hopsRatio = 4;
            }
            if (hops >= 3.0f && hops < 4.0f) {
                this.hopsRatio = 5;
            }
            if (hops >= 4.0f && hops < 5.0f) {
                this.hopsRatio = 6;
            }
            if (hops >= 5.0f) {
                this.timeRatio = 5;
            }
            if (solid > 0.4166667f && solid <= 0.5f) {
                this.solidRatio = 1;
            }
            if (solid > 0.5f && solid < 1.0f) {
                this.solidRatio = 2;
            }
            if (solid == 1.0f) {
                this.solidRatio = 3;
            }
            if (solid > 1.0f && solid < 2.0f) {
                this.solidRatio = 4;
            }
            if (solid >= 2.0f && solid < 2.4f) {
                this.solidRatio = 5;
            }
            if (solid >= 2.4f && solid < 4.0f) {
                this.solidRatio = 6;
            }
            if (solid >= 4.0f) {
                this.timeRatio = 5;
            }
            this.updateMeta();
        }
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("treeTabSide")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
        if (field.equals("clientData")) {
            this.unfoldMeta(this.clientData);
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("treeTabSide");
        list.add("clientData");
        return list;
    }

    public int getStoredAmount() {
        return this.boozeAmount;
    }

    public void onLoaded() {
        if (this.field_145850_b.field_72995_K) {
            IC2.network.get(false).requestInitialData(this);
        } else {
            ChunkUpdater.addWatcher(this.func_145831_w(), this.func_174877_v());
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
        if (!this.field_145850_b.field_72995_K) {
            ChunkUpdater.removeWatcher(this.func_145831_w(), this.func_174877_v());
        }
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoad() {
        if (!this.loaded) {
            this.onLoaded();
        }
    }
}

