/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.entity;

import ic2.api.crops.CropCard;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.item.crop.ItemCropSeed;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class VillagerHandler {
    public static VillagerHandler INSTANCE = new VillagerHandler();
    public VillagerRegistry.VillagerProfession profession;
    public VillagerRegistry.VillagerCareer electricalEngineer;
    public VillagerRegistry.VillagerCareer nuclearEngineer;
    public VillagerRegistry.VillagerCareer demolishonMan;
    public VillagerRegistry.VillagerCareer cropFarmer;
    public VillagerRegistry.VillagerCareer evilGreg;
    public VillagerRegistry.VillagerCareer niceGreg;
    public boolean shouldLoadRecipes;

    public void init() {
        this.profession = new VillagerRegistry.VillagerProfession("ic2:industrialengineer", "ic2:textures/models/villager/industrialengineer.png", "ic2:textures/models/villager/industrialzombie.png");
        ForgeRegistries.VILLAGER_PROFESSIONS.register((IForgeRegistryEntry)this.profession);
        this.electricalEngineer = new VillagerRegistry.VillagerCareer(this.profession, "electricengineer");
        this.nuclearEngineer = new VillagerRegistry.VillagerCareer(this.profession, "nucleaengineer");
        this.demolishonMan = new VillagerRegistry.VillagerCareer(this.profession, "demolishonman");
        this.cropFarmer = new VillagerRegistry.VillagerCareer(this.profession, "cropcultivator");
        this.evilGreg = new VillagerRegistry.VillagerCareer(this.profession, "evilGreg");
        this.niceGreg = new VillagerRegistry.VillagerCareer(this.profession, "niceGreg");
        if (!IC2.config.getFlag("Villagers")) {
            this.shouldLoadRecipes = false;
            return;
        }
        this.shouldLoadRecipes = true;
        this.addTrade(this.electricalEngineer, 1, this.emeralds(1, 3, TradeType.MAIN), this.items(Ic2Items.electricCircuit, 1, 5, TradeType.RESULT));
        this.addTrade(this.electricalEngineer, 1, this.emeralds(5, 10, TradeType.MAIN), this.items(Ic2Items.machine, 2, 5, TradeType.RESULT));
        this.addTrade(this.electricalEngineer, 2, this.emeralds(5, TradeType.MAIN), this.items(Ic2Items.euReader, TradeType.RESULT));
        this.addTrade(this.electricalEngineer, 3, this.emeralds(3, 8, TradeType.MAIN), this.items(Ic2Items.electricWrench, TradeType.RESULT));
        this.addTrade(this.electricalEngineer, 5, this.emeralds(2, 5, TradeType.MAIN), this.items(Ic2Items.electricCircuit, 5, TradeType.SUB), this.items(Ic2Items.advancedCircuit, 3, TradeType.RESULT));
        this.addTrade(this.electricalEngineer, 8, this.emeralds(10, 20, TradeType.MAIN), this.items(Ic2Items.machineTool, TradeType.RESULT));
        ArrayList<EntityVillager.ITradeList> list = new ArrayList<EntityVillager.ITradeList>();
        for (IUranium iUranium : TileEntityUraniumEnricher.RECIPE_LIST) {
            if (!iUranium.isReEnrichedUran()) continue;
            int cost = Math.max(1, iUranium.getIngrientPoints() / 50);
            list.add(this.makeTrade(2, this.emeralds(cost, cost + 5, TradeType.MAIN), this.items(iUranium.getUraniumIngot(), 1, 5, TradeType.RESULT)));
        }
        this.addTrade(this.nuclearEngineer, 5, this.makeRandomList(3, list.toArray(new EntityVillager.ITradeList[list.size()])));
        this.addTrade(this.nuclearEngineer, 1, this.emeralds(1, 3, TradeType.MAIN), this.items(Ic2Items.reactorVent, TradeType.RESULT));
        this.addTrade(this.nuclearEngineer, 1, this.emeralds(1, 3, TradeType.MAIN), this.items(Ic2Items.reactorHeatSwitch, TradeType.RESULT));
        this.addTrade(this.nuclearEngineer, 1, this.emeralds(1, 3, TradeType.MAIN), this.items(Ic2Items.reactorCoolantCellSimple, TradeType.RESULT));
        this.addTrade(this.nuclearEngineer, 3, this.emeralds(20, 40, TradeType.MAIN), this.items(Ic2Items.reactorPlanner, TradeType.RESULT));
        this.addTrade(this.nuclearEngineer, 3, this.makeChance(0.3f, this.makeTrade(this.emeralds(10, 15, TradeType.MAIN), this.items(Ic2Items.nuclearReactor, TradeType.RESULT))));
        this.addTrade(this.nuclearEngineer, 3, this.makeChance(0.3f, this.makeTrade(this.emeralds(10, 15, TradeType.MAIN), this.items(Ic2Items.steamReactor, TradeType.RESULT))));
        this.addTrade(this.demolishonMan, 1, this.emeralds(1, TradeType.RESULT), this.items(new ItemStack(Blocks.field_150335_W), 2, 5, TradeType.MAIN));
        this.addTrade(this.demolishonMan, 1, this.emeralds(2, 5, TradeType.MAIN), this.items(Ic2Items.scrapMetal, 3, 5, TradeType.RESULT));
        this.addTrade(this.demolishonMan, 2, this.emeralds(2, TradeType.RESULT), this.items(Ic2Items.industrialTNT, 2, 5, TradeType.MAIN));
        this.addTrade(this.demolishonMan, 3, 2, this.emeralds(3, 8, TradeType.RESULT), this.items(Ic2Items.nuke, 1, 2, TradeType.MAIN));
        this.addTrade(this.demolishonMan, 6, this.emeralds(1, 2, TradeType.MAIN), this.items(new ItemStack(Items.field_151016_H), 8, 16, TradeType.RESULT));
        LinkedHashMap<Integer, ArrayList<EntityVillager.ITradeList>> components = new LinkedHashMap<Integer, ArrayList<EntityVillager.ITradeList>>();
        for (CropCard card : Ic2Crops.instance.getCrops()) {
            int tier = card.getProperties().getTier();
            if (tier <= 0) continue;
            ArrayList<EntityVillager.ITradeList> trades = (ArrayList<EntityVillager.ITradeList>)components.get(tier);
            if (trades == null) {
                trades = new ArrayList<EntityVillager.ITradeList>();
                components.put(tier, trades);
            }
            trades.add(this.makeTrade(3, this.emeralds(3, tier + 5, TradeType.MAIN), this.crop(0, 8, true, card, TradeType.RESULT)));
            trades.add(this.makeTrade(3, this.emeralds(5, tier + 8, TradeType.MAIN), this.crop(5, 12, false, card, TradeType.RESULT)));
        }
        for (Map.Entry entry : components.entrySet()) {
            List value = (List)entry.getValue();
            this.addTrade(this.cropFarmer, (int)((Integer)entry.getKey()), this.makeRandomList(3, value.toArray(new EntityVillager.ITradeList[value.size()])));
        }
        this.addTrade(this.cropFarmer, 1, this.emeralds(1, 4, TradeType.MAIN), this.items(Ic2Items.fertilizer, 4, 10, TradeType.RESULT));
        this.addTrade(this.cropFarmer, 2, this.emeralds(2, 8, TradeType.MAIN), this.items(Ic2Items.cropAnalyzer, TradeType.RESULT));
        this.addTrade(this.cropFarmer, 4, this.emeralds(10, 15, TradeType.MAIN), this.items(Ic2Items.cropLibary, TradeType.RESULT));
        this.addTrade(this.cropFarmer, 5, this.emeralds(5, 20, TradeType.MAIN), this.items(Ic2Items.overgrowthFertilizer, 10, TradeType.RESULT));
        this.addTrade(this.cropFarmer, 8, this.emeralds(40, 60, TradeType.MAIN), this.items(Ic2Items.reviveFertilizer, 1, TradeType.RESULT));
        if (!IC2.config.getFlag("BlameGreg")) {
            return;
        }
        this.addTrade(this.niceGreg, 1, 2, this.emeralds(1, TradeType.MAIN), this.items(Ic2Items.uuMatter, 64, TradeType.RESULT));
        ItemStack itemStack = Ic2Items.bigQuantumAccumulator.func_77946_l();
        ElectricItem.manager.charge(itemStack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        this.addTrade(this.niceGreg, 1, 20, this.emeralds(1, TradeType.MAIN), this.items(itemStack, 1, TradeType.RESULT));
        this.addTrade(this.niceGreg, 1, 10, this.emeralds(1, TradeType.MAIN), this.items(Ic2Items.battery, 16, TradeType.RESULT));
        NBTTagList nbtList = new NBTTagList();
        for (int i = 0; i < 54; ++i) {
            NBTTagCompound nbt = Ic2Items.uuMatter.func_77955_b(new NBTTagCompound());
            nbt.func_74768_a("Slot", i);
            nbt.func_74774_a("Count", (byte)64);
            nbtList.func_74742_a((NBTBase)nbt);
        }
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74782_a("Items", (NBTBase)nbtList);
        ItemStack result = Ic2Items.personalSafe.func_77946_l();
        result.func_77983_a("ItemsStored", (NBTBase)entry);
        this.addTrade(this.niceGreg, 2, 20, this.items(new ItemStack(Blocks.field_150380_bt), TradeType.MAIN), this.items(result, TradeType.RESULT));
        this.addTrade(this.evilGreg, 1, 64, this.emeralds(64, TradeType.MAIN), this.emeralds(64, TradeType.SUB), this.items(Ic2Items.uuMatter, TradeType.RESULT));
        this.addTrade(this.evilGreg, 1, 64, this.items(new ItemStack(Items.field_151045_i), 64, TradeType.MAIN), this.items(new ItemStack(Blocks.field_150346_d), TradeType.RESULT));
        this.addTrade(this.evilGreg, 2, 64, this.items(Ic2Items.uuMatter, TradeType.MAIN), this.emeralds(2, 10, TradeType.RESULT));
    }

    public void addTrade(VillagerRegistry.VillagerCareer career, int level, ITradeComponent ... components) {
        career.addTrade(level, new EntityVillager.ITradeList[]{new SimpleTradeList(components)});
    }

    public void addTrade(VillagerRegistry.VillagerCareer career, int level, int count, ITradeComponent ... components) {
        career.addTrade(level, new EntityVillager.ITradeList[]{new SimpleTradeList(count, components)});
    }

    public void addTrade(VillagerRegistry.VillagerCareer career, int level, EntityVillager.ITradeList trade) {
        career.addTrade(level, new EntityVillager.ITradeList[]{trade});
    }

    public EntityVillager.ITradeList makeTrade(ITradeComponent ... components) {
        return new SimpleTradeList(components);
    }

    public EntityVillager.ITradeList makeTrade(int count, ITradeComponent ... components) {
        return new SimpleTradeList(count, components);
    }

    public EntityVillager.ITradeList makeChance(float chance, EntityVillager.ITradeList trade) {
        return new RandomChanceTrade(chance, trade);
    }

    public EntityVillager.ITradeList makeRandomList(EntityVillager.ITradeList ... trades) {
        return this.makeRandomList(1, trades);
    }

    public EntityVillager.ITradeList makeRandomList(int attempts, EntityVillager.ITradeList ... trades) {
        return new RandomTradeList(attempts, trades);
    }

    public ITradeComponent crop(int min, int max, boolean scanned, CropCard card, TradeType type) {
        return new CropComponent(type, scanned, min, max, card);
    }

    public ITradeComponent emeralds(int min, int max, TradeType type) {
        return new RandomRangeComponent(type, new ItemStack(Items.field_151166_bC), min, max);
    }

    public ITradeComponent emeralds(int amount, TradeType type) {
        return new SimpleComponent(type, new ItemStack(Items.field_151166_bC, amount));
    }

    public ITradeComponent items(ItemStack stack, TradeType type) {
        return new SimpleComponent(type, stack);
    }

    public ITradeComponent items(ItemStack stack, int amount, TradeType type) {
        return new SimpleComponent(type, StackUtil.copyWithSize(stack, amount));
    }

    public ITradeComponent items(ItemStack stack, int min, int max, TradeType type) {
        return new RandomRangeComponent(type, stack, min, max);
    }

    public static enum TradeType {
        MAIN(0),
        SUB(1),
        RESULT(2);

        int type;

        private TradeType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static interface ITradeComponent {
        public TradeType getType();

        public ItemStack build(Random var1);
    }

    public static class CropComponent
    implements ITradeComponent {
        TradeType type;
        boolean scanned;
        int minStat;
        int maxStat;
        CropCard crop;

        public CropComponent(TradeType type, boolean scanned, int minStat, int maxStat, CropCard crop) {
            this.type = type;
            this.scanned = scanned;
            this.minStat = minStat;
            this.maxStat = maxStat;
            this.crop = crop;
        }

        @Override
        public TradeType getType() {
            return this.type;
        }

        @Override
        public ItemStack build(Random rand) {
            return ItemCropSeed.generateItemStack(this.crop, this.getStat(rand), this.getStat(rand), this.getStat(rand), this.scanned ? 4 : 0);
        }

        public int getStat(Random rand) {
            return this.minStat + rand.nextInt(this.maxStat - this.minStat + 1);
        }
    }

    public static class RandomRangeComponent
    implements ITradeComponent {
        TradeType type;
        ItemStack item;
        int min;
        int max;

        public RandomRangeComponent(TradeType type, ItemStack item, int min, int max) {
            this.type = type;
            this.item = item;
            this.min = Math.min(min, max);
            this.max = Math.max(min, max);
        }

        @Override
        public TradeType getType() {
            return this.type;
        }

        @Override
        public ItemStack build(Random rand) {
            return StackUtil.copyWithSize(this.item, this.min + rand.nextInt(this.max - this.min + 1));
        }
    }

    public static class SimpleComponent
    implements ITradeComponent {
        TradeType type;
        ItemStack stack;

        public SimpleComponent(TradeType type, ItemStack stack) {
            this.type = type;
            this.stack = stack;
        }

        @Override
        public TradeType getType() {
            return this.type;
        }

        @Override
        public ItemStack build(Random rand) {
            return this.stack.func_77946_l();
        }
    }

    public static class SimpleTradeList
    implements EntityVillager.ITradeList {
        ITradeComponent[] components = new ITradeComponent[3];
        int maxTradeUses;

        public SimpleTradeList(ITradeComponent ... componentList) {
            this(7, componentList);
        }

        public SimpleTradeList(int maxUses, ITradeComponent ... componentList) {
            this.maxTradeUses = maxUses;
            ITradeComponent[] iTradeComponentArray = componentList;
            int n = iTradeComponentArray.length;
            for (int i = 0; i < n; ++i) {
                ITradeComponent comp;
                this.components[comp.getType().getType()] = comp = iTradeComponentArray[i];
            }
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            recipeList.add((Object)new MerchantRecipe(this.build(0, random), this.build(1, random), this.build(2, random), 0, this.maxTradeUses));
        }

        public ItemStack build(int index, Random rand) {
            return this.components[index] == null ? ItemStack.field_190927_a : this.components[index].build(rand);
        }
    }

    public static class RandomTradeList
    implements EntityVillager.ITradeList {
        List<EntityVillager.ITradeList> trades;
        int tries;

        public RandomTradeList(int attempts, EntityVillager.ITradeList ... trades) {
            this.trades = new ArrayList<EntityVillager.ITradeList>(Arrays.asList(trades));
            this.tries = attempts;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            ArrayList<EntityVillager.ITradeList> newList = new ArrayList<EntityVillager.ITradeList>(this.trades);
            for (int i = 0; i < this.tries; ++i) {
                if (newList.isEmpty()) {
                    return;
                }
                ((EntityVillager.ITradeList)newList.remove(random.nextInt(newList.size()))).func_190888_a(merchant, recipeList, random);
            }
        }
    }

    public static class RandomChanceTrade
    implements EntityVillager.ITradeList {
        EntityVillager.ITradeList wrapper;
        float chance;

        public RandomChanceTrade(float chance, EntityVillager.ITradeList wrapper) {
            this.chance = chance;
            this.wrapper = wrapper;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            if (random.nextFloat() <= this.chance) {
                this.wrapper.func_190888_a(merchant, recipeList, random);
            }
        }
    }
}

