/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.reactorPlanner;

import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.TickingReactorLogic;
import ic2.core.block.machine.med.logic.TickingSteamReactorLogic;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerPageBaseComp;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ReactorPlannerPageTwoComp
extends ReactorPlannerPageBaseComp {
    public ReactorPlannerPageTwoComp(TileEntityReactorPlanner tile) {
        super(Ic2GuiComp.reactorPlannerPageTwo, 2, new ItemStack(Blocks.field_150460_al), tile);
    }

    @Override
    public LocaleComp getName() {
        return Ic2GuiLang.reactorActiveInfo;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.MouseClick, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        if (!this.isPageSelected()) {
            return;
        }
        if (this.planner.isSteamReactor) {
            TickingSteamReactorLogic logic = (TickingSteamReactorLogic)this.planner.getReactorLogic();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)2.0f, (float)32.0f, (float)0.0f);
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.0f);
            gui.drawString(Ic2GuiLang.activeSteamProduction.getLocalizedFormatted(format.format(logic.lastSteamProduction)), 5, 130, 0x404040);
            gui.drawString(Ic2GuiLang.currentWaterUsed.getLocalizedFormatted(format.format(logic.totalUsedWater)), 5, 140, 0x404040);
            gui.drawString(Ic2GuiLang.currentHeat.getLocalizedFormatted(format.format(logic.currentHeat)), 5, 150, 0x404040);
            gui.drawString(Ic2GuiLang.currentMaxReactorHeat.getLocalizedFormatted(format.format(logic.maxHeat)), 5, 160, 0x404040);
            gui.drawString(Ic2GuiLang.currentHeatEffectMod.getLocalizedFormatted(format.format(logic.explosionEffect * 100.0f) + "%"), 5, 170, 0x404040);
            gui.drawString(Ic2GuiLang.currentSimulationTime.getLocalizedFormatted(logic.ticksDone), 5, 180, 0x404040);
            gui.drawString(Ic2GuiLang.currentActiveTime.getLocalizedFormatted(logic.ticksLeft, logic.maxTick), 5, 190, 0x404040);
            GL11.glPopMatrix();
        } else {
            TickingReactorLogic logic = (TickingReactorLogic)this.planner.getReactorLogic();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)2.0f, (float)32.0f, (float)0.0f);
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.0f);
            gui.drawString(Ic2GuiLang.currentEUProduction.getLocalizedFormatted(format.format(logic.getReactorEUEnergyOutput())), 5, 130, 0x404040);
            gui.drawString(Ic2GuiLang.currentProducedEU.getLocalizedFormatted(format.format(logic.totalProducedEnergy)), 5, 140, 0x404040);
            gui.drawString(Ic2GuiLang.currentHeat.getLocalizedFormatted(format.format(logic.currentHeat)), 5, 150, 0x404040);
            gui.drawString(Ic2GuiLang.currentMaxReactorHeat.getLocalizedFormatted(format.format(logic.maxHeat)), 5, 160, 0x404040);
            gui.drawString(Ic2GuiLang.currentHeatEffectMod.getLocalizedFormatted(format.format(logic.explosionEffect * 100.0f) + "%"), 5, 170, 0x404040);
            gui.drawString(Ic2GuiLang.currentSimulationTime.getLocalizedFormatted(logic.ticksDone), 5, 180, 0x404040);
            gui.drawString(Ic2GuiLang.currentActiveTime.getLocalizedFormatted(logic.ticksLeft, logic.maxTick), 5, 190, 0x404040);
            GL11.glPopMatrix();
        }
    }
}

