/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.base;

import ic2.api.classic.audio.PositionSpec;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.item.armor.base.ItemIC2AdvArmorBase;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemArmorJetpackBase
extends ItemIC2AdvArmorBase {
    public ItemArmorJetpackBase(int index, EntityEquipmentSlot equipmentSlotIn) {
        super(index, equipmentSlotIn);
    }

    public abstract boolean canDoRocketMode(ItemStack var1);

    public abstract boolean canDoAdvHoverMode(ItemStack var1);

    public abstract boolean isElectricJetpack(ItemStack var1);

    public abstract float getPower(ItemStack var1);

    public abstract float getThruster(ItemStack var1, HoverMode var2);

    public abstract float getDropPercentage(ItemStack var1);

    public abstract int getMaxHeight(ItemStack var1, int var2);

    public abstract int getFuel(ItemStack var1);

    public abstract int getMaxFuel(ItemStack var1);

    public abstract int getMaxRocketCharge(ItemStack var1);

    public abstract int getFuelCost(ItemStack var1, HoverMode var2);

    public abstract void useEnergy(EntityPlayer var1, ItemStack var2, int var3);

    public boolean canDisable(ItemStack stack) {
        return false;
    }

    public AudioSource createAudioSource(ItemStack stack, EntityPlayer player, JetpackUseMode mode) {
        ResourceLocation type = mode == JetpackUseMode.Full ? Ic2Sounds.jetpack : Ic2Sounds.jetpackEmpty;
        return IC2.audioManager.createSource(player, PositionSpec.Backpack, type, true, false, IC2.audioManager.getDefaultVolume());
    }

    @Override
    public ItemStack getRepairItem() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        NBTTagCompound data;
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(6), Ic2InfoLang.jetpackJumpToFly));
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.jetpackModeSwitch));
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(0), Ic2InfoLang.jetpackQuickToggle));
        if (this.canDisable(stack)) {
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(5), Ic2InfoLang.jetpackToggle));
        }
        if (this.canDoRocketMode(stack)) {
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2) + " & " + IC2.keyboard.getKeyName(1), Ic2InfoLang.jetpackToggleRocket));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(1), Ic2InfoLang.jetpackChargeRocket));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(0), Ic2InfoLang.jetpackReleaseRocket));
        }
        if (this instanceof IHandHeldInventory) {
            ctrlTip.add("");
            ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(3), Ic2Lang.openTheItemInventory));
        }
        if ((data = StackUtil.getNbtData(stack)).func_74767_n("RocketMode")) {
            int usedEnergy = data.func_74762_e("UsedEnergy");
            int result = (int)((double)usedEnergy / (double)this.getMaxRocketCharge(stack) * 100.0);
            tooltip.add(Ic2InfoLang.rocketCharge.getLocalizedFormatted(result + "%"));
            tooltip.add("");
        }
    }

    public JetpackUseMode useJetpack(ItemStack stack, EntityPlayer player, PlayerHandler handler, HoverMode hoverMode, Entity effectedEntity) {
        NBTTagCompound nbt;
        byte time;
        int maxFlightHeight;
        double y;
        float retruster;
        float forwardpower;
        int fuel = this.getFuel(stack);
        if (fuel == 0) {
            return JetpackUseMode.None;
        }
        JetpackUseMode jetpackMode = JetpackUseMode.None;
        boolean electric = this.isElectricJetpack(stack);
        float power = this.getPower(stack);
        float dropPercentage = this.getDropPercentage(stack);
        if ((double)fuel / (double)this.getMaxFuel(stack) <= (double)dropPercentage) {
            power = (float)((double)power * ((double)fuel / ((double)this.getMaxFuel(stack) * (double)dropPercentage)));
            jetpackMode = JetpackUseMode.Dropped;
        }
        if (handler.forwardKeyDown && (forwardpower = power * (retruster = this.getThruster(stack, hoverMode)) * 2.0f) > 0.0f) {
            effectedEntity.func_191958_b(0.0f, 0.0f, 0.4f * forwardpower, 0.02f);
        }
        if ((y = effectedEntity.field_70163_u) > (double)((maxFlightHeight = this.getMaxHeight(stack, player.field_70170_p.func_72800_K())) - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power *= (float)(((double)maxFlightHeight - y) / 25.0);
        }
        double prevmotion = effectedEntity.field_70181_x;
        effectedEntity.field_70181_x = Math.min(effectedEntity.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode != HoverMode.None) {
            float maxHoverY;
            float f = maxHoverY = hoverMode == HoverMode.Basic ? -0.2f : 0.0f;
            if (!player.func_70093_af() || !handler.jumpKeyDown) {
                float f2 = hoverMode == HoverMode.Basic ? -0.2f : (maxHoverY = player.func_70093_af() ? -0.2f : 0.0f);
                if (electric && handler.jumpKeyDown) {
                    float f3 = hoverMode == HoverMode.Basic ? 0.1f : (maxHoverY = hoverMode == HoverMode.Adv ? 0.3f : 0.6f);
                }
            }
            if (effectedEntity.field_70181_x > (double)maxHoverY) {
                effectedEntity.field_70181_x = maxHoverY;
                if (prevmotion > effectedEntity.field_70181_x) {
                    effectedEntity.field_70181_x = prevmotion;
                }
            }
        }
        if ((time = (nbt = StackUtil.getOrCreateNbtData(stack)).func_74771_c("FuelUseTime")) == 0) {
            this.useEnergy(player, stack, this.getFuelCost(stack, hoverMode));
            if (jetpackMode != JetpackUseMode.Dropped) {
                jetpackMode = JetpackUseMode.Full;
            }
            if (hoverMode == HoverMode.Basic && !handler.jumpKeyDown) {
                time = 5;
                nbt.func_74774_a("FuelUseTime", time);
            }
        } else if (time <= 1 && jetpackMode != JetpackUseMode.Dropped) {
            jetpackMode = JetpackUseMode.Full;
        }
        effectedEntity.field_70143_R = 0.0f;
        effectedEntity.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime((Entity)player);
        return jetpackMode;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        boolean disabled = nbt.func_74767_n("disabled");
        int jetpackTicker = nbt.func_74771_c("JetpackTicker");
        byte toggleTimer = nbt.func_74771_c("ToggleTimer");
        PlayerHandler handler = PlayerHandler.getHandlerForPlayer(player);
        Entity entity = player.func_184208_bv();
        boolean server = IC2.platform.isSimulating();
        if (disabled) {
            if (server) {
                if (jetpackTicker > 0) {
                    jetpackTicker = (byte)(jetpackTicker - 1);
                    nbt.func_74774_a("JetpackTicker", (byte)jetpackTicker);
                } else if (handler.toggleKeyDown && !handler.screenOpen) {
                    nbt.func_74774_a("JetpackTicker", (byte)10);
                    nbt.func_74757_a("disabled", false);
                    IC2.platform.messagePlayer(player, Ic2InfoLang.jetpackOn);
                }
            }
            return;
        }
        if (this.canDisable(stack) && handler.toggleKeyDown && !handler.screenOpen && jetpackTicker <= 0) {
            if (server) {
                jetpackTicker = 10;
                nbt.func_74757_a("disabled", true);
                nbt.func_74774_a("JetpackTicker", (byte)10);
                IC2.platform.messagePlayer(player, Ic2InfoLang.jetpackOff);
                nbt.func_74774_a("LastUseMode", (byte)JetpackUseMode.None.ordinal());
                return;
            }
        } else if (jetpackTicker > 0) {
            jetpackTicker = (byte)(jetpackTicker - 1);
            nbt.func_74774_a("JetpackTicker", (byte)jetpackTicker);
        }
        HoverMode hoverMode = HoverMode.values()[nbt.func_74771_c("HoverMode")];
        boolean rocketMode = nbt.func_74767_n("RocketMode");
        short rocketDelay = nbt.func_74765_d("RocketDelay");
        boolean jetpackUsed = false;
        JetpackUseMode useMode = JetpackUseMode.None;
        if (rocketMode && !this.canDoRocketMode(stack)) {
            rocketMode = false;
            nbt.func_74757_a("RocketMode", rocketMode);
        }
        if (handler.jumpKeyDown && handler.modeSwitchKeyDown && !handler.altKeyDown && toggleTimer == 0) {
            toggleTimer = 10;
            hoverMode = hoverMode.getNext(this.canDoAdvHoverMode(stack));
            if (server) {
                nbt.func_74774_a("HoverMode", (byte)hoverMode.ordinal());
                if (hoverMode == HoverMode.Basic || hoverMode == HoverMode.Adv) {
                    IC2.platform.messagePlayer(player, hoverMode == HoverMode.Basic ? Ic2InfoLang.hoverModeOn : Ic2InfoLang.hoverModeAdvOn);
                    if (rocketMode) {
                        rocketMode = false;
                        nbt.func_74757_a("RocketMode", rocketMode);
                        IC2.platform.messagePlayer(player, Ic2InfoLang.rocketModeOffForced);
                        this.validateRocketCharge(nbt);
                    }
                } else {
                    IC2.platform.messagePlayer(player, Ic2InfoLang.hoverModeOff);
                }
            }
        }
        if (handler.modeSwitchKeyDown && handler.boostKeyDown && this.canDoRocketMode(stack) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = rocketMode = !rocketMode;
            if (IC2.platform.isSimulating()) {
                nbt.func_74757_a("RocketMode", rocketMode);
                if (rocketMode) {
                    IC2.platform.messagePlayer(player, Ic2InfoLang.rocketModeOn);
                    if (hoverMode != HoverMode.None) {
                        hoverMode = HoverMode.None;
                        nbt.func_74774_a("HoverMode", (byte)hoverMode.ordinal());
                        IC2.platform.messagePlayer(player, Ic2InfoLang.hoverModeOffForced);
                    }
                } else {
                    IC2.platform.messagePlayer(player, Ic2InfoLang.rocketModeOff);
                    this.validateRocketCharge(nbt);
                }
            }
        }
        if (rocketMode && handler.boostKeyDown && rocketDelay == 0) {
            jetpackUsed = this.chargeRocketMode(player, stack);
            useMode = JetpackUseMode.Full;
        }
        if (handler.altKeyDown && rocketMode && rocketDelay <= 0) {
            rocketDelay = this.releaseRocket(player, stack, entity);
            nbt.func_74757_a("RocketMode", false);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            if (server && rocketDelay > 0) {
                IC2.achievements.issueStat(player, "rocketModesUsed");
            }
        } else if (handler.altKeyDown && rocketDelay <= 0 && !handler.modeSwitchKeyDown) {
            hoverMode = hoverMode == HoverMode.None ? HoverMode.Basic : HoverMode.None;
            toggleTimer = 10;
        }
        if (handler.jumpKeyDown && !rocketMode && rocketDelay == 0 || hoverMode != HoverMode.None && (hoverMode == HoverMode.Adv && !entity.field_70122_E || hoverMode == HoverMode.Basic && entity.field_70181_x < -0.1)) {
            useMode = this.useJetpack(stack, player, handler, hoverMode, entity);
            boolean bl = jetpackUsed = useMode != JetpackUseMode.None;
        }
        if (server) {
            byte time;
            if (toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                nbt.func_74774_a("ToggleTimer", toggleTimer);
            }
            if (rocketDelay > 0) {
                rocketDelay = (short)(rocketDelay - 1);
                nbt.func_74777_a("RocketDelay", rocketDelay);
            }
            if ((time = nbt.func_74771_c("FuelUseTime")) > 0) {
                time = (byte)(time - 1);
                nbt.func_74774_a("FuelUseTime", time);
            }
            if (jetpackUsed) {
                IC2.achievements.issueStat(player, "jetpacktimeflown");
            }
            nbt.func_74774_a("LastUseMode", (byte)useMode.ordinal());
        }
    }

    public short releaseRocket(EntityPlayer player, ItemStack stack, Entity effectedEntity) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        int charge = nbt.func_74762_e("UsedEnergy");
        if (charge <= 0) {
            return 0;
        }
        nbt.func_74768_a("UsedEnergy", 0);
        this.useEnergy(player, stack, 50);
        int charges = charge / this.getFuelCost(stack, HoverMode.None);
        float speed = this.getPower(stack) * (float)(charges /= 50);
        effectedEntity.field_70181_x += (double)Math.min(speed /= 4.0f, 10.0f);
        effectedEntity.field_70143_R = 0.0f;
        effectedEntity.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime((Entity)player);
        return (short)(speed * 10.0f);
    }

    public boolean chargeRocketMode(EntityPlayer player, ItemStack stack) {
        if (this.getFuel(stack) == 0) {
            return false;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        int chargedEnergy = nbtData.func_74762_e("UsedEnergy");
        if (chargedEnergy > this.getMaxRocketCharge(stack)) {
            return false;
        }
        int fuelCost = this.getFuelCost(stack, HoverMode.None) * 5;
        int used = Math.min(fuelCost, this.getFuel(stack));
        this.useEnergy(player, stack, used);
        nbtData.func_74768_a("UsedEnergy", chargedEnergy += used);
        return true;
    }

    public void validateRocketCharge(NBTTagCompound nbt) {
        if (nbt.func_74764_b("UsedEnergy")) {
            nbt.func_82580_o("UsedEnergy");
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getFuel(stack) / (double)this.getMaxFuel(stack);
    }

    public int getJetpackUse(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("LastUseMode");
    }

    public static interface IIndirectJetpack {
        public ItemArmorJetpackBase getJetpack();
    }

    public static enum JetpackUseMode {
        Full,
        Dropped,
        None;

    }

    public static enum HoverMode {
        None,
        Basic,
        Adv;


        public HoverMode getNext(boolean canAdv) {
            if (this == None) {
                return Basic;
            }
            if (this == Basic) {
                return canAdv ? Adv : None;
            }
            return None;
        }
    }
}

