/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.base;

import ic2.api.classic.item.IElectricTool;
import ic2.core.item.render.model.ShieldModel;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.IAdvancedTexturedItem;
import ic2.core.platform.textures.obj.ICustomModeledItem;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemIC2ShieldBase
extends ItemShield
implements ICustomModeledItem,
IAdvancedTexturedItem,
IElectricTool {
    ModelResourceLocation[] textures = new ModelResourceLocation[2];
    public LocaleComp name;

    public abstract void damageShield(ItemStack var1, int var2, EntityLivingBase var3);

    public abstract ResourceLocation getTexture(ItemStack var1);

    public boolean canBlock(ItemStack item, EntityLivingBase base) {
        return true;
    }

    public ActionResult<ItemStack> onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (this.canBlock(itemStackIn, (EntityLivingBase)playerIn)) {
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    @Override
    public List<ItemStack> getValidItemTypes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)this));
        list.add(this.setBlocking(new ItemStack((Item)this), true));
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromItem(ItemStack item) {
        boolean blocking = this.isBlocking(item);
        return new ShieldModel(blocking).setOther(this.createResourceLocationForStack(this.setBlocking(item.func_77946_l(), !blocking)));
    }

    @Override
    public ModelResourceLocation createResourceLocationForStack(ItemStack stack) {
        boolean blocking = this.isBlocking(stack);
        String name = stack.func_77977_a();
        ResourceLocation resource = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
        ModelResourceLocation location = new ModelResourceLocation(resource.func_110624_b() + name.substring(name.indexOf(".") + 1) + (blocking ? "_blocking" : ""), "inventory");
        this.textures[blocking ? 1 : 0] = location;
        return location;
    }

    @Override
    public ModelResourceLocation getResourceLocationForStack(ItemStack stack) {
        return this.textures[this.isBlocking(stack) ? 1 : 0];
    }

    public boolean isBlocking(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("Blocking");
    }

    public ItemStack setBlocking(ItemStack stack, boolean blocking) {
        StackUtil.getOrCreateNbtData(stack).func_74757_a("Blocking", blocking);
        return stack;
    }

    public LocaleComp getLangComponent() {
        return this.name;
    }

    public LocaleComp getLangComponent(ItemStack stack) {
        return this.getLangComponent();
    }

    public Item setTranslationKey(LocaleComp component) {
        this.name = component;
        return super.func_77655_b(component.getUnlocalized());
    }

    public Item func_77655_b(String unlocalizedName) {
        this.name = new LangComponentHolder.LocaleItemComp("item." + unlocalizedName);
        return super.func_77655_b(unlocalizedName);
    }

    public String func_77658_a() {
        return this.getLangComponent().getUnlocalized();
    }

    public String func_77667_c(ItemStack stack) {
        return this.getLangComponent(stack).getUnlocalized();
    }

    public String func_77657_g(ItemStack stack) {
        return this.getLangComponent(stack).getLocalized();
    }

    public String func_77653_i(ItemStack stack) {
        return this.getLangComponent(stack).getLocalized();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_92091_k;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return false;
    }
}

