/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.network.INetworkDataProvider;
import ic2.core.IC2;
import ic2.core.inventory.base.IHasGui;
import ic2.core.network.NetworkManager;
import ic2.core.network.NetworkUtils;
import ic2.core.network.PacketManager;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.packets.IC2Packet;
import ic2.core.network.packets.client.FieldRequestPacket;
import ic2.core.network.packets.client.ItemClientEventPacket;
import ic2.core.network.packets.client.ItemCustomClientEventPacket;
import ic2.core.network.packets.client.KeyboardPacket;
import ic2.core.network.packets.client.LoginPacketAnswer;
import ic2.core.network.packets.client.TileClientEventPacket;
import ic2.core.network.packets.client.TileCustomClientEventPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class NetworkManagerClient
extends NetworkManager {
    @Override
    public void requestInitialData(INetworkDataProvider dataProvider) {
        if (IC2.platform.isSimulating()) {
            return;
        }
        if (dataProvider instanceof TileEntity) {
            TileEntity te = (TileEntity)dataProvider;
            PacketManager.instance.sendToServer(new FieldRequestPacket(te, IC2.platform.getPlayerInstance().func_110124_au()));
        } else {
            IC2.platform.displayError("An unknown network data provider attempted to request data from the\nmultiplayer server.\nThis could happen due to a bug.\n\n(Technical information: " + dataProvider + ")");
        }
    }

    @Override
    public void initiateClientItemEvent(ItemStack itemStack, int event) {
        PacketManager.instance.sendToServer(new ItemClientEventPacket(itemStack, event, IC2.platform.getPlayerInstance().func_110124_au()));
    }

    @Override
    public void initiateKeyUpdate(int keyState) {
        PacketManager.instance.sendToServer(new KeyboardPacket(keyState));
    }

    @Override
    public void initiateClientTileEntityEvent(TileEntity te, int event) {
        PacketManager.instance.sendToServer(new TileClientEventPacket(te, event, IC2.platform.getPlayerInstance().func_110124_au()));
    }

    @Override
    public void initiateClientTileEntityEvent(TileEntity te, int event, int value) {
        PacketManager.instance.sendToServer(new TileClientEventPacket(te, event, value, IC2.platform.getPlayerInstance().func_110124_au()));
    }

    @Override
    public void initiateCustomTileEntityEvent(TileEntity te, EntityPlayer player, INetworkFieldData data) {
    }

    @Override
    public void sendLoginData() {
        PacketManager.instance.sendToServer(new LoginPacketAnswer(IC2.config));
    }

    @Override
    public void sendInitialData(EntityPlayerMP mp, TileEntity tile) {
    }

    @Override
    public void announceBlockUpdate(World world, BlockPos pos) {
        if (IC2.platform.isSimulating()) {
            super.announceBlockUpdate(world, pos);
        }
    }

    @Override
    public void updateTileEntityField(TileEntity te, String field) {
    }

    @Override
    public void updateTileEntityField(TileEntity te, String field, EntityPlayerMP player) {
    }

    @Override
    public void updateTileGuiField(TileEntity te, String field) {
    }

    @Override
    public void initiateTileEntityEvent(TileEntity te, int event, boolean limitRange) {
    }

    @Override
    public void initiateItemEvent(EntityPlayer player, ItemStack itemStack, int event, boolean limitRange) {
    }

    @Override
    public void initiateGuiDisplay(EntityPlayerMP entityPlayer, EnumHand hand, IHasGui inventory, int windowId) {
    }

    @Override
    public void initiateExplosionEffect(World world, double x, double y, double z) {
    }

    @Override
    public void initiateExplosionEffect(World world, double x, double y, double z, boolean nuke) {
    }

    @Override
    public void sendCustomPacket(EntityPlayer player, IC2Packet packet) {
    }

    @Override
    public void sendCustomPacket(IC2Packet packet) {
        PacketManager.instance.sendToServer(packet);
    }

    @Override
    public void handleInitialChange(TileEntity prov, NBTTagCompound nbt) {
        if (nbt.func_74764_b("ic2cData")) {
            List<NetworkManager.FieldData> data = NetworkUtils.readEntries(new InputBuffer((ByteBuf)new PacketBuffer(Unpooled.wrappedBuffer((byte[])nbt.func_74770_j("ic2cData")))));
            if (data.isEmpty()) {
                return;
            }
            NetworkUtils.applyFields(prov, data, false);
        }
    }

    @Override
    public void initiateCustomItemEvent(EntityPlayer player, ItemStack stack, INetworkFieldData data) {
    }

    @Override
    public void initiateCustomClientTileEntityEvent(TileEntity te, INetworkFieldData data) {
        String id = (String)classToID.get(data.getClass());
        if (id == null) {
            return;
        }
        PacketManager.instance.sendToServer(new TileCustomClientEventPacket(te, id, data, IC2.platform.getPlayerInstance().func_110124_au()));
    }

    @Override
    public void initiateCustomClientItemEvent(ItemStack itemStack, INetworkFieldData data) {
        String id = (String)classToID.get(data.getClass());
        if (id == null) {
            return;
        }
        PacketManager.instance.sendToServer(new ItemCustomClientEventPacket(itemStack, id, data, IC2.platform.getPlayerInstance().func_110124_au()));
    }
}

