/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.tekkit.tekkit2.tekkit2jc.common.item;

import com.google.common.collect.ImmutableList;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.technicpack.tekkit.tekkit2.tekkit2jc.common.init.JcItems;

public class ItemEdible
extends ItemFood {
    public static final String NAME = "edible";

    public ItemEdible() {
        super(3, false);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(CreativeTabs.field_78039_h);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Type type : Type.VALUES) {
                items.add((Object)type.newStack(1));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Type type = Type.getForStack(stack);
        if (type == null || !player.func_71043_e(type == Type.JAFFA_CAKE)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public int func_150905_g(ItemStack stack) {
        Type type = Type.getForStack(stack);
        return type != null ? type.foodValue : super.func_150905_g(stack);
    }

    public float func_150906_h(ItemStack stack) {
        Type type = Type.getForStack(stack);
        return type != null ? type.saturationMod : super.func_150906_h(stack);
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && Type.getForStack(stack) == Type.JAFFA_CAKE) {
            switch (world.field_73012_v.nextInt(20)) {
                case 0: 
                case 1: {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 220, 79));
                    break;
                }
                case 2: {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 440, 1));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 440, 1));
                    break;
                }
                case 3: {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 440, 1));
                }
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        Type type = Type.getForStack(stack);
        return type == null ? super.func_77667_c(stack) : super.func_77667_c(stack) + "." + type.key;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return Type.getForStack(stack) == Type.JAFFA_CAKE ? EnumRarity.UNCOMMON : super.getForgeRarity(stack);
    }

    public static enum Type {
        SPONGE_CAKE(3, 0.6f),
        ORANGE_JAM(3, 0.6f),
        JAFFA_CAKE(6, 1.3f);

        public static final ImmutableList<Type> VALUES;
        public final String key = this.name().toLowerCase(Locale.ROOT);
        public final int foodValue;
        public final float saturationMod;

        @Nullable
        public static Type getForMeta(int metadata) {
            return metadata >= 0 && metadata < VALUES.size() ? (Type)((Object)VALUES.get(metadata)) : null;
        }

        @Nullable
        public static Type getForStack(ItemStack stack) {
            return Type.getForMeta(stack.func_77960_j());
        }

        private Type(int foodValue, float saturationMod) {
            this.foodValue = foodValue;
            this.saturationMod = saturationMod;
        }

        public ItemStack newStack(int amount) {
            return amount > 0 ? new ItemStack(JcItems.EDIBLE, amount, this.ordinal()) : ItemStack.field_190927_a;
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])Type.values());
        }
    }
}

