/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.block.tile;

import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weissmoon.electromagictools.api.ISolarRequirements;

public class SolarRegistry {
    public static final ISolarRequirements defaultRequirements = new ISolarRequirements(){

        @Override
        public boolean canGenerate(World world, BlockPos blockPos) {
            return false;
        }

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 0.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return 0.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{0}));
            }
        }
    };
    public static final ISolarRequirements compressed1 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 10.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return 10.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{10.0}));
            }
        }
    };
    public static final ISolarRequirements compressed2 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 100.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return 100.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{100.0}));
            }
        }
    };
    public static final ISolarRequirements compressed3 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 1000.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return 1000.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{1000.0}));
            }
        }
    };
    public static final ISolarRequirements aer1 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 10.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return blockPos.func_177956_o() > 160 ? 25.0 : 10.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{10.0}));
                tooltip.add(SolarRegistry.getAerTooltip(25.0));
            }
        }
    };
    public static final ISolarRequirements aer2 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 100.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return blockPos.func_177956_o() > 160 ? 250.0 : 100.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{100.0}));
                tooltip.add(SolarRegistry.getAerTooltip(250.0));
            }
        }
    };
    public static final ISolarRequirements aer3 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 1000.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return blockPos.func_177956_o() > 160 ? 2500.0 : 1000.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{1000.0}));
                tooltip.add(SolarRegistry.getAerTooltip(2500.0));
            }
        }
    };
    public static final ISolarRequirements terra1 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 10.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return blockPos.func_177956_o() < 11 ? 25.0 : 10.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{10.0}));
                tooltip.add(SolarRegistry.getTerraTooltip(25.0));
            }
        }
    };
    public static final ISolarRequirements terra2 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 100.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return blockPos.func_177956_o() < 11 ? 250.0 : 100.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{100.0}));
                tooltip.add(SolarRegistry.getTerraTooltip(250.0));
            }
        }
    };
    public static final ISolarRequirements terra3 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 1000.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return blockPos.func_177956_o() < 11 ? 2500.0 : 1000.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{1000.0}));
                tooltip.add(SolarRegistry.getTerraTooltip(2500.0));
            }
        }
    };
    public static final ISolarRequirements ordo1 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 10.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return 30.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{30.0}));
            }
        }
    };
    public static final ISolarRequirements ordo2 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 100.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return 300.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{300.0}));
            }
        }
    };
    public static final ISolarRequirements ordo3 = new IBasicSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 1000.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return 3000.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{3000.0}));
            }
        }
    };
    public static final ISolarRequirements perditio1 = new IDarkSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 10.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return 10.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(SolarRegistry.getPerditioTooltip(10.0));
            }
        }
    };
    public static final ISolarRequirements perditio2 = new IDarkSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 100.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return 100.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(SolarRegistry.getPerditioTooltip(100.0));
            }
        }
    };
    public static final ISolarRequirements perditio3 = new IDarkSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 1000.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return 1000.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(SolarRegistry.getPerditioTooltip(1000.0));
            }
        }
    };
    public static final IWaterSolar aqua1 = new IWaterSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 10.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            if (world.func_72911_I()) {
                return 25.0;
            }
            return 10.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(SolarRegistry.getAquaTooltip(10.0));
                tooltip.add(SolarRegistry.getTempestasTooltip(25.0));
            }
        }
    };
    public static final IWaterSolar aqua2 = new IWaterSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 100.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            if (world.func_72911_I()) {
                return 250.0;
            }
            return 100.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(SolarRegistry.getAquaTooltip(100.0));
                tooltip.add(SolarRegistry.getTempestasTooltip(250.0));
            }
        }
    };
    public static final IWaterSolar aqua3 = new IWaterSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 1000.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            if (world.func_72911_I()) {
                return 2500.0;
            }
            return 1000.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(SolarRegistry.getAquaTooltip(1000.0));
                tooltip.add(SolarRegistry.getTempestasTooltip(2500.0));
            }
        }
    };
    public static final ISolarRequirements ignis1 = new IFireSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 10.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(blockPos), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                return 25.0;
            }
            return 10.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{10.0}));
                tooltip.add(SolarRegistry.getIgnisTooltip(25.0));
            }
        }
    };
    public static final ISolarRequirements ignis2 = new IFireSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 100.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return ignis1.getEnergyPerTick(world, blockPos) * 10.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{100.0}));
                tooltip.add(SolarRegistry.getIgnisTooltip(250.0));
            }
        }
    };
    public static final ISolarRequirements ignis3 = new IFireSolar(){

        @Override
        public double getEnergyPerTick(World world, Vec3d vec3d, ItemStack stack) {
            return 1000.0;
        }

        @Override
        public double getEnergyPerTick(World world, BlockPos blockPos) {
            return ignis1.getEnergyPerTick(world, blockPos) * 100.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
            if (handler.hasEUReader()) {
                tooltip.add(Ic2InfoLang.electricProduction.getLocalizedFormatted(new Object[]{1000.0}));
                tooltip.add(SolarRegistry.getIgnisTooltip(2500.0));
            }
        }
    };

    @SideOnly(value=Side.CLIENT)
    private static String getAerTooltip(Object generation) {
        String returning = new TextComponentTranslation("tooltip.EMT.solar.aer", new Object[]{TextFormatting.GRAY}).func_150254_d() + TextFormatting.GRAY.toString() + generation + new TextComponentTranslation("tooltip.EMT.solar.ending", new Object[0]).func_150254_d();
        return returning;
    }

    @SideOnly(value=Side.CLIENT)
    private static String getTerraTooltip(Object generation) {
        String returning = new TextComponentTranslation("tooltip.EMT.solar.terra", new Object[]{TextFormatting.GRAY, generation}).func_150254_d() + TextFormatting.GRAY.toString() + generation + new TextComponentTranslation("tooltip.EMT.solar.ending", new Object[0]).func_150254_d();
        return returning;
    }

    @SideOnly(value=Side.CLIENT)
    private static String getPerditioTooltip(Object generation) {
        String returning = new TextComponentTranslation("tooltip.EMT.solar.perditio", new Object[]{TextFormatting.GRAY, generation}).func_150254_d() + TextFormatting.GRAY.toString() + generation + new TextComponentTranslation("tooltip.EMT.solar.ending", new Object[0]).func_150254_d();
        return returning;
    }

    @SideOnly(value=Side.CLIENT)
    private static String getAquaTooltip(Object generation) {
        String returning = new TextComponentTranslation("tooltip.EMT.solar.aqua", new Object[]{TextFormatting.GRAY, generation}).func_150254_d() + TextFormatting.GRAY.toString() + generation + new TextComponentTranslation("tooltip.EMT.solar.ending", new Object[0]).func_150254_d();
        return returning;
    }

    @SideOnly(value=Side.CLIENT)
    private static String getTempestasTooltip(Object generation) {
        String returning = new TextComponentTranslation("tooltip.EMT.solar.tempestas", new Object[]{TextFormatting.GRAY, generation}).func_150254_d() + TextFormatting.GRAY.toString() + generation + new TextComponentTranslation("tooltip.EMT.solar.ending", new Object[0]).func_150254_d();
        return returning;
    }

    @SideOnly(value=Side.CLIENT)
    private static String getIgnisTooltip(Object generation) {
        String returning = new TextComponentTranslation("tooltip.EMT.solar.ignis", new Object[]{TextFormatting.GRAY, generation}).func_150254_d() + TextFormatting.GRAY.toString() + generation + new TextComponentTranslation("tooltip.EMT.solar.ending", new Object[0]).func_150254_d();
        return returning;
    }

    public static interface IFireSolar
    extends ISolarRequirements {
        @Override
        default public boolean canGenerate(World world, BlockPos blockPos) {
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(blockPos), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                return true;
            }
            return world.func_175678_i(blockPos) && world.func_72935_r() && !world.func_175727_C(blockPos);
        }
    }

    public static interface IWaterSolar
    extends ISolarRequirements {
        @Override
        default public boolean canGenerate(World world, BlockPos blockPos) {
            return world.func_175678_i(blockPos) && world.func_175727_C(blockPos);
        }
    }

    public static interface IDarkSolar
    extends ISolarRequirements {
        @Override
        default public boolean canGenerate(World world, BlockPos blockPos) {
            return world.func_175678_i(blockPos) && !world.func_72935_r() && !world.func_175727_C(blockPos);
        }
    }

    public static interface IBasicSolar
    extends ISolarRequirements {
        @Override
        default public boolean canGenerate(World world, BlockPos blockPos) {
            return world.func_175678_i(blockPos) && world.func_72935_r() && !world.func_175727_C(blockPos);
        }
    }
}

