/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.armour.googles;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import weissmoon.core.utils.NBTHelper;
import weissmoon.electromagictools.api.ISolarRequirements;
import weissmoon.electromagictools.api.SolarHelmetRegistry;
import weissmoon.electromagictools.item.armour.googles.ItemQuantumGoggles;

public class ItemSolarHelmetRevealing
extends ItemQuantumGoggles {
    private int genDay = 65536;
    private int genNight = 4096;
    public static final String NBT_INFUSED_SOLAR = "solarPanel";

    public ItemSolarHelmetRevealing() {
        super("itemSolarGoggles", ItemArmor.ArmorMaterial.IRON, 20000000, 18000, 4, 20000, 7);
        this.func_77637_a(null);
    }

    @Override
    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "welectromagic:textures/models/armor/solahelmet.png";
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        ItemStack solarPanel = this.getSolar(stack);
        BlockPos playerPos = new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
        double enerj = 0.0;
        if (solarPanel.func_190926_b()) {
            if (world.func_175678_i(playerPos)) {
                enerj = (world.func_72935_r() ? (double)this.genDay : (double)this.genNight) / 12000.0;
            }
        } else {
            ISolarRequirements iSolarRequirements = (ISolarRequirements)SolarHelmetRegistry.stackRequirements.func_82594_a(stack);
            if (iSolarRequirements.canGenerate(world, playerPos)) {
                enerj = iSolarRequirements.getEnergyPerTick(world, new Vec3d((Vec3i)playerPos), solarPanel);
            }
        }
        if (enerj <= 0.0) {
            return;
        }
        for (ItemStack armor : player.func_184193_aE()) {
            if (!(armor.func_77973_b() instanceof IElectricItem) || !((enerj -= ElectricItem.manager.charge(armor, enerj, 4, false, false)) <= 0.0)) continue;
            return;
        }
        if (enerj <= 0.0) {
            return;
        }
        for (ItemStack invStack : player.field_71071_by.field_70462_a) {
            if (!(invStack.func_77973_b() instanceof IElectricItem) || !((enerj -= ElectricItem.manager.charge(invStack, enerj, 4, false, false)) <= 0.0)) continue;
            return;
        }
    }

    public ItemStack getSolar(ItemStack helmet) {
        NBTTagCompound cmp = NBTHelper.getTagCompound((ItemStack)helmet, (String)NBT_INFUSED_SOLAR);
        if (cmp == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(cmp);
    }

    @Override
    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[0];
    }

    @Override
    public boolean isCropAnalyzer(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isEUReader(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isThermometer(ItemStack stack) {
        return false;
    }
}

