/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.armour.wings;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.util.Keys;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weissmoon.core.utils.NBTHelper;
import weissmoon.electromagictools.client.WingsModelRenderer;
import weissmoon.electromagictools.item.ModItems;
import weissmoon.electromagictools.item.armour.wings.ItemThaumiumWings;
import weissmoon.electromagictools.util.ItemHelper;

public class ItemNanoWings
extends ItemThaumiumWings
implements IDamagelessElectricItem,
ISpecialArmor {
    protected int energyPerDamage;
    protected int energyPerJump;
    protected int maxCharge;
    protected int transferLimit;

    public ItemNanoWings() {
        this("itemNanoWings", ItemArmor.ArmorMaterial.IRON);
        this.fallReduction = 0.3f;
        this.propulsion = 0.25f;
        this.fallDamage = 0.25f;
        this.tier = 2;
        this.visDiscount = 5;
        this.maxCharge = 1000000;
        this.transferLimit = 1600;
        this.energyPerDamage = 5000;
        this.energyPerJump = 6;
    }

    protected ItemNanoWings(String name, ItemArmor.ArmorMaterial materialIn) {
        super(name, materialIn);
        this.setNoRepair();
        this.func_77656_e(0);
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped original) {
        if (this.model == null) {
            ItemStack s = new ItemStack((Item)ModItems.materials, 1, 16);
            NBTHelper.setInteger((ItemStack)s, (String)"icon", (int)1);
            this.model = new WingsModelRenderer(s, 1);
        }
        return this.model;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            list.add((Object)stack);
            list.add((Object)ItemHelper.getChargedItem((IElectricItem)this, 1));
        }
    }

    @Override
    public void tickWings(@Nonnull EntityPlayer player, ItemStack wings, World world) {
        byte flap = NBTHelper.getByte((ItemStack)wings, (String)"flap");
        if (!Keys.instance.isJumpKeyDown(player) && flap > 0) {
            ElectricItem.manager.use(wings, (double)(this.energyPerJump * flap), (EntityLivingBase)player);
        }
        if (ElectricItem.manager.getCharge(wings) > 5.0) {
            super.tickWings(player, wings, world);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ItemHelper.getElectricDurability(stack);
    }

    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    protected double getAbsorptionRatio() {
        return 0.9;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack stack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = 0.15 * this.getAbsorptionRatio();
        double damageLimit = 25.0 * ElectricItem.manager.getCharge(armor) / (double)this.energyPerDamage;
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, (int)damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.energyPerDamage) {
            return (int)Math.round(5.0 * this.getAbsorptionRatio());
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.energyPerDamage), Integer.MAX_VALUE, true, false, false);
    }
}

