/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.tool;

import ic2.api.classic.crops.IDropController;
import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IElectricTool;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.blocks.BlocksTC;
import weissmoon.core.item.tools.WeissItemHoe;
import weissmoon.core.utils.NBTHelper;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.util.ItemHelper;

public class ItemElectricHoeGrowth
extends WeissItemHoe
implements IDamagelessElectricItem,
IElectricTool,
IDropController {
    private Random all0 = new Random(){

        @Override
        public int nextInt(int na) {
            return 0;
        }
    };
    private final int maxCharge = 200000;

    public ItemElectricHoeGrowth() {
        super(ThaumcraftMaterials.TOOLMAT_ELEMENTAL, "itemElectricHoe");
        this.setNoRepair();
        this.func_77637_a((CreativeTabs)ElectroMagicTools.EMTtab);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos blockPos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return super.func_180614_a(player, world, blockPos, hand, facing, hitX, hitY, hitZ);
        }
        ItemStack hoeStack = player.func_184586_b(hand);
        NBTHelper.setBoolean((ItemStack)hoeStack, (String)"Unbreakable", (boolean)true);
        boolean used = false;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos hoePos = new BlockPos((Vec3i)blockPos).func_177982_a(x, 0, z);
                if (!ElectricItem.manager.canUse(hoeStack, 25.0) || !super.func_180614_a(player, world, hoePos, hand, facing, hitX, hitY, hitZ).equals((Object)EnumActionResult.SUCCESS)) continue;
                ElectricItem.manager.use(hoeStack, 25.0, (EntityLivingBase)player);
                world.func_175718_b(2005, hoePos, 0);
                used = true;
            }
        }
        if (used) {
            NBTHelper.setBoolean((ItemStack)player.func_184586_b(hand), (String)"Unbreakable", (boolean)false);
            return EnumActionResult.SUCCESS;
        }
        if (ElectricItem.manager.canUse(hoeStack, 250.0)) {
            used = ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, 15), (World)world, (BlockPos)blockPos);
            if (!used) {
                IBlockState state = world.func_180495_p(blockPos);
                Block block = state.func_177230_c();
                if (block == BlocksTC.saplingGreatwood) {
                    if (!world.field_72995_K) {
                        ((IGrowable)BlocksTC.saplingGreatwood).func_176474_b(world, this.all0, blockPos, world.func_180495_p(blockPos));
                    }
                    world.func_175718_b(2005, blockPos, 0);
                    used = true;
                }
                if (block == BlocksTC.saplingSilverwood) {
                    if (!world.field_72995_K) {
                        ((IGrowable)BlocksTC.saplingSilverwood).func_176474_b(world, this.all0, blockPos, world.func_180495_p(blockPos));
                    }
                    world.func_175718_b(2005, blockPos, 0);
                    used = true;
                }
                if (block == Blocks.field_150436_aH) {
                    if (world.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150436_aH && world.func_175623_d(blockPos.func_177981_b(2)) && world.func_180495_p(blockPos.func_177977_b()).func_177230_c() != Blocks.field_150436_aH) {
                        world.func_175656_a(blockPos.func_177981_b(2), Blocks.field_150436_aH.func_176223_P());
                        ElectricItem.manager.use(hoeStack, 250.0, (EntityLivingBase)player);
                        world.func_175718_b(2005, blockPos, 0);
                        used = true;
                    }
                    if (!used && (world.func_180495_p(blockPos.func_177977_b()).func_177230_c() != Blocks.field_150436_aH || world.func_180495_p(blockPos.func_177977_b()).func_177230_c() == Blocks.field_150436_aH && world.func_180495_p(blockPos.func_177979_c(2)).func_177230_c() != Blocks.field_150436_aH) && world.func_175623_d(blockPos.func_177984_a())) {
                        world.func_175656_a(blockPos.func_177984_a(), Blocks.field_150436_aH.func_176223_P());
                        ElectricItem.manager.use(hoeStack, 250.0, (EntityLivingBase)player);
                        world.func_175718_b(2005, blockPos, 0);
                        used = true;
                    }
                }
                if (block == Blocks.field_150434_aF) {
                    if (world.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150434_aF && world.func_175623_d(blockPos.func_177981_b(2)) && world.func_180495_p(blockPos.func_177977_b()).func_177230_c() != Blocks.field_150434_aF && Blocks.field_150434_aF.func_176196_c(world, blockPos.func_177981_b(2))) {
                        world.func_175656_a(blockPos.func_177981_b(2), Blocks.field_150434_aF.func_176223_P());
                        ElectricItem.manager.use(hoeStack, 250.0, (EntityLivingBase)player);
                        world.func_175718_b(2005, blockPos, 0);
                        used = true;
                    }
                    if (!used && (world.func_180495_p(blockPos.func_177977_b()).func_177230_c() != Blocks.field_150434_aF || world.func_180495_p(blockPos.func_177977_b()).func_177230_c() == Blocks.field_150434_aF && world.func_180495_p(blockPos.func_177979_c(2)).func_177230_c() != Blocks.field_150434_aF) && world.func_175623_d(blockPos.func_177984_a()) && Blocks.field_150434_aF.func_176196_c(world, blockPos.func_177984_a())) {
                        world.func_175656_a(blockPos.func_177984_a(), Blocks.field_150434_aF.func_176223_P());
                        ElectricItem.manager.use(hoeStack, 250.0, (EntityLivingBase)player);
                        world.func_175718_b(2005, blockPos, 0);
                        used = true;
                    }
                }
            } else {
                ElectricItem.manager.use(hoeStack, 250.0, (EntityLivingBase)player);
                world.func_175718_b(2005, blockPos, 0);
            }
            if (used) {
                world.func_184133_a(player, blockPos, new SoundEvent(new ResourceLocation("thaumcraft:wand")), SoundCategory.BLOCKS, 0.75f, 0.9f);
            }
        }
        NBTHelper.setBoolean((ItemStack)player.func_184586_b(hand), (String)"Unbreakable", (boolean)false);
        if (used) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            list.add((Object)stack);
            list.add((Object)ItemHelper.getChargedItem((IElectricItem)this, 1));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ItemHelper.getElectricDurability(stack);
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return 200000.0;
    }

    public int getTier(ItemStack stack) {
        return 2;
    }

    public double getTransferLimit(ItemStack stack) {
        return 1000.0;
    }

    public EnumEnchantmentType getType(ItemStack itemStack) {
        return EnumEnchantmentType.BREAKABLE;
    }

    public boolean isSpecialSupported(ItemStack itemStack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_185307_s;
    }

    public boolean isExcluded(ItemStack itemStack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185296_A;
    }

    public boolean isChangingCropDrops(ItemStack itemStack) {
        return true;
    }
}

