/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.tool.drill;

import ic2.core.IC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.util.misc.StackUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import weissmoon.core.utils.NBTHelper;
import weissmoon.electromagictools.item.tool.drill.ItemThaumiumDrill;
import weissmoon.electromagictools.lib.Strings;

public class ItemIridiumDrill
extends ItemThaumiumDrill {
    private static String FORTUNE_MODE_NBT_KEY = "fortuneMode";
    private static String SILK_MODE_NBT_KEY = "silkMode";
    private static String DIRTMODE_NBT_KEY = "dirtMode";

    public ItemIridiumDrill() {
        super(Item.ToolMaterial.DIAMOND, "itemIridiumDrill", 300000, 1000, 2);
        this.operationEnergyCost = 300;
        this.field_77864_a = 25.0f;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        boolean fortune = NBTHelper.getBoolean((ItemStack)stack, (String)FORTUNE_MODE_NBT_KEY);
        boolean silk = NBTHelper.getBoolean((ItemStack)stack, (String)SILK_MODE_NBT_KEY);
        if (fortune) {
            tooltip.add(Enchantments.field_185308_t.func_77316_c(3));
        } else if (silk) {
            tooltip.add(Enchantments.field_185306_r.func_77316_c(1));
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
            if (IC2.platform.isRendering()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
            BreakModes mode = BreakModes.fromBool(tag.func_74767_n(FORTUNE_MODE_NBT_KEY), tag.func_74767_n(SILK_MODE_NBT_KEY), tag.func_74767_n(DIRTMODE_NBT_KEY)).cycle(playerIn);
            tag.func_74757_a(FORTUNE_MODE_NBT_KEY, mode.fortuneMode);
            tag.func_74757_a(SILK_MODE_NBT_KEY, mode.silkMode);
            tag.func_74757_a(DIRTMODE_NBT_KEY, mode.dirtMode);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2.keyboard.isAltKeyDown(playerIn) && !this.getScanner(playerIn.field_71071_by).func_190926_b()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
        BreakModes mode = BreakModes.fromBool(tag.func_74767_n(FORTUNE_MODE_NBT_KEY), tag.func_74767_n(SILK_MODE_NBT_KEY), tag.func_74767_n(DIRTMODE_NBT_KEY));
        return mode.fortuneMode || mode.silkMode;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_185306_r) {
            return false;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        NBTTagList nbttaglist = book.func_77986_q();
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(j);
            short k = nbttagcompound.func_74765_d("id");
            Enchantment enchantment = Enchantment.func_185262_c((int)k);
            if (enchantment != Enchantments.field_185308_t && enchantment != Enchantments.field_185306_r) continue;
            return false;
        }
        return super.isBookEnchantable(stack, book);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        boolean fortune = NBTHelper.getBoolean((ItemStack)itemstack, (String)FORTUNE_MODE_NBT_KEY);
        boolean silk = NBTHelper.getBoolean((ItemStack)itemstack, (String)SILK_MODE_NBT_KEY);
        if (fortune) {
            itemstack.func_77966_a(Enchantments.field_185308_t, 3);
            NBTHelper.setBoolean((ItemStack)itemstack, (String)"fortuneAddition", (boolean)true);
        } else if (silk) {
            itemstack.func_77966_a(Enchantments.field_185306_r, 1);
            NBTHelper.setBoolean((ItemStack)itemstack, (String)"silkAddition", (boolean)true);
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Map enchants;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"silkAddition")) {
            NBTHelper.setBoolean((ItemStack)stack, (String)"silkAddition", (boolean)false);
            enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchants.remove(Enchantments.field_185306_r);
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
        }
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"fortuneAddition")) {
            NBTHelper.setBoolean((ItemStack)stack, (String)"fortuneAddition", (boolean)false);
            enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchants.remove(Enchantments.field_185308_t);
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
        }
    }

    public int getEnergyCost(ItemStack stack) {
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
        BreakModes mode = BreakModes.fromBool(tag.func_74767_n(FORTUNE_MODE_NBT_KEY), tag.func_74767_n(SILK_MODE_NBT_KEY), tag.func_74767_n(DIRTMODE_NBT_KEY));
        if (mode.fortuneMode || mode.silkMode) {
            return this.operationEnergyCost * 3;
        }
        return this.operationEnergyCost;
    }

    private static enum BreakModes {
        FORTUNE_AND_DIRTMODE(true, false, true),
        FORTUNE_ONLY(true, false, false),
        SILK_AND_DIRTMODE(false, true, true),
        SILK_ONLY(false, true, false),
        DIRTMODE_ONLY(false, false, true),
        NEITHER(false, false, false);

        boolean fortuneMode;
        boolean silkMode;
        boolean dirtMode;

        private BreakModes(boolean fortuneMode, boolean silkMode, boolean dirtMode) {
            this.fortuneMode = fortuneMode;
            this.silkMode = silkMode;
            this.dirtMode = dirtMode;
        }

        static BreakModes fromBool(boolean fortune, boolean silk, boolean dirt) {
            if (fortune) {
                if (dirt) {
                    return FORTUNE_AND_DIRTMODE;
                }
                return FORTUNE_ONLY;
            }
            if (silk) {
                if (dirt) {
                    return SILK_AND_DIRTMODE;
                }
                return SILK_ONLY;
            }
            if (dirt) {
                return DIRTMODE_ONLY;
            }
            return NEITHER;
        }

        BreakModes cycle(EntityPlayer player) {
            if (this == FORTUNE_AND_DIRTMODE) {
                IC2.platform.messagePlayer(player, TextFormatting.RED, Ic2InfoLang.disableDrillMode);
                return FORTUNE_ONLY;
            }
            if (this == FORTUNE_ONLY) {
                IC2.platform.messagePlayer(player, TextFormatting.RED, Strings.LocaleComps.MESSAGE_IRIDIUM_DRILL_NO_FORTUNE);
                IC2.platform.messagePlayer(player, TextFormatting.GREEN, Strings.LocaleComps.MESSAGE_IRIDIUM_DRILL_SILK);
                IC2.platform.messagePlayer(player, TextFormatting.GREEN, Ic2InfoLang.enableDrillMode);
                return SILK_AND_DIRTMODE;
            }
            if (this == SILK_AND_DIRTMODE) {
                IC2.platform.messagePlayer(player, TextFormatting.RED, Ic2InfoLang.disableDrillMode);
                return SILK_ONLY;
            }
            if (this == SILK_ONLY) {
                IC2.platform.messagePlayer(player, TextFormatting.RED, Strings.LocaleComps.MESSAGE_IRIDIUM_DRILL_NO_SILK);
                IC2.platform.messagePlayer(player, TextFormatting.GREEN, Ic2InfoLang.enableDrillMode);
                return DIRTMODE_ONLY;
            }
            if (this == DIRTMODE_ONLY) {
                IC2.platform.messagePlayer(player, TextFormatting.RED, Ic2InfoLang.disableDrillMode);
                return NEITHER;
            }
            IC2.platform.messagePlayer(player, TextFormatting.GREEN, Strings.LocaleComps.MESSAGE_IRIDIUM_DRILL_FORTUNE);
            IC2.platform.messagePlayer(player, TextFormatting.GREEN, Ic2InfoLang.enableDrillMode);
            return FORTUNE_AND_DIRTMODE;
        }
    }
}

