/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.tool.omnitool;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import ic2.api.classic.item.IMiningDrill;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.item.WeissItemElectricTool;
import weissmoon.electromagictools.util.ItemHelper;

public class ItemIronOmniTool
extends WeissItemElectricTool
implements IMiningDrill {
    protected int hitCost;
    protected static final String SHEARMODE_NBT_TAG = "shearsMode";

    public ItemIronOmniTool() {
        this(7, Item.ToolMaterial.IRON, "itemIronOmniTool", 50000, 200, 1);
        this.field_77864_a = 13.0f;
        this.operationEnergyCost = 100;
    }

    public ItemIronOmniTool(int attackDamage, Item.ToolMaterial material, String name, int maxCharge, int transferLimit, int tier) {
        super(attackDamage, -3.0f, material, name);
        this.maxCharge = maxCharge;
        this.hitCost = (int)((float)this.operationEnergyCost * 1.25f);
        this.tier = tier;
        this.transferLimit = transferLimit;
        this.func_77637_a((CreativeTabs)ElectroMagicTools.EMTtab);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ((double)this.maxCharge - ElectricItem.manager.getCharge(stack)) / (double)this.maxCharge;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        ElectricItem.manager.use(stack, (double)this.operationEnergyCost, entityLiving);
        return true;
    }

    public boolean canHarvestBlock(IBlockState block, ItemStack stack) {
        return Items.field_151036_c.func_150897_b(block) || Items.field_151037_a.func_150897_b(block) || Items.field_151035_b.func_150897_b(block) || Items.field_151040_l.func_150897_b(block) || block.func_177230_c() instanceof IShearable;
    }

    public float func_150893_a(ItemStack stack, IBlockState block) {
        if (!ElectricItem.manager.canUse(stack, (double)this.operationEnergyCost)) {
            return 1.0f;
        }
        if (this.toolSpeed(stack, block) || Items.field_151097_aZ.func_150893_a(stack, block) > 1.0f) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, block);
    }

    public boolean toolSpeed(ItemStack stack, IBlockState block) {
        return Items.field_151036_c.func_150893_a(stack, block) > 1.0f || Items.field_151037_a.func_150893_a(stack, block) > 1.0f || Items.field_151035_b.func_150893_a(stack, block) > 1.0f || Items.field_151040_l.func_150893_a(stack, block) > 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        ElectricItem.manager.use(stack, (double)this.hitCost, attacker);
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            double stackAttackDamage = 1.5;
            if (ElectricItem.manager.canUse(stack, (double)this.hitCost)) {
                stackAttackDamage = this.field_77865_bY;
            }
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", stackAttackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, 0));
        }
        return multimap;
    }

    public int func_77619_b() {
        return 2;
    }

    public boolean isRepairable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            list.add((Object)stack);
            list.add((Object)ItemHelper.getChargedItem((IElectricItem)this, 1));
        }
    }

    public EnumEnchantmentType getType(ItemStack itemStack) {
        return EnumEnchantmentType.DIGGER;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"axe", (Object)"shovel");
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack stack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean isBasicDrill(ItemStack drill) {
        return false;
    }

    public int getExtraSpeed(ItemStack stack) {
        return this.getPointBoost(stack);
    }

    private int getPointBoost(ItemStack stack) {
        int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
        return lvl <= 0 ? 0 : lvl * lvl + 1;
    }

    public int getExtraEnergyCost(ItemStack stack) {
        int points = this.getEnergyChange(stack);
        return Math.max(points, 0);
    }

    public void useDrill(ItemStack drill) {
        ElectricItem.manager.use(drill, (double)this.operationEnergyCost * 0.95, null);
    }

    public boolean canMine(ItemStack drill) {
        return ElectricItem.manager.getCharge(drill) >= (double)this.operationEnergyCost * 0.95;
    }

    public boolean canMineBlock(ItemStack drill, IBlockState state, IBlockAccess access, BlockPos pos) {
        return ForgeHooks.canToolHarvestBlock((IBlockAccess)access, (BlockPos)pos, (ItemStack)drill);
    }

    public int getEnergyChange(ItemStack stack) {
        int eff = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
        int unb = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
        int points = eff * eff + 1;
        return points -= unb * (unb + unb);
    }
}

