/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.IThaumcraftRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.common.container.ContainerArcaneWorkbench;
import thaumcraft.common.lib.utils.Utils;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.item.ModItems;
import weissmoon.electromagictools.jei.ClusterRecipeCategory;
import weissmoon.electromagictools.jei.ElectricInfusionWrapper;
import weissmoon.electromagictools.recipe.ElectricInfusionRecipe;

@JEIPlugin
public class JeiPlugin
implements IModPlugin {
    public void register(@Nonnull IModRegistry registry) {
        if (ElectroMagicTools.gtcxLoaded) {
            registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)ModItems.diamondChainsaw));
        }
        registry.addRecipeCatalyst((Object)new ItemStack(BlocksTC.arcaneWorkbench), new String[]{"minecraft.crafting"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlocksTC.infernalFurnace), new String[]{"minecraft.smelting"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerArcaneWorkbench.class, "minecraft.crafting", 1, 9, 16, 36);
        ArrayList clusterWrappers = new ArrayList();
        Utils.specialMiningResult.forEach((key, value) -> {
            ItemStack inputStack = new ItemStack((Item)key.get(0), 1, ((Integer)key.get(1)).intValue());
            clusterWrappers.add(new ClusterRecipeCategory.ClusterWrapper(inputStack, (ItemStack)value));
        });
        registry.addRecipes(clusterWrappers, "thaumcraft.clusters");
        if (ElectroMagicTools.thaumicJEILoaded) {
            registry.addRecipeCatalyst((Object)new ItemStack(BlocksTC.thaumatorium), new String[]{"THAUMCRAFT_CRUCIBLE"});
            registry.handleRecipes(ElectricInfusionRecipe.class, ElectricInfusionWrapper::new, "THAUMCRAFT_INFUSION");
            ElectricInfusionWrapper.initInfusionRecipes(registry);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ClusterRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        if (ElectroMagicTools.thaumicJEILoaded) {
            for (ResourceLocation string : ThaumcraftApi.getCraftingRecipes().keySet()) {
                IThaumcraftRecipe recipe = (IThaumcraftRecipe)ThaumcraftApi.getCraftingRecipes().get(string);
                if (!(recipe instanceof ElectricInfusionRecipe) || ((InfusionRecipe)recipe).getRecipeInput() == null || ((InfusionRecipe)recipe).recipeOutput == null) continue;
                List wrappers = jeiRuntime.getRecipeRegistry().getRecipeWrappers(jeiRuntime.getRecipeRegistry().getRecipeCategory("THAUMCRAFT_INFUSION"), jeiRuntime.getRecipeRegistry().createFocus(IFocus.Mode.OUTPUT, ((ElectricInfusionRecipe)recipe).recipeOutput));
                for (Object wrapper : wrappers) {
                    if (wrapper instanceof ElectricInfusionWrapper) continue;
                    jeiRuntime.getRecipeRegistry().hideRecipe((IRecipeWrapper)wrapper, "THAUMCRAFT_INFUSION");
                }
            }
        }
    }
}

