/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.configs;

import asmodeuscore.core.utils.ACCompatibilityManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class AsmodeusConfig {
    private static final String CATEGORY_MAP = "galaxymap";
    public static boolean loaded;
    public static Configuration config;
    public static boolean enableDebug;
    public static boolean enableRenderAtmosphere;
    public static int speedTimeTravel;
    public static boolean enableNewGalaxyMap;
    public static boolean enableNewTierSystem;
    public static boolean enable2DGalaxyMap;
    public static boolean enableImgOnGalaxyMap;
    public static boolean enableTimeTravelSystem;
    public static boolean enableDynamicImgOnGalaxyMap;
    public static boolean enableRequiredEquip;
    public static boolean enableRotateStars;
    public static boolean enableColorStars;
    public static boolean enableSkyOverworld;
    public static boolean enableSkyMoon;
    public static boolean enableSkyAsteroids;
    public static boolean enableSkyOverworldOrbit;
    public static boolean enableCloudsVenus;
    public static boolean enableBetterMoonOnSky;
    public static boolean enableRenderBody;
    public static boolean enableRenderDegreeSymbol;
    public static boolean enableWeatherDamage;
    public static boolean enableSublightEngine;
    public static int tempPosX;
    public static int tempPosY;
    public static int renderBodyPosY;
    public static float stormDamageRate;
    public static float toxicRainDamageRate;
    public static float atmospherePressureDamageRate;
    public static float solarRadiationDamageRate;
    public static String[] celestialBodyTiers;

    public AsmodeusConfig(File file) {
        if (!loaded) {
            config = new Configuration(file);
            AsmodeusConfig.syncConfig(true);
        }
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            Property prop = null;
            if (!AsmodeusConfig.config.isChild && load) {
                config.load();
            }
            if (ACCompatibilityManager.isGalacticraftLoaded()) {
                prop = config.get("general", "speedTimeTravel", speedTimeTravel);
                prop.setComment("Time Travel speed factor.");
                prop.setLanguageKey("ac.configgui.speedTimeTravel");
                speedTimeTravel = prop.getInt();
                propOrder.add(prop.getName());
                prop = config.get("client", "renderBodyPosY", renderBodyPosY);
                prop.setComment("Pos Y for render body on horizon.");
                prop.setLanguageKey("ac.configgui.renderBodyPosY");
                renderBodyPosY = prop.getInt();
                propOrder.add(prop.getName());
                prop = config.get("general", "enableRenderDegreeSymbol", true);
                prop.setComment("Enable/Disable render degree symbol.");
                prop.setLanguageKey("ac.configgui.enableRenderDegreeSymbol");
                enableRenderDegreeSymbol = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("client", "enableRenderBody", true);
                prop.setComment("Enable/Disable render body on horizon.");
                prop.setLanguageKey("ac.configgui.enableRenderBody");
                enableRenderBody = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get(CATEGORY_MAP, "enableNewGalaxyMap", true);
                prop.setComment("Enable/Disable New Galaxy Map.");
                prop.setLanguageKey("ac.configgui.enableNewGalaxyMap");
                enableNewGalaxyMap = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get(CATEGORY_MAP, "enableNewTierSystem", true);
                prop.setComment("Enable/Disable New Tier System.");
                prop.setLanguageKey("ac.configgui.enableNewTierSystem").setRequiresMcRestart(true);
                enableNewTierSystem = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get(CATEGORY_MAP, "enable2DGalaxyMap", false);
                prop.setComment("Enable/Disable 2D Galaxy Map. (like in GC2)");
                prop.setLanguageKey("ac.configgui.enable2DGalaxyMap");
                enable2DGalaxyMap = prop.getBoolean(false);
                propOrder.add(prop.getName());
                prop = config.get(CATEGORY_MAP, "enableImgOnGalaxyMap", true);
                prop.setComment("Enable/Disable background image on Galaxy Map. (If false, returned black color and grid)");
                prop.setLanguageKey("ac.configgui.enableImgOnGalaxyMap");
                enableImgOnGalaxyMap = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get(CATEGORY_MAP, "enableTimeTravelSystem", true);
                prop.setComment("Enable/Disable Time Travel System on Galaxy Map.");
                prop.setLanguageKey("ac.configgui.enableTimeTravelSystem");
                enableTimeTravelSystem = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get(CATEGORY_MAP, "enableDynamicImgOnGalaxyMap", true);
                prop.setComment("Enable/Disable dynamic image on map. (If disabled, image will static)");
                prop.setLanguageKey("ac.configgui.enableDynamicImgOnGalaxyMap");
                enableDynamicImgOnGalaxyMap = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("general", "tempPosX", tempPosX);
                prop.setComment("Offset temperature panel position X.");
                prop.setLanguageKey("ac.configgui.tempPosX");
                tempPosX = prop.getInt();
                propOrder.add(prop.getName());
                prop = config.get("general", "tempPosY", tempPosY);
                prop.setComment("Offset temperature panel position Y.");
                prop.setLanguageKey("ac.configgui.tempPosY");
                tempPosY = prop.getInt();
                propOrder.add(prop.getName());
                prop = config.get("client", "enableSkyOverworld", enableSkyOverworld);
                prop.setComment("Enable/Disable Advanced Sky Provider on Overworld (Not support shaders).");
                prop.setLanguageKey("gc.configgui.enableSkyOverworld").setRequiresMcRestart(false);
                enableSkyOverworld = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("client", "enableSkyOverworldOrbit", enableSkyOverworldOrbit);
                prop.setComment("Enable/Disable Advanced Sky Provider on Orbit Overworld (Not support shaders).");
                prop.setLanguageKey("gc.configgui.enableSkyOverworldOrbit").setRequiresMcRestart(false);
                enableSkyOverworldOrbit = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("client", "enableSkyMoon", enableSkyMoon);
                prop.setComment("Enable/Disable Advanced Sky Provider on Moon (Not support shaders).");
                prop.setLanguageKey("gc.configgui.enableSkyMoon").setRequiresMcRestart(false);
                enableSkyMoon = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("client", "enableSkyAsteroids", enableSkyAsteroids);
                prop.setComment("Enable/Disable Advanced Sky Provider on Asteroids (Not support shaders).");
                prop.setLanguageKey("gc.configgui.enableSkyAsteroids").setRequiresMcRestart(false);
                enableSkyAsteroids = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("client", "enableCloudsVenus", enableCloudsVenus);
                prop.setComment("Enable/Disable Render Clouds on Venus.");
                prop.setLanguageKey("gc.configgui.enableCloudsVenus").setRequiresMcRestart(false);
                enableCloudsVenus = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("client", "enableBetterMoonOnSky", enableBetterMoonOnSky);
                prop.setComment("Enable/Disable Render Clouds on Venus.");
                prop.setLanguageKey("gc.configgui.enableBetterMoonOnSky").setRequiresMcRestart(false);
                enableBetterMoonOnSky = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("general", "celestialBodyTiers", new String[]{"planet.example:5"});
                prop.setComment("Set custom tier for Celestial Bodies. Example: planet.mars:5");
                prop.setLanguageKey("gc.configgui.\u0441elestialBodyTiers").setRequiresMcRestart(true);
                celestialBodyTiers = prop.getStringList();
                propOrder.add(prop.getName());
            }
            prop = config.get("client", "enableRenderAtmosphere", true);
            prop.setComment("Enable/Disable render planet atmosphere on sky.");
            prop.setLanguageKey("ac.configgui.enableRenderAtmosphere");
            enableRenderAtmosphere = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("client", "enableRotateStars", true);
            prop.setComment("Enable/Disable rotate stars on sky.");
            prop.setLanguageKey("ac.configgui.enableRotateStars");
            enableRotateStars = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("client", "enableColorStars", false);
            prop.setComment("Enable/Disable render color stars on sky.");
            prop.setLanguageKey("ac.configgui.enableColorStars");
            enableColorStars = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableDebug", false);
            prop.setComment("Enable/Disable debug mode.");
            prop.setLanguageKey("ac.configgui.enableDebug");
            enableDebug = prop.getBoolean(false);
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableWeatherDamage", true);
            prop.setComment("Enable/Disable damage from weather (acid_rain, dust_storm, etc).");
            prop.setLanguageKey("ac.configgui.enableWeatherDamage");
            enableWeatherDamage = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get(CATEGORY_MAP, "enableSublightEngine", true);
            prop.setComment("Enable/Disable required sublight engine for travel in other star systems.");
            prop.setLanguageKey("ac.configgui.enableSublightEngine");
            enableSublightEngine = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("difficulty", "stormDamageRate", (double)stormDamageRate);
            prop.setComment("Damage rate for duststorms on celestial bodies.");
            prop.setLanguageKey("ac.configgui.stormDamageRate");
            stormDamageRate = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("difficulty", "toxicRainDamageRate", (double)toxicRainDamageRate);
            prop.setComment("Damage rate for toxic rain on celestial bodies.");
            prop.setLanguageKey("ac.configgui.toxicRainDamageRate");
            toxicRainDamageRate = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("difficulty", "atmospherePressureDamageRate", (double)atmospherePressureDamageRate);
            prop.setComment("Damage rate for atmosphere pressure on celestial bodies.");
            prop.setLanguageKey("ac.configgui.atmospherePressureDamageRate");
            atmospherePressureDamageRate = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("difficulty", "solarRadiationDamageRate", (double)solarRadiationDamageRate);
            prop.setComment("Damage rate for solar radiation on celestial bodies.");
            prop.setLanguageKey("ac.configgui.solarRadiationDamageRate");
            solarRadiationDamageRate = (float)prop.getDouble();
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Asmodeus Core has a problem loading it's config", (Object[])new Object[0]);
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("difficulty")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("client")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory(CATEGORY_MAP)).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("development")).getChildElements());
        return list;
    }

    static {
        speedTimeTravel = 1;
        enableNewGalaxyMap = true;
        enableNewTierSystem = true;
        enable2DGalaxyMap = false;
        enableImgOnGalaxyMap = true;
        enableTimeTravelSystem = true;
        enableDynamicImgOnGalaxyMap = true;
        enableRequiredEquip = false;
        enableRotateStars = false;
        enableColorStars = false;
        enableSkyOverworld = true;
        enableSkyMoon = true;
        enableSkyAsteroids = true;
        enableSkyOverworldOrbit = true;
        enableCloudsVenus = true;
        enableBetterMoonOnSky = false;
        enableRenderBody = true;
        enableRenderDegreeSymbol = true;
        enableWeatherDamage = true;
        enableSublightEngine = true;
        tempPosX = 0;
        tempPosY = 0;
        renderBodyPosY = 255;
        stormDamageRate = 1.0f;
        toxicRainDamageRate = 1.0f;
        atmospherePressureDamageRate = 1.0f;
        solarRadiationDamageRate = 1.0f;
    }
}

