/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.tcresearchpatcher;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.research.IScanThing;
import thecodex6824.tcresearchpatcher.api.internal.IInternalMethodHandler;
import thecodex6824.tcresearchpatcher.api.scan.IScanParser;

public class InternalMethodHandler
implements IInternalMethodHandler {
    protected ArrayList<ScanParserEntry> scanParsers = new ArrayList();
    protected boolean scanParsersSorted;

    @Override
    public void registerScanParser(IScanParser parser) {
        this.registerScanParser(parser, 0);
    }

    @Override
    public void registerScanParser(IScanParser parser, int weight) {
        this.scanParsers.add(new ScanParserEntry(parser, weight));
        this.scanParsersSorted = false;
    }

    @Override
    public Collection<IScanThing> parseScans(String key, ResourceLocation type, JsonElement data) {
        if (!this.scanParsersSorted) {
            this.scanParsers.sort((e1, e2) -> Integer.compare(e1.weight, e2.weight));
            this.scanParsersSorted = true;
        }
        RuntimeException throwLater = new RuntimeException("No parsers were able to load scan of type " + type);
        for (ScanParserEntry e : this.scanParsers) {
            IScanParser parser = e.parser;
            if (!parser.matches(type)) continue;
            try {
                return parser.parseScan(key, type, data);
            }
            catch (Exception ex) {
                throwLater.addSuppressed(ex);
            }
        }
        throw throwLater;
    }

    protected static class ScanParserEntry {
        public final IScanParser parser;
        public final int weight;

        public ScanParserEntry(IScanParser p, int w) {
            this.parser = p;
            this.weight = w;
        }
    }
}

